/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.streaming;

import ai2.org.apache.poi.openxml4j.opc.internal.ZipHelper;
import ai2.org.apache.poi.ss.formula.udf.UDFFinder;
import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.ss.usermodel.CreationHelper;
import ai2.org.apache.poi.ss.usermodel.DataFormat;
import ai2.org.apache.poi.ss.usermodel.Font;
import ai2.org.apache.poi.ss.usermodel.Name;
import ai2.org.apache.poi.ss.usermodel.PictureData;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.usermodel.Sheet;
import ai2.org.apache.poi.ss.usermodel.Workbook;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.TempFile;
import ai2.org.apache.poi.xssf.model.SharedStringsTable;
import ai2.org.apache.poi.xssf.streaming.GZIPSheetDataWriter;
import ai2.org.apache.poi.xssf.streaming.SXSSFCreationHelper;
import ai2.org.apache.poi.xssf.streaming.SXSSFSheet;
import ai2.org.apache.poi.xssf.streaming.SheetDataWriter;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SXSSFWorkbook
implements Workbook {
    public static final int DEFAULT_WINDOW_SIZE = 100;
    private static POILogger logger = POILogFactory.getLogger(SXSSFWorkbook.class);
    XSSFWorkbook _wb;
    HashMap<SXSSFSheet, XSSFSheet> _sxFromXHash = new HashMap();
    HashMap<XSSFSheet, SXSSFSheet> _xFromSxHash = new HashMap();
    private int _randomAccessWindowSize = 100;
    private boolean _compressTmpFiles = false;
    private SharedStringsTable _sharedStringSource = null;

    public SXSSFWorkbook() {
        this(null);
    }

    public SXSSFWorkbook(XSSFWorkbook xSSFWorkbook) {
        this(xSSFWorkbook, 100);
    }

    public SXSSFWorkbook(XSSFWorkbook xSSFWorkbook, int n) {
        this(xSSFWorkbook, n, false);
    }

    public SXSSFWorkbook(XSSFWorkbook xSSFWorkbook, int n, boolean bl) {
        this(xSSFWorkbook, n, bl, false);
    }

    public SXSSFWorkbook(XSSFWorkbook xSSFWorkbook, int n, boolean bl, boolean bl2) {
        this.setRandomAccessWindowSize(n);
        this.setCompressTempFiles(bl);
        if (xSSFWorkbook == null) {
            this._wb = new XSSFWorkbook();
            if (bl2) {
                this._sharedStringSource = this._wb.getSharedStringSource();
            }
        } else {
            this._wb = xSSFWorkbook;
            if (bl2) {
                this._sharedStringSource = this._wb.getSharedStringSource();
            }
            for (int i = 0; i < this._wb.getNumberOfSheets(); ++i) {
                XSSFSheet xSSFSheet = this._wb.getSheetAt(i);
                this.createAndRegisterSXSSFSheet(xSSFSheet);
            }
        }
    }

    public SXSSFWorkbook(int n) {
        this(null, n);
    }

    public int getRandomAccessWindowSize() {
        return this._randomAccessWindowSize;
    }

    private void setRandomAccessWindowSize(int n) {
        if (n == 0 || n < -1) {
            throw new IllegalArgumentException("rowAccessWindowSize must be greater than 0 or -1");
        }
        this._randomAccessWindowSize = n;
    }

    public void setCompressTempFiles(boolean bl) {
        this._compressTmpFiles = bl;
    }

    SheetDataWriter createSheetDataWriter() throws IOException {
        if (this._compressTmpFiles) {
            return new GZIPSheetDataWriter(this._sharedStringSource);
        }
        return new SheetDataWriter(this._sharedStringSource);
    }

    XSSFSheet getXSSFSheet(SXSSFSheet sXSSFSheet) {
        XSSFSheet xSSFSheet = this._sxFromXHash.get(sXSSFSheet);
        return xSSFSheet;
    }

    SXSSFSheet getSXSSFSheet(XSSFSheet xSSFSheet) {
        SXSSFSheet sXSSFSheet = this._xFromSxHash.get(xSSFSheet);
        return sXSSFSheet;
    }

    void registerSheetMapping(SXSSFSheet sXSSFSheet, XSSFSheet xSSFSheet) {
        this._sxFromXHash.put(sXSSFSheet, xSSFSheet);
        this._xFromSxHash.put(xSSFSheet, sXSSFSheet);
    }

    void deregisterSheetMapping(XSSFSheet xSSFSheet) {
        SXSSFSheet sXSSFSheet = this.getSXSSFSheet(xSSFSheet);
        try {
            sXSSFSheet.getSheetDataWriter().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._sxFromXHash.remove(sXSSFSheet);
        this._xFromSxHash.remove(xSSFSheet);
    }

    private XSSFSheet getSheetFromZipEntryName(String string) {
        for (XSSFSheet xSSFSheet : this._sxFromXHash.values()) {
            if (!string.equals(xSSFSheet.getPackagePart().getPartName().getName().substring(1))) continue;
            return xSSFSheet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectData(File file, OutputStream outputStream) throws IOException {
        ZipFile zipFile = ZipHelper.openZipFile(file);
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            try {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    XSSFSheet xSSFSheet = this.getSheetFromZipEntryName(zipEntry.getName());
                    if (xSSFSheet != null) {
                        SXSSFSheet sXSSFSheet = this.getSXSSFSheet(xSSFSheet);
                        InputStream inputStream2 = sXSSFSheet.getWorksheetXMLInputStream();
                        try {
                            SXSSFWorkbook.copyStreamAndInjectWorksheet(inputStream, zipOutputStream, inputStream2);
                        }
                        finally {
                            inputStream2.close();
                        }
                    } else {
                        SXSSFWorkbook.copyStream(inputStream, zipOutputStream);
                    }
                    inputStream.close();
                }
            }
            finally {
                zipOutputStream.close();
            }
        }
        finally {
            zipFile.close();
        }
    }

    private static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static void copyStreamAndInjectWorksheet(InputStream inputStream, OutputStream outputStream, InputStream inputStream2) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        boolean bl = true;
        int n2 = 0;
        String string = "<sheetData";
        int n3 = string.length();
        while ((n = inputStreamReader.read()) != -1) {
            if (n == string.charAt(n2)) {
                if (++n2 != n3) continue;
                if (!"<sheetData".equals(string)) break;
                n = inputStreamReader.read();
                if (n == -1) {
                    outputStreamWriter.write(string);
                    break;
                }
                if (n == 62) {
                    outputStreamWriter.write(string);
                    outputStreamWriter.write(n);
                    string = "</sheetData>";
                    n3 = string.length();
                    n2 = 0;
                    bl = false;
                    continue;
                }
                if (n == 47) {
                    n = inputStreamReader.read();
                    if (n == -1) {
                        outputStreamWriter.write(string);
                        break;
                    }
                    if (n == 62) break;
                    outputStreamWriter.write(string);
                    outputStreamWriter.write(47);
                    outputStreamWriter.write(n);
                    n2 = 0;
                    continue;
                }
                outputStreamWriter.write(string);
                outputStreamWriter.write(47);
                outputStreamWriter.write(n);
                n2 = 0;
                continue;
            }
            if (n2 > 0) {
                outputStreamWriter.write(string, 0, n2);
            }
            if (n == string.charAt(0)) {
                n2 = 1;
                continue;
            }
            outputStreamWriter.write(n);
            n2 = 0;
        }
        outputStreamWriter.flush();
        if (bl) {
            outputStreamWriter.write("<sheetData>\n");
            outputStreamWriter.flush();
        }
        SXSSFWorkbook.copyStream(inputStream2, outputStream);
        outputStreamWriter.write("</sheetData>");
        outputStreamWriter.flush();
        while ((n = inputStreamReader.read()) != -1) {
            outputStreamWriter.write(n);
        }
        outputStreamWriter.flush();
    }

    public XSSFWorkbook getXSSFWorkbook() {
        return this._wb;
    }

    @Override
    public int getActiveSheetIndex() {
        return this._wb.getActiveSheetIndex();
    }

    @Override
    public void setActiveSheet(int n) {
        this._wb.setActiveSheet(n);
    }

    @Override
    public int getFirstVisibleTab() {
        return this._wb.getFirstVisibleTab();
    }

    @Override
    public void setFirstVisibleTab(int n) {
        this._wb.setFirstVisibleTab(n);
    }

    @Override
    public void setSheetOrder(String string, int n) {
        this._wb.setSheetOrder(string, n);
    }

    @Override
    public void setSelectedTab(int n) {
        this._wb.setSelectedTab(n);
    }

    @Override
    public void setSheetName(int n, String string) {
        this._wb.setSheetName(n, string);
    }

    @Override
    public String getSheetName(int n) {
        return this._wb.getSheetName(n);
    }

    @Override
    public int getSheetIndex(String string) {
        return this._wb.getSheetIndex(string);
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        return this._wb.getSheetIndex(this.getXSSFSheet((SXSSFSheet)sheet));
    }

    @Override
    public SXSSFSheet createSheet() {
        return this.createAndRegisterSXSSFSheet(this._wb.createSheet());
    }

    SXSSFSheet createAndRegisterSXSSFSheet(XSSFSheet xSSFSheet) {
        SXSSFSheet sXSSFSheet = null;
        try {
            sXSSFSheet = new SXSSFSheet(this, xSSFSheet);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.registerSheetMapping(sXSSFSheet, xSSFSheet);
        return sXSSFSheet;
    }

    @Override
    public SXSSFSheet createSheet(String string) {
        return this.createAndRegisterSXSSFSheet(this._wb.createSheet(string));
    }

    @Override
    public Sheet cloneSheet(int n) {
        throw new RuntimeException("NotImplemented");
    }

    @Override
    public int getNumberOfSheets() {
        return this._wb.getNumberOfSheets();
    }

    @Override
    public Iterator<Sheet> sheetIterator() {
        return new SheetIterator<Sheet>();
    }

    @Override
    public Iterator<Sheet> iterator() {
        return this.sheetIterator();
    }

    @Override
    public SXSSFSheet getSheetAt(int n) {
        return this.getSXSSFSheet(this._wb.getSheetAt(n));
    }

    @Override
    public SXSSFSheet getSheet(String string) {
        return this.getSXSSFSheet(this._wb.getSheet(string));
    }

    @Override
    public void removeSheetAt(int n) {
        XSSFSheet xSSFSheet = this._wb.getSheetAt(n);
        SXSSFSheet sXSSFSheet = this.getSXSSFSheet(xSSFSheet);
        this._wb.removeSheetAt(n);
        this.deregisterSheetMapping(xSSFSheet);
        try {
            sXSSFSheet.dispose();
        }
        catch (IOException iOException) {
            logger.log(5, new Object[]{iOException});
        }
    }

    @Override
    @Deprecated
    public void setRepeatingRowsAndColumns(int n, int n2, int n3, int n4, int n5) {
        this._wb.setRepeatingRowsAndColumns(n, n2, n3, n4, n5);
    }

    @Override
    public Font createFont() {
        return this._wb.createFont();
    }

    @Override
    public Font findFont(short s, short s2, short s3, String string, boolean bl, boolean bl2, short s4, byte by) {
        return this._wb.findFont(s, s2, s3, string, bl, bl2, s4, by);
    }

    @Override
    public short getNumberOfFonts() {
        return this._wb.getNumberOfFonts();
    }

    @Override
    public Font getFontAt(short s) {
        return this._wb.getFontAt(s);
    }

    @Override
    public CellStyle createCellStyle() {
        return this._wb.createCellStyle();
    }

    @Override
    public short getNumCellStyles() {
        return this._wb.getNumCellStyles();
    }

    @Override
    public CellStyle getCellStyleAt(short s) {
        return this._wb.getCellStyleAt(s);
    }

    @Override
    public void close() throws IOException {
        for (SXSSFSheet sXSSFSheet : this._xFromSxHash.values()) {
            try {
                sXSSFSheet.getSheetDataWriter().close();
            }
            catch (IOException iOException) {}
        }
        this._wb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream outputStream) throws IOException {
        for (SXSSFSheet object : this._xFromSxHash.values()) {
            object.flushRows();
        }
        File file = TempFile.createTempFile("poi-sxssf-template", ".xlsx");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                this._wb.write(fileOutputStream);
            }
            finally {
                fileOutputStream.close();
            }
            this.injectData(file, outputStream);
        }
        finally {
            if (!file.delete()) {
                throw new IOException("Could not delete temporary file after processing: " + file);
            }
        }
    }

    public boolean dispose() {
        boolean bl = true;
        for (SXSSFSheet sXSSFSheet : this._sxFromXHash.keySet()) {
            try {
                bl = sXSSFSheet.dispose() && bl;
            }
            catch (IOException iOException) {
                logger.log(5, new Object[]{iOException});
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public int getNumberOfNames() {
        return this._wb.getNumberOfNames();
    }

    @Override
    public Name getName(String string) {
        return this._wb.getName(string);
    }

    @Override
    public Name getNameAt(int n) {
        return this._wb.getNameAt(n);
    }

    @Override
    public Name createName() {
        return this._wb.createName();
    }

    @Override
    public int getNameIndex(String string) {
        return this._wb.getNameIndex(string);
    }

    @Override
    public void removeName(int n) {
        this._wb.removeName(n);
    }

    @Override
    public void removeName(String string) {
        this._wb.removeName(string);
    }

    @Override
    public void setPrintArea(int n, String string) {
        this._wb.setPrintArea(n, string);
    }

    @Override
    public void setPrintArea(int n, int n2, int n3, int n4, int n5) {
        this._wb.setPrintArea(n, n2, n3, n4, n5);
    }

    @Override
    public String getPrintArea(int n) {
        return this._wb.getPrintArea(n);
    }

    @Override
    public void removePrintArea(int n) {
        this._wb.removePrintArea(n);
    }

    @Override
    public Row.MissingCellPolicy getMissingCellPolicy() {
        return this._wb.getMissingCellPolicy();
    }

    @Override
    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        this._wb.setMissingCellPolicy(missingCellPolicy);
    }

    @Override
    public DataFormat createDataFormat() {
        return this._wb.createDataFormat();
    }

    @Override
    public int addPicture(byte[] byArray, int n) {
        return this._wb.addPicture(byArray, n);
    }

    @Override
    public List<? extends PictureData> getAllPictures() {
        return this._wb.getAllPictures();
    }

    @Override
    public CreationHelper getCreationHelper() {
        return new SXSSFCreationHelper(this);
    }

    protected boolean isDate1904() {
        return this._wb.isDate1904();
    }

    @Override
    public boolean isHidden() {
        return this._wb.isHidden();
    }

    @Override
    public void setHidden(boolean bl) {
        this._wb.setHidden(bl);
    }

    @Override
    public boolean isSheetHidden(int n) {
        return this._wb.isSheetHidden(n);
    }

    @Override
    public boolean isSheetVeryHidden(int n) {
        return this._wb.isSheetVeryHidden(n);
    }

    @Override
    public void setSheetHidden(int n, boolean bl) {
        this._wb.setSheetHidden(n, bl);
    }

    @Override
    public void setSheetHidden(int n, int n2) {
        this._wb.setSheetHidden(n, n2);
    }

    @Override
    public int linkExternalWorkbook(String string, Workbook workbook) {
        throw new RuntimeException("NotImplemented");
    }

    @Override
    public void addToolPack(UDFFinder uDFFinder) {
        this._wb.addToolPack(uDFFinder);
    }

    @Override
    public void setForceFormulaRecalculation(boolean bl) {
        this._wb.setForceFormulaRecalculation(bl);
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        return this._wb.getForceFormulaRecalculation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SheetIterator<T extends Sheet>
    implements Iterator<T> {
        private final Iterator<XSSFSheet> it;

        public SheetIterator() {
            this.it = SXSSFWorkbook.this._wb.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() throws NoSuchElementException {
            XSSFSheet xSSFSheet = this.it.next();
            SXSSFSheet sXSSFSheet = SXSSFWorkbook.this.getSXSSFSheet(xSSFSheet);
            return (T)sXSSFSheet;
        }

        @Override
        public void remove() throws IllegalStateException {
            throw new UnsupportedOperationException("remove method not supported on XSSFWorkbook.iterator(). Use Sheet.removeSheetAt(int) instead.");
        }
    }
}

