/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.streaming;

import ai2.org.apache.poi.ss.usermodel.ClientAnchor;
import ai2.org.apache.poi.ss.usermodel.CreationHelper;
import ai2.org.apache.poi.ss.usermodel.DataFormat;
import ai2.org.apache.poi.ss.usermodel.ExtendedColor;
import ai2.org.apache.poi.ss.usermodel.Hyperlink;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xssf.streaming.SXSSFFormulaEvaluator;
import ai2.org.apache.poi.xssf.streaming.SXSSFWorkbook;
import ai2.org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import ai2.org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class SXSSFCreationHelper
implements CreationHelper {
    private static POILogger logger = POILogFactory.getLogger(SXSSFCreationHelper.class);
    private SXSSFWorkbook wb;
    private XSSFCreationHelper helper;

    public SXSSFCreationHelper(SXSSFWorkbook sXSSFWorkbook) {
        this.helper = new XSSFCreationHelper(sXSSFWorkbook.getXSSFWorkbook());
        this.wb = sXSSFWorkbook;
    }

    public XSSFRichTextString createRichTextString(String string) {
        logger.log(3, new Object[]{"SXSSF doesn't support Rich Text Strings, any formatting information will be lost"});
        return new XSSFRichTextString(string);
    }

    public SXSSFFormulaEvaluator createFormulaEvaluator() {
        return new SXSSFFormulaEvaluator(this.wb);
    }

    public DataFormat createDataFormat() {
        return this.helper.createDataFormat();
    }

    public Hyperlink createHyperlink(int n) {
        return this.helper.createHyperlink(n);
    }

    public ExtendedColor createExtendedColor() {
        return this.helper.createExtendedColor();
    }

    public ClientAnchor createClientAnchor() {
        return this.helper.createClientAnchor();
    }
}

