/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.model;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.xssf.usermodel.XSSFColor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;

public class ThemesTable
extends POIXMLDocumentPart {
    private ThemeDocument theme;

    public ThemesTable() {
        this.theme = ThemeDocument.Factory.newInstance();
        this.theme.addNewTheme().addNewThemeElements();
    }

    public ThemesTable(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
        try {
            this.theme = ThemeDocument.Factory.parse((InputStream)packagePart.getInputStream());
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getLocalizedMessage(), xmlException);
        }
    }

    public ThemesTable(ThemeDocument themeDocument) {
        this.theme = themeDocument;
    }

    public XSSFColor getThemeColor(int n) {
        CTColor cTColor;
        CTColorScheme cTColorScheme = this.theme.getTheme().getThemeElements().getClrScheme();
        switch (ThemeElement.byId(n)) {
            case LT1: {
                cTColor = cTColorScheme.getLt1();
                break;
            }
            case DK1: {
                cTColor = cTColorScheme.getDk1();
                break;
            }
            case LT2: {
                cTColor = cTColorScheme.getLt2();
                break;
            }
            case DK2: {
                cTColor = cTColorScheme.getDk2();
                break;
            }
            case ACCENT1: {
                cTColor = cTColorScheme.getAccent1();
                break;
            }
            case ACCENT2: {
                cTColor = cTColorScheme.getAccent2();
                break;
            }
            case ACCENT3: {
                cTColor = cTColorScheme.getAccent3();
                break;
            }
            case ACCENT4: {
                cTColor = cTColorScheme.getAccent4();
                break;
            }
            case ACCENT5: {
                cTColor = cTColorScheme.getAccent5();
                break;
            }
            case ACCENT6: {
                cTColor = cTColorScheme.getAccent6();
                break;
            }
            case HLINK: {
                cTColor = cTColorScheme.getHlink();
                break;
            }
            case FOLHLINK: {
                cTColor = cTColorScheme.getFolHlink();
                break;
            }
            default: {
                return null;
            }
        }
        byte[] byArray = null;
        if (cTColor.isSetSrgbClr()) {
            byArray = cTColor.getSrgbClr().getVal();
        } else if (cTColor.isSetSysClr()) {
            byArray = cTColor.getSysClr().getLastClr();
        } else {
            return null;
        }
        return new XSSFColor(byArray);
    }

    public void inheritFromThemeAsRequired(XSSFColor xSSFColor) {
        if (xSSFColor == null) {
            return;
        }
        if (!xSSFColor.getCTColor().isSetTheme()) {
            return;
        }
        XSSFColor xSSFColor2 = this.getThemeColor(xSSFColor.getTheme());
        xSSFColor.getCTColor().setRgb(xSSFColor2.getCTColor().getRgb());
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        this.theme.save(outputStream, xmlOptions);
    }

    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.writeTo(outputStream);
        outputStream.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThemeElement {
        LT1(0, "Lt1"),
        DK1(1, "Dk1"),
        LT2(2, "Lt2"),
        DK2(3, "Dk2"),
        ACCENT1(4, "Accent1"),
        ACCENT2(5, "Accent2"),
        ACCENT3(6, "Accent3"),
        ACCENT4(7, "Accent4"),
        ACCENT5(8, "Accent5"),
        ACCENT6(9, "Accent6"),
        HLINK(10, "Hlink"),
        FOLHLINK(11, "FolHlink"),
        UNKNOWN(-1, null);

        public final int idx;
        public final String name;

        public static ThemeElement byId(int n) {
            if (n >= ThemeElement.values().length || n < 0) {
                return UNKNOWN;
            }
            return ThemeElement.values()[n];
        }

        private ThemeElement(int n2, String string2) {
            this.idx = n2;
            this.name = string2;
        }
    }
}

