/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.model;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.usermodel.FontFamily;
import ai2.org.apache.poi.ss.usermodel.FontScheme;
import ai2.org.apache.poi.xssf.model.ThemesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import ai2.org.apache.poi.xssf.usermodel.XSSFFactory;
import ai2.org.apache.poi.xssf.usermodel.XSSFFont;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ai2.org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import ai2.org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorders;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyleXfs;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellXfs;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxfs;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFills;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFonts;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumFmts;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTStylesheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.StyleSheetDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylesTable
extends POIXMLDocumentPart {
    private final Map<Integer, String> numberFormats = new HashMap<Integer, String>();
    private final boolean[] usedNumberFormats = new boolean[SpreadsheetVersion.EXCEL2007.getMaxCellStyles()];
    private final List<XSSFFont> fonts = new ArrayList<XSSFFont>();
    private final List<XSSFCellFill> fills = new ArrayList<XSSFCellFill>();
    private final List<XSSFCellBorder> borders = new ArrayList<XSSFCellBorder>();
    private final List<CTXf> styleXfs = new ArrayList<CTXf>();
    private final List<CTXf> xfs = new ArrayList<CTXf>();
    private final List<CTDxf> dxfs = new ArrayList<CTDxf>();
    public static final int FIRST_CUSTOM_STYLE_ID = 165;
    private static final int MAXIMUM_STYLE_ID = SpreadsheetVersion.EXCEL2007.getMaxCellStyles();
    private StyleSheetDocument doc;
    private XSSFWorkbook workbook;
    private ThemesTable theme;

    public StylesTable() {
        this.doc = StyleSheetDocument.Factory.newInstance();
        this.doc.addNewStyleSheet();
        this.initialize();
    }

    public StylesTable(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
        this.readFrom(packagePart.getInputStream());
    }

    public void setWorkbook(XSSFWorkbook xSSFWorkbook) {
        this.workbook = xSSFWorkbook;
    }

    public ThemesTable getTheme() {
        return this.theme;
    }

    public void setTheme(ThemesTable themesTable) {
        this.theme = themesTable;
        for (XSSFFont object : this.fonts) {
            object.setThemesTable(themesTable);
        }
        for (XSSFCellBorder xSSFCellBorder : this.borders) {
            xSSFCellBorder.setThemesTable(themesTable);
        }
    }

    public void ensureThemesTable() {
        if (this.theme != null) {
            return;
        }
        this.theme = (ThemesTable)this.workbook.createRelationship(XSSFRelation.THEME, XSSFFactory.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    protected void readFrom(InputStream inputStream) throws IOException {
        try {
            CTDxfs cTDxfs;
            CTCellStyleXfs cTCellStyleXfs;
            CTCellXfs cTCellXfs;
            CTBorders cTBorders;
            CTFills cTFills;
            int n;
            int n2;
            CTFonts cTFonts;
            this.doc = StyleSheetDocument.Factory.parse((InputStream)inputStream);
            CTStylesheet cTStylesheet = this.doc.getStyleSheet();
            CTNumFmts cTNumFmts = cTStylesheet.getNumFmts();
            if (cTNumFmts != null) {
                cTFonts = cTNumFmts.getNumFmtArray();
                n2 = ((CTFonts)cTFonts).length;
                for (int i = 0; i < n2; ++i) {
                    CTFonts cTFonts2 = cTFonts[i];
                    n = (int)cTFonts2.getNumFmtId();
                    this.numberFormats.put(n, cTFonts2.getFormatCode());
                    this.usedNumberFormats[n] = true;
                }
            }
            if ((cTFonts = cTStylesheet.getFonts()) != null) {
                n2 = 0;
                CTFont[] cTFontArray = cTFonts.getFontArray();
                int n3 = cTFontArray.length;
                for (n = 0; n < n3; ++n) {
                    CTFont cTFont = cTFontArray[n];
                    XSSFFont xSSFFont = new XSSFFont(cTFont, n2);
                    this.fonts.add(xSSFFont);
                    ++n2;
                }
            }
            if ((cTFills = cTStylesheet.getFills()) != null) {
                for (CTFill cTDxfs2 : cTFills.getFillArray()) {
                    this.fills.add(new XSSFCellFill(cTDxfs2));
                }
            }
            if ((cTBorders = cTStylesheet.getBorders()) != null) {
                void var9_23;
                CTBorder[] cTBorderArray = cTBorders.getBorderArray();
                n = cTBorderArray.length;
                boolean bl = false;
                while (var9_23 < n) {
                    CTBorder cTBorder = cTBorderArray[var9_23];
                    this.borders.add(new XSSFCellBorder(cTBorder));
                    ++var9_23;
                }
            }
            if ((cTCellXfs = cTStylesheet.getCellXfs()) != null) {
                this.xfs.addAll(Arrays.asList(cTCellXfs.getXfArray()));
            }
            if ((cTCellStyleXfs = cTStylesheet.getCellStyleXfs()) != null) {
                this.styleXfs.addAll(Arrays.asList(cTCellStyleXfs.getXfArray()));
            }
            if ((cTDxfs = cTStylesheet.getDxfs()) != null) {
                this.dxfs.addAll(Arrays.asList(cTDxfs.getDxfArray()));
            }
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getLocalizedMessage());
        }
    }

    public String getNumberFormatAt(int n) {
        return this.numberFormats.get(n);
    }

    public int putNumberFormat(String string) {
        if (this.numberFormats.containsValue(string)) {
            for (Map.Entry<Integer, String> entry : this.numberFormats.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                return entry.getKey();
            }
            throw new IllegalStateException("Found the format, but couldn't figure out where - should never happen!");
        }
        for (int i = 165; i < this.usedNumberFormats.length; ++i) {
            if (this.usedNumberFormats[i]) continue;
            this.usedNumberFormats[i] = true;
            this.numberFormats.put(i, string);
            return i;
        }
        throw new IllegalStateException("The maximum number of Data Formats was exceeded. You can define up to " + this.usedNumberFormats.length + " formats in a .xlsx Workbook");
    }

    public XSSFFont getFontAt(int n) {
        return this.fonts.get(n);
    }

    public int putFont(XSSFFont xSSFFont, boolean bl) {
        int n = -1;
        if (!bl) {
            n = this.fonts.indexOf(xSSFFont);
        }
        if (n != -1) {
            return n;
        }
        n = this.fonts.size();
        this.fonts.add(xSSFFont);
        return n;
    }

    public int putFont(XSSFFont xSSFFont) {
        return this.putFont(xSSFFont, false);
    }

    public XSSFCellStyle getStyleAt(int n) {
        int n2 = 0;
        if (this.xfs.get(n).getXfId() > 0L) {
            n2 = (int)this.xfs.get(n).getXfId();
        }
        return new XSSFCellStyle(n, n2, this, this.theme);
    }

    public int putStyle(XSSFCellStyle xSSFCellStyle) {
        CTXf cTXf = xSSFCellStyle.getCoreXf();
        if (!this.xfs.contains(cTXf)) {
            this.xfs.add(cTXf);
        }
        return this.xfs.indexOf(cTXf);
    }

    public XSSFCellBorder getBorderAt(int n) {
        return this.borders.get(n);
    }

    public int putBorder(XSSFCellBorder xSSFCellBorder) {
        int n = this.borders.indexOf(xSSFCellBorder);
        if (n != -1) {
            return n;
        }
        this.borders.add(xSSFCellBorder);
        xSSFCellBorder.setThemesTable(this.theme);
        return this.borders.size() - 1;
    }

    public XSSFCellFill getFillAt(int n) {
        return this.fills.get(n);
    }

    public List<XSSFCellBorder> getBorders() {
        return this.borders;
    }

    public List<XSSFCellFill> getFills() {
        return this.fills;
    }

    public List<XSSFFont> getFonts() {
        return this.fonts;
    }

    public Map<Integer, String> getNumberFormats() {
        return this.numberFormats;
    }

    public int putFill(XSSFCellFill xSSFCellFill) {
        int n = this.fills.indexOf(xSSFCellFill);
        if (n != -1) {
            return n;
        }
        this.fills.add(xSSFCellFill);
        return this.fills.size() - 1;
    }

    public CTXf getCellXfAt(int n) {
        return this.xfs.get(n);
    }

    public int putCellXf(CTXf cTXf) {
        this.xfs.add(cTXf);
        return this.xfs.size();
    }

    public void replaceCellXfAt(int n, CTXf cTXf) {
        this.xfs.set(n, cTXf);
    }

    public CTXf getCellStyleXfAt(int n) {
        return n < this.styleXfs.size() ? this.styleXfs.get(n) : null;
    }

    public int putCellStyleXf(CTXf cTXf) {
        this.styleXfs.add(cTXf);
        return this.styleXfs.size();
    }

    public void replaceCellStyleXfAt(int n, CTXf cTXf) {
        this.styleXfs.set(n, cTXf);
    }

    public int getNumCellStyles() {
        return this.xfs.size();
    }

    public int _getNumberFormatSize() {
        return this.numberFormats.size();
    }

    public int _getXfsSize() {
        return this.xfs.size();
    }

    public int _getStyleXfsSize() {
        return this.styleXfs.size();
    }

    public CTStylesheet getCTStylesheet() {
        return this.doc.getStyleSheet();
    }

    public int _getDXfsSize() {
        return this.dxfs.size();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        CTCellXfs cTCellXfs;
        CTFonts cTFonts;
        int n;
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        CTStylesheet cTStylesheet = this.doc.getStyleSheet();
        CTNumFmts cTNumFmts = CTNumFmts.Factory.newInstance();
        cTNumFmts.setCount((long)this.numberFormats.size());
        for (n = 0; n < this.usedNumberFormats.length; ++n) {
            if (!this.usedNumberFormats[n]) continue;
            cTFonts = cTNumFmts.addNewNumFmt();
            cTFonts.setNumFmtId((long)n);
            cTFonts.setFormatCode(this.numberFormats.get(n));
        }
        cTStylesheet.setNumFmts(cTNumFmts);
        cTFonts = cTStylesheet.getFonts();
        if (cTFonts == null) {
            cTFonts = CTFonts.Factory.newInstance();
        }
        cTFonts.setCount((long)this.fonts.size());
        CTFont[] cTFontArray = new CTFont[this.fonts.size()];
        n = 0;
        for (XSSFFont cTFillArray2 : this.fonts) {
            cTFontArray[n++] = cTFillArray2.getCTFont();
        }
        cTFonts.setFontArray(cTFontArray);
        cTStylesheet.setFonts(cTFonts);
        CTFills cTFills = cTStylesheet.getFills();
        if (cTFills == null) {
            cTFills = CTFills.Factory.newInstance();
        }
        cTFills.setCount((long)this.fills.size());
        CTFill[] cTFillArray = new CTFill[this.fills.size()];
        n = 0;
        for (XSSFCellFill xSSFCellFill : this.fills) {
            cTFillArray[n++] = xSSFCellFill.getCTFill();
        }
        cTFills.setFillArray(cTFillArray);
        cTStylesheet.setFills(cTFills);
        CTBorders cTBorders = cTStylesheet.getBorders();
        if (cTBorders == null) {
            cTBorders = CTBorders.Factory.newInstance();
        }
        cTBorders.setCount((long)this.borders.size());
        CTBorder[] cTBorderArray = new CTBorder[this.borders.size()];
        n = 0;
        for (XSSFCellBorder xSSFCellBorder : this.borders) {
            cTBorderArray[n++] = xSSFCellBorder.getCTBorder();
        }
        cTBorders.setBorderArray(cTBorderArray);
        cTStylesheet.setBorders(cTBorders);
        if (this.xfs.size() > 0) {
            cTCellXfs = cTStylesheet.getCellXfs();
            if (cTCellXfs == null) {
                cTCellXfs = CTCellXfs.Factory.newInstance();
            }
            cTCellXfs.setCount((long)this.xfs.size());
            cTCellXfs.setXfArray(this.xfs.toArray(new CTXf[this.xfs.size()]));
            cTStylesheet.setCellXfs(cTCellXfs);
        }
        if (this.styleXfs.size() > 0) {
            cTCellXfs = cTStylesheet.getCellStyleXfs();
            if (cTCellXfs == null) {
                cTCellXfs = CTCellStyleXfs.Factory.newInstance();
            }
            cTCellXfs.setCount((long)this.styleXfs.size());
            cTCellXfs.setXfArray(this.styleXfs.toArray(new CTXf[this.styleXfs.size()]));
            cTStylesheet.setCellStyleXfs((CTCellStyleXfs)cTCellXfs);
        }
        if (this.dxfs.size() > 0) {
            cTCellXfs = cTStylesheet.getDxfs();
            if (cTCellXfs == null) {
                cTCellXfs = CTDxfs.Factory.newInstance();
            }
            cTCellXfs.setCount((long)this.dxfs.size());
            cTCellXfs.setDxfArray(this.dxfs.toArray(new CTDxf[this.dxfs.size()]));
            cTStylesheet.setDxfs((CTDxfs)cTCellXfs);
        }
        this.doc.save(outputStream, xmlOptions);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.writeTo(outputStream);
        outputStream.close();
    }

    private void initialize() {
        XSSFFont xSSFFont = StylesTable.createDefaultFont();
        this.fonts.add(xSSFFont);
        CTFill[] cTFillArray = StylesTable.createDefaultFills();
        this.fills.add(new XSSFCellFill(cTFillArray[0]));
        this.fills.add(new XSSFCellFill(cTFillArray[1]));
        CTBorder cTBorder = StylesTable.createDefaultBorder();
        this.borders.add(new XSSFCellBorder(cTBorder));
        CTXf cTXf = StylesTable.createDefaultXf();
        this.styleXfs.add(cTXf);
        CTXf cTXf2 = StylesTable.createDefaultXf();
        cTXf2.setXfId(0L);
        this.xfs.add(cTXf2);
    }

    private static CTXf createDefaultXf() {
        CTXf cTXf = CTXf.Factory.newInstance();
        cTXf.setNumFmtId(0L);
        cTXf.setFontId(0L);
        cTXf.setFillId(0L);
        cTXf.setBorderId(0L);
        return cTXf;
    }

    private static CTBorder createDefaultBorder() {
        CTBorder cTBorder = CTBorder.Factory.newInstance();
        cTBorder.addNewBottom();
        cTBorder.addNewTop();
        cTBorder.addNewLeft();
        cTBorder.addNewRight();
        cTBorder.addNewDiagonal();
        return cTBorder;
    }

    private static CTFill[] createDefaultFills() {
        CTFill[] cTFillArray = new CTFill[]{CTFill.Factory.newInstance(), CTFill.Factory.newInstance()};
        cTFillArray[0].addNewPatternFill().setPatternType(STPatternType.NONE);
        cTFillArray[1].addNewPatternFill().setPatternType(STPatternType.DARK_GRAY);
        return cTFillArray;
    }

    private static XSSFFont createDefaultFont() {
        CTFont cTFont = CTFont.Factory.newInstance();
        XSSFFont xSSFFont = new XSSFFont(cTFont, 0);
        xSSFFont.setFontHeightInPoints((short)11);
        xSSFFont.setColor(XSSFFont.DEFAULT_FONT_COLOR);
        xSSFFont.setFontName("Calibri");
        xSSFFont.setFamily(FontFamily.SWISS);
        xSSFFont.setScheme(FontScheme.MINOR);
        return xSSFFont;
    }

    public CTDxf getDxfAt(int n) {
        return this.dxfs.get(n);
    }

    public int putDxf(CTDxf cTDxf) {
        this.dxfs.add(cTDxf);
        return this.dxfs.size();
    }

    public XSSFCellStyle createCellStyle() {
        if (this.getNumCellStyles() > MAXIMUM_STYLE_ID) {
            throw new IllegalStateException("The maximum number of Cell Styles was exceeded. You can define up to " + MAXIMUM_STYLE_ID + " style in a .xlsx Workbook");
        }
        int n = this.styleXfs.size();
        CTXf cTXf = CTXf.Factory.newInstance();
        cTXf.setNumFmtId(0L);
        cTXf.setFontId(0L);
        cTXf.setFillId(0L);
        cTXf.setBorderId(0L);
        cTXf.setXfId(0L);
        int n2 = this.putCellXf(cTXf);
        return new XSSFCellStyle(n2 - 1, n - 1, this, this.theme);
    }

    public XSSFFont findFont(short s, short s2, short s3, String string, boolean bl, boolean bl2, short s4, byte by) {
        for (XSSFFont xSSFFont : this.fonts) {
            if (xSSFFont.getBoldweight() != s || xSSFFont.getColor() != s2 || xSSFFont.getFontHeight() != s3 || !xSSFFont.getFontName().equals(string) || xSSFFont.getItalic() != bl || xSSFFont.getStrikeout() != bl2 || xSSFFont.getTypeOffset() != s4 || xSSFFont.getUnderline() != by) continue;
            return xSSFFont;
        }
        return null;
    }
}

