/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.model;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.ss.usermodel.Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalDefinedName;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalLink;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalSheetName;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.ExternalLinkDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalLinksTable
extends POIXMLDocumentPart {
    private CTExternalLink link;

    public ExternalLinksTable() {
        this.link = CTExternalLink.Factory.newInstance();
        this.link.addNewExternalBook();
    }

    public ExternalLinksTable(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException {
        try {
            ExternalLinkDocument externalLinkDocument = ExternalLinkDocument.Factory.parse((InputStream)inputStream);
            this.link = externalLinkDocument.getExternalLink();
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getLocalizedMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        ExternalLinkDocument externalLinkDocument = ExternalLinkDocument.Factory.newInstance();
        externalLinkDocument.setExternalLink(this.link);
        externalLinkDocument.save(outputStream, DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.writeTo(outputStream);
        outputStream.close();
    }

    public CTExternalLink getCTExternalLink() {
        return this.link;
    }

    public String getLinkedFileName() {
        String string = this.link.getExternalBook().getId();
        PackageRelationship packageRelationship = this.getPackagePart().getRelationship(string);
        if (packageRelationship != null && packageRelationship.getTargetMode() == TargetMode.EXTERNAL) {
            return packageRelationship.getTargetURI().toString();
        }
        return null;
    }

    public void setLinkedFileName(String string) {
        String string2 = this.link.getExternalBook().getId();
        if (string2 != null && !string2.isEmpty()) {
            this.getPackagePart().removeRelationship(string2);
        }
        PackageRelationship packageRelationship = this.getPackagePart().addExternalRelationship(string, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/externalLinkPath");
        this.link.getExternalBook().setId(packageRelationship.getId());
    }

    public List<String> getSheetNames() {
        CTExternalSheetName[] cTExternalSheetNameArray = this.link.getExternalBook().getSheetNames().getSheetNameArray();
        ArrayList<String> arrayList = new ArrayList<String>(cTExternalSheetNameArray.length);
        for (CTExternalSheetName cTExternalSheetName : cTExternalSheetNameArray) {
            arrayList.add(cTExternalSheetName.getVal());
        }
        return arrayList;
    }

    public List<Name> getDefinedNames() {
        CTExternalDefinedName[] cTExternalDefinedNameArray = this.link.getExternalBook().getDefinedNames().getDefinedNameArray();
        ArrayList<Name> arrayList = new ArrayList<Name>(cTExternalDefinedNameArray.length);
        for (CTExternalDefinedName cTExternalDefinedName : cTExternalDefinedNameArray) {
            arrayList.add(new ExternalName(cTExternalDefinedName));
        }
        return arrayList;
    }

    protected class ExternalName
    implements Name {
        private CTExternalDefinedName name;

        protected ExternalName(CTExternalDefinedName cTExternalDefinedName) {
            this.name = cTExternalDefinedName;
        }

        public String getNameName() {
            return this.name.getName();
        }

        public void setNameName(String string) {
            this.name.setName(string);
        }

        public String getSheetName() {
            int n = this.getSheetIndex();
            if (n >= 0) {
                return ExternalLinksTable.this.getSheetNames().get(n);
            }
            return null;
        }

        public int getSheetIndex() {
            if (this.name.isSetSheetId()) {
                return (int)this.name.getSheetId();
            }
            return -1;
        }

        public void setSheetIndex(int n) {
            this.name.setSheetId((long)n);
        }

        public String getRefersToFormula() {
            return this.name.getRefersTo().substring(1);
        }

        public void setRefersToFormula(String string) {
            this.name.setRefersTo('=' + string);
        }

        public boolean isFunctionName() {
            return false;
        }

        public boolean isDeleted() {
            return false;
        }

        public String getComment() {
            return null;
        }

        public void setComment(String string) {
            throw new IllegalStateException("Not Supported");
        }

        public void setFunction(boolean bl) {
            throw new IllegalStateException("Not Supported");
        }
    }
}

