/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.model;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.xssf.usermodel.XSSFComment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComments;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CommentsDocument;

public class CommentsTable
extends POIXMLDocumentPart {
    private CTComments comments;
    private Map<String, CTComment> commentRefs;

    public CommentsTable() {
        this.comments = CTComments.Factory.newInstance();
        this.comments.addNewCommentList();
        this.comments.addNewAuthors().addAuthor("");
    }

    public CommentsTable(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException {
        try {
            CommentsDocument commentsDocument = CommentsDocument.Factory.parse((InputStream)inputStream);
            this.comments = commentsDocument.getComments();
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getLocalizedMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        CommentsDocument commentsDocument = CommentsDocument.Factory.newInstance();
        commentsDocument.setComments(this.comments);
        commentsDocument.save(outputStream, DEFAULT_XML_OPTIONS);
    }

    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.writeTo(outputStream);
        outputStream.close();
    }

    public void referenceUpdated(String string, CTComment cTComment) {
        if (this.commentRefs != null) {
            this.commentRefs.remove(string);
            this.commentRefs.put(cTComment.getRef(), cTComment);
        }
    }

    public int getNumberOfComments() {
        return this.comments.getCommentList().sizeOfCommentArray();
    }

    public int getNumberOfAuthors() {
        return this.comments.getAuthors().sizeOfAuthorArray();
    }

    public String getAuthor(long l) {
        return this.comments.getAuthors().getAuthorArray((int)l);
    }

    public int findAuthor(String string) {
        String[] stringArray = this.comments.getAuthors().getAuthorArray();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return this.addNewAuthor(string);
    }

    public XSSFComment findCellComment(String string) {
        CTComment cTComment = this.getCTComment(string);
        return cTComment == null ? null : new XSSFComment(this, cTComment, null);
    }

    public CTComment getCTComment(String string) {
        if (this.commentRefs == null) {
            this.commentRefs = new HashMap<String, CTComment>();
            for (CTComment cTComment : this.comments.getCommentList().getCommentArray()) {
                this.commentRefs.put(cTComment.getRef(), cTComment);
            }
        }
        return this.commentRefs.get(string);
    }

    @Deprecated
    public CTComment newComment() {
        return this.newComment("A1");
    }

    public CTComment newComment(String string) {
        CTComment cTComment = this.comments.getCommentList().addNewComment();
        cTComment.setRef(string);
        cTComment.setAuthorId(0L);
        if (this.commentRefs != null) {
            this.commentRefs.put(cTComment.getRef(), cTComment);
        }
        return cTComment;
    }

    public boolean removeComment(String string) {
        CTCommentList cTCommentList = this.comments.getCommentList();
        if (cTCommentList != null) {
            CTComment[] cTCommentArray = cTCommentList.getCommentArray();
            for (int i = 0; i < cTCommentArray.length; ++i) {
                CTComment cTComment = cTCommentArray[i];
                if (!string.equals(cTComment.getRef())) continue;
                cTCommentList.removeComment(i);
                if (this.commentRefs != null) {
                    this.commentRefs.remove(string);
                }
                return true;
            }
        }
        return false;
    }

    private int addNewAuthor(String string) {
        int n = this.comments.getAuthors().sizeOfAuthorArray();
        this.comments.getAuthors().insertAuthor(n, string);
        return n;
    }

    public CTComments getCTComments() {
        return this.comments;
    }
}

