/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.model;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCalcCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCalcChain;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CalcChainDocument;

public class CalculationChain
extends POIXMLDocumentPart {
    private CTCalcChain chain;

    public CalculationChain() {
        this.chain = CTCalcChain.Factory.newInstance();
    }

    public CalculationChain(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException {
        try {
            CalcChainDocument calcChainDocument = CalcChainDocument.Factory.parse((InputStream)inputStream);
            this.chain = calcChainDocument.getCalcChain();
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getLocalizedMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        CalcChainDocument calcChainDocument = CalcChainDocument.Factory.newInstance();
        calcChainDocument.setCalcChain(this.chain);
        calcChainDocument.save(outputStream, DEFAULT_XML_OPTIONS);
    }

    protected void commit() throws IOException {
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.writeTo(outputStream);
        outputStream.close();
    }

    public CTCalcChain getCTCalcChain() {
        return this.chain;
    }

    public void removeItem(int n, String string) {
        int n2 = -1;
        CTCalcCell[] cTCalcCellArray = this.chain.getCArray();
        for (int i = 0; i < cTCalcCellArray.length; ++i) {
            if (cTCalcCellArray[i].isSetI()) {
                n2 = cTCalcCellArray[i].getI();
            }
            if (n2 != n || !cTCalcCellArray[i].getR().equals(string)) continue;
            if (cTCalcCellArray[i].isSetI() && i < cTCalcCellArray.length - 1 && !cTCalcCellArray[i + 1].isSetI()) {
                cTCalcCellArray[i + 1].setI(n2);
            }
            this.chain.removeC(i);
            break;
        }
    }
}

