/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.extractor;

import ai2.org.apache.poi.ss.usermodel.DateUtil;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.DocumentHelper;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFMap;
import ai2.org.apache.poi.xssf.usermodel.XSSFRow;
import ai2.org.apache.poi.xssf.usermodel.XSSFTable;
import ai2.org.apache.poi.xssf.usermodel.helpers.XSSFSingleXmlCell;
import ai2.org.apache.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STXmlDataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSSFImportFromXML {
    private final XSSFMap _map;
    private static POILogger logger = POILogFactory.getLogger(XSSFImportFromXML.class);

    public XSSFImportFromXML(XSSFMap xSSFMap) {
        this._map = xSSFMap;
    }

    public void importFromXML(String string) throws SAXException, XPathExpressionException, IOException {
        Object object;
        Object object2;
        DocumentBuilder documentBuilder = DocumentHelper.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string.trim())));
        List<XSSFSingleXmlCell> list = this._map.getRelatedSingleXMLCell();
        List<XSSFTable> list2 = this._map.getRelatedTables();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new DefaultNamespaceContext(document));
        for (XSSFSingleXmlCell object3 : list) {
            object2 = object3.getXmlDataType();
            object = object3.getXpath();
            Node node = (Node)xPath.evaluate((String)object, document, XPathConstants.NODE);
            if (node == null) continue;
            String string2 = node.getTextContent();
            logger.log(1, new Object[]{"Extracting with xpath " + (String)object + " : value is '" + string2 + "'"});
            XSSFCell xSSFCell = object3.getReferencedCell();
            logger.log(1, new Object[]{"Setting '" + string2 + "' to cell " + xSSFCell.getColumnIndex() + "-" + xSSFCell.getRowIndex() + " in sheet " + xSSFCell.getSheet().getSheetName()});
            this.setCellValue(string2, xSSFCell, (STXmlDataType.Enum)object2);
        }
        for (XSSFTable xSSFTable : list2) {
            object2 = xSSFTable.getCommonXpath();
            object = (NodeList)xPath.evaluate((String)object2, document, XPathConstants.NODESET);
            int n = xSSFTable.getStartCellReference().getRow() + 1;
            int n2 = xSSFTable.getStartCellReference().getCol() - 1;
            for (int i = 0; i < object.getLength(); ++i) {
                for (XSSFXmlColumnPr xSSFXmlColumnPr : xSSFTable.getXmlColumnPrs()) {
                    XSSFCell xSSFCell;
                    int n3 = (int)xSSFXmlColumnPr.getId();
                    int n4 = n + i;
                    int n5 = n2 + n3;
                    String string3 = xSSFXmlColumnPr.getLocalXPath();
                    string3 = string3.substring(string3.substring(1).indexOf(47) + 1);
                    String string4 = (String)object2 + "[" + (i + 1) + "]" + string3;
                    String string5 = (String)xPath.evaluate(string4, object.item(i), XPathConstants.STRING);
                    logger.log(1, new Object[]{"Extracting with xpath " + string4 + " : value is '" + string5 + "'"});
                    XSSFRow xSSFRow = xSSFTable.getXSSFSheet().getRow(n4);
                    if (xSSFRow == null) {
                        xSSFRow = xSSFTable.getXSSFSheet().createRow(n4);
                    }
                    if ((xSSFCell = xSSFRow.getCell(n5)) == null) {
                        xSSFCell = xSSFRow.createCell(n5);
                    }
                    logger.log(1, new Object[]{"Setting '" + string5 + "' to cell " + xSSFCell.getColumnIndex() + "-" + xSSFCell.getRowIndex() + " in sheet " + xSSFTable.getXSSFSheet().getSheetName()});
                    this.setCellValue(string5, xSSFCell, xSSFXmlColumnPr.getXmlDataType());
                }
            }
        }
    }

    private void setCellValue(String string, XSSFCell xSSFCell, STXmlDataType.Enum enum_) {
        block11: {
            DataType dataType = DataType.getDataType(enum_);
            try {
                if (string.isEmpty() || dataType == null) {
                    xSSFCell.setCellValue((String)null);
                    break block11;
                }
                switch (dataType) {
                    case BOOLEAN: {
                        xSSFCell.setCellValue(Boolean.parseBoolean(string));
                        break;
                    }
                    case DOUBLE: {
                        xSSFCell.setCellValue(Double.parseDouble(string));
                        break;
                    }
                    case INTEGER: {
                        xSSFCell.setCellValue(Integer.parseInt(string));
                        break;
                    }
                    case DATE: {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", LocaleUtil.getUserLocale());
                        Date date = simpleDateFormat.parse(string);
                        xSSFCell.setCellValue(date);
                        if (!DateUtil.isValidExcelDate(xSSFCell.getNumericCellValue())) {
                            xSSFCell.setCellValue(string);
                        }
                        break;
                    }
                    default: {
                        xSSFCell.setCellValue(string.trim());
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(String.format(LocaleUtil.getUserLocale(), "Unable to format value '%s' as %s for cell %s", new Object[]{string, dataType, new CellReference(xSSFCell).formatAsString()}));
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(String.format(LocaleUtil.getUserLocale(), "Unable to format value '%s' as %s for cell %s", new Object[]{string, dataType, new CellReference(xSSFCell).formatAsString()}));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultNamespaceContext
    implements NamespaceContext {
        private final Element _docElem;

        public DefaultNamespaceContext(Document document) {
            this._docElem = document.getDocumentElement();
        }

        @Override
        public String getNamespaceURI(String string) {
            return this.getNamespaceForPrefix(string);
        }

        private String getNamespaceForPrefix(String string) {
            if (string.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            Node node = this._docElem;
            while (node != null) {
                short s = node.getNodeType();
                if (s == 1) {
                    if (node.getNodeName().startsWith(string + ":")) {
                        return node.getNamespaceURI();
                    }
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        String string2;
                        Node node2 = namedNodeMap.item(i);
                        String string3 = node2.getNodeName();
                        boolean bl = string3.startsWith("xmlns:");
                        if (!bl && !string3.equals("xmlns")) continue;
                        int n = string3.indexOf(58);
                        String string4 = string2 = bl ? string3.substring(n + 1) : "";
                        if (!string2.equals(string)) continue;
                        return node2.getNodeValue();
                    }
                } else {
                    if (s != 5) break;
                    continue;
                }
                node = node.getParentNode();
            }
            return null;
        }

        public Iterator<?> getPrefixes(String string) {
            return null;
        }

        @Override
        public String getPrefix(String string) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DataType {
        BOOLEAN(STXmlDataType.BOOLEAN),
        DOUBLE(STXmlDataType.DOUBLE),
        INTEGER(STXmlDataType.INT, STXmlDataType.UNSIGNED_INT, STXmlDataType.INTEGER),
        STRING(STXmlDataType.STRING),
        DATE(STXmlDataType.DATE);

        private Set<STXmlDataType.Enum> xmlDataTypes;

        private DataType(STXmlDataType.Enum ... enumArray) {
            this.xmlDataTypes = new HashSet<STXmlDataType.Enum>(Arrays.asList(enumArray));
        }

        public static DataType getDataType(STXmlDataType.Enum enum_) {
            for (DataType dataType : DataType.values()) {
                if (!dataType.xmlDataTypes.contains(enum_)) continue;
                return dataType;
            }
            return null;
        }
    }
}

