/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.extractor;

import ai2.org.apache.poi.POITextExtractor;
import ai2.org.apache.poi.POIXMLTextExtractor;
import ai2.org.apache.poi.hssf.extractor.ExcelExtractor;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.Comment;
import ai2.org.apache.poi.ss.usermodel.DataFormatter;
import ai2.org.apache.poi.ss.usermodel.HeaderFooter;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import ai2.org.apache.poi.xssf.usermodel.XSSFShape;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import ai2.org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.io.IOException;
import java.util.Locale;
import org.apache.xmlbeans.XmlException;

public class XSSFExcelExtractor
extends POIXMLTextExtractor
implements ai2.org.apache.poi.ss.extractor.ExcelExtractor {
    public static final XSSFRelation[] SUPPORTED_TYPES = new XSSFRelation[]{XSSFRelation.WORKBOOK, XSSFRelation.MACRO_TEMPLATE_WORKBOOK, XSSFRelation.MACRO_ADDIN_WORKBOOK, XSSFRelation.TEMPLATE_WORKBOOK, XSSFRelation.MACROS_WORKBOOK};
    private Locale locale;
    private XSSFWorkbook workbook;
    private boolean includeSheetNames = true;
    private boolean formulasNotResults = false;
    private boolean includeCellComments = false;
    private boolean includeHeadersFooters = true;
    private boolean includeTextBoxes = true;

    public XSSFExcelExtractor(String string) throws XmlException, OpenXML4JException, IOException {
        this(new XSSFWorkbook(string));
    }

    public XSSFExcelExtractor(OPCPackage oPCPackage) throws XmlException, OpenXML4JException, IOException {
        this(new XSSFWorkbook(oPCPackage));
    }

    public XSSFExcelExtractor(XSSFWorkbook xSSFWorkbook) {
        super(xSSFWorkbook);
        this.workbook = xSSFWorkbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Use:");
            System.err.println("  XSSFExcelExtractor <filename.xlsx>");
            System.exit(1);
        }
        XSSFExcelExtractor xSSFExcelExtractor = new XSSFExcelExtractor(stringArray[0]);
        try {
            System.out.println(((POITextExtractor)xSSFExcelExtractor).getText());
        }
        finally {
            xSSFExcelExtractor.close();
        }
    }

    public void setIncludeSheetNames(boolean bl) {
        this.includeSheetNames = bl;
    }

    public void setFormulasNotResults(boolean bl) {
        this.formulasNotResults = bl;
    }

    public void setIncludeCellComments(boolean bl) {
        this.includeCellComments = bl;
    }

    public void setIncludeHeadersFooters(boolean bl) {
        this.includeHeadersFooters = bl;
    }

    public void setIncludeTextBoxes(boolean bl) {
        this.includeTextBoxes = bl;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getText() {
        DataFormatter dataFormatter = this.locale == null ? new DataFormatter() : new DataFormatter(this.locale);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            Object object;
            Object object2;
            Object object3;
            XSSFSheet xSSFSheet = this.workbook.getSheetAt(i);
            if (this.includeSheetNames) {
                stringBuffer.append(this.workbook.getSheetName(i)).append("\n");
            }
            if (this.includeHeadersFooters) {
                stringBuffer.append(this.extractHeaderFooter(xSSFSheet.getFirstHeader()));
                stringBuffer.append(this.extractHeaderFooter(xSSFSheet.getOddHeader()));
                stringBuffer.append(this.extractHeaderFooter(xSSFSheet.getEvenHeader()));
            }
            Object object4 = xSSFSheet.iterator();
            while (object4.hasNext()) {
                object2 = object3 = object4.next();
                object = object2.cellIterator();
                while (object.hasNext()) {
                    Cell cell = object.next();
                    if (cell.getCellType() == 2) {
                        if (this.formulasNotResults) {
                            stringBuffer.append(cell.getCellFormula());
                        } else if (cell.getCachedFormulaResultType() == 1) {
                            this.handleStringCell(stringBuffer, cell);
                        } else {
                            this.handleNonStringCell(stringBuffer, cell, dataFormatter);
                        }
                    } else if (cell.getCellType() == 1) {
                        this.handleStringCell(stringBuffer, cell);
                    } else {
                        this.handleNonStringCell(stringBuffer, cell, dataFormatter);
                    }
                    Comment comment = cell.getCellComment();
                    if (this.includeCellComments && comment != null) {
                        String string = comment.getString().getString().replace('\n', ' ');
                        stringBuffer.append(" Comment by ").append(comment.getAuthor()).append(": ").append(string);
                    }
                    if (!object.hasNext()) continue;
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
            if (this.includeTextBoxes && (object4 = xSSFSheet.getDrawingPatriarch()) != null) {
                object3 = ((XSSFDrawing)object4).getShapes().iterator();
                while (object3.hasNext()) {
                    object2 = (XSSFShape)object3.next();
                    if (!(object2 instanceof XSSFSimpleShape) || ((String)(object = ((XSSFSimpleShape)object2).getText())).length() <= 0) continue;
                    stringBuffer.append((String)object);
                    stringBuffer.append('\n');
                }
            }
            if (!this.includeHeadersFooters) continue;
            stringBuffer.append(this.extractHeaderFooter(xSSFSheet.getFirstFooter()));
            stringBuffer.append(this.extractHeaderFooter(xSSFSheet.getOddFooter()));
            stringBuffer.append(this.extractHeaderFooter(xSSFSheet.getEvenFooter()));
        }
        return stringBuffer.toString();
    }

    private void handleStringCell(StringBuffer stringBuffer, Cell cell) {
        stringBuffer.append(cell.getRichStringCellValue().getString());
    }

    private void handleNonStringCell(StringBuffer stringBuffer, Cell cell, DataFormatter dataFormatter) {
        Object object;
        int n = cell.getCellType();
        if (n == 2) {
            n = cell.getCachedFormulaResultType();
        }
        if (n == 0 && (object = cell.getCellStyle()) != null && object.getDataFormatString() != null) {
            stringBuffer.append(dataFormatter.formatRawCellContents(cell.getNumericCellValue(), object.getDataFormat(), object.getDataFormatString()));
            return;
        }
        object = (XSSFCell)cell;
        stringBuffer.append(((XSSFCell)object).getRawValue());
    }

    private String extractHeaderFooter(HeaderFooter headerFooter) {
        return ExcelExtractor._extractHeaderFooter(headerFooter);
    }
}

