/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.extractor;

import ai2.org.apache.poi.POITextExtractor;
import ai2.org.apache.poi.POIXMLProperties;
import ai2.org.apache.poi.POIXMLTextExtractor;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.ss.extractor.ExcelExtractor;
import ai2.org.apache.poi.ss.usermodel.DataFormatter;
import ai2.org.apache.poi.util.SAXHelper;
import ai2.org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import ai2.org.apache.poi.xssf.eventusermodel.XSSFReader;
import ai2.org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import ai2.org.apache.poi.xssf.model.CommentsTable;
import ai2.org.apache.poi.xssf.model.StylesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFComment;
import ai2.org.apache.poi.xssf.usermodel.XSSFShape;
import ai2.org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFEventBasedExcelExtractor
extends POIXMLTextExtractor
implements ExcelExtractor {
    private OPCPackage container;
    private POIXMLProperties properties;
    private Locale locale;
    private boolean includeTextBoxes = true;
    private boolean includeSheetNames = true;
    private boolean includeCellComments = false;
    private boolean includeHeadersFooters = true;
    private boolean formulasNotResults = false;

    public XSSFEventBasedExcelExtractor(String string) throws XmlException, OpenXML4JException, IOException {
        this(OPCPackage.open(string));
    }

    public XSSFEventBasedExcelExtractor(OPCPackage oPCPackage) throws XmlException, OpenXML4JException, IOException {
        super(null);
        this.container = oPCPackage;
        this.properties = new POIXMLProperties(oPCPackage);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Use:");
            System.err.println("  XSSFEventBasedExcelExtractor <filename.xlsx>");
            System.exit(1);
        }
        XSSFEventBasedExcelExtractor xSSFEventBasedExcelExtractor = new XSSFEventBasedExcelExtractor(stringArray[0]);
        System.out.println(((POITextExtractor)xSSFEventBasedExcelExtractor).getText());
        ((POIXMLTextExtractor)xSSFEventBasedExcelExtractor).close();
    }

    @Override
    public void setIncludeSheetNames(boolean bl) {
        this.includeSheetNames = bl;
    }

    @Override
    public void setFormulasNotResults(boolean bl) {
        this.formulasNotResults = bl;
    }

    @Override
    public void setIncludeHeadersFooters(boolean bl) {
        this.includeHeadersFooters = bl;
    }

    public void setIncludeTextBoxes(boolean bl) {
        this.includeTextBoxes = bl;
    }

    @Override
    public void setIncludeCellComments(boolean bl) {
        this.includeCellComments = bl;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public OPCPackage getPackage() {
        return this.container;
    }

    @Override
    public POIXMLProperties.CoreProperties getCoreProperties() {
        return this.properties.getCoreProperties();
    }

    @Override
    public POIXMLProperties.ExtendedProperties getExtendedProperties() {
        return this.properties.getExtendedProperties();
    }

    @Override
    public POIXMLProperties.CustomProperties getCustomProperties() {
        return this.properties.getCustomProperties();
    }

    public void processSheet(XSSFSheetXMLHandler.SheetContentsHandler sheetContentsHandler, StylesTable stylesTable, CommentsTable commentsTable, ReadOnlySharedStringsTable readOnlySharedStringsTable, InputStream inputStream) throws IOException, SAXException {
        DataFormatter dataFormatter = this.locale == null ? new DataFormatter() : new DataFormatter(this.locale);
        InputSource inputSource = new InputSource(inputStream);
        try {
            XMLReader xMLReader = SAXHelper.newXMLReader();
            XSSFSheetXMLHandler xSSFSheetXMLHandler = new XSSFSheetXMLHandler(stylesTable, commentsTable, readOnlySharedStringsTable, sheetContentsHandler, dataFormatter, this.formulasNotResults);
            xMLReader.setContentHandler(xSSFSheetXMLHandler);
            xMLReader.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("SAX parser appears to be broken - " + parserConfigurationException.getMessage());
        }
    }

    @Override
    public String getText() {
        try {
            ReadOnlySharedStringsTable readOnlySharedStringsTable = new ReadOnlySharedStringsTable(this.container);
            XSSFReader xSSFReader = new XSSFReader(this.container);
            StylesTable stylesTable = xSSFReader.getStylesTable();
            XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)xSSFReader.getSheetsData();
            StringBuffer stringBuffer = new StringBuffer();
            SheetTextExtractor sheetTextExtractor = new SheetTextExtractor();
            while (sheetIterator.hasNext()) {
                InputStream inputStream = sheetIterator.next();
                if (this.includeSheetNames) {
                    stringBuffer.append(sheetIterator.getSheetName());
                    stringBuffer.append('\n');
                }
                CommentsTable commentsTable = this.includeCellComments ? sheetIterator.getSheetComments() : null;
                this.processSheet(sheetTextExtractor, stylesTable, commentsTable, readOnlySharedStringsTable, inputStream);
                if (this.includeHeadersFooters) {
                    sheetTextExtractor.appendHeaderText(stringBuffer);
                }
                sheetTextExtractor.appendCellText(stringBuffer);
                if (this.includeTextBoxes) {
                    this.processShapes(sheetIterator.getShapes(), stringBuffer);
                }
                if (this.includeHeadersFooters) {
                    sheetTextExtractor.appendFooterText(stringBuffer);
                }
                sheetTextExtractor.reset();
                inputStream.close();
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException);
            return null;
        }
        catch (OpenXML4JException openXML4JException) {
            System.err.println(openXML4JException);
            return null;
        }
    }

    private void processShapes(List<XSSFShape> list, StringBuffer stringBuffer) {
        if (list == null) {
            return;
        }
        for (XSSFShape xSSFShape : list) {
            String string;
            if (!(xSSFShape instanceof XSSFSimpleShape) || (string = ((XSSFSimpleShape)xSSFShape).getText()) == null || string.length() <= 0) continue;
            stringBuffer.append(string).append('\n');
        }
    }

    @Override
    public void close() throws IOException {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
        super.close();
    }

    protected class SheetTextExtractor
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private final StringBuffer output = new StringBuffer();
        private boolean firstCellOfRow = true;
        private final Map<String, String> headerFooterMap;

        protected SheetTextExtractor() {
            this.headerFooterMap = XSSFEventBasedExcelExtractor.this.includeHeadersFooters ? new HashMap() : null;
        }

        public void startRow(int n) {
            this.firstCellOfRow = true;
        }

        public void endRow(int n) {
            this.output.append('\n');
        }

        public void cell(String string, String string2, XSSFComment xSSFComment) {
            if (this.firstCellOfRow) {
                this.firstCellOfRow = false;
            } else {
                this.output.append('\t');
            }
            if (string2 != null) {
                this.output.append(string2);
            }
            if (XSSFEventBasedExcelExtractor.this.includeCellComments && xSSFComment != null) {
                String string3 = xSSFComment.getString().getString().replace('\n', ' ');
                this.output.append(string2 != null ? " Comment by " : "Comment by ");
                if (string3.startsWith(xSSFComment.getAuthor() + ": ")) {
                    this.output.append(string3);
                } else {
                    this.output.append(xSSFComment.getAuthor()).append(": ").append(string3);
                }
            }
        }

        public void headerFooter(String string, boolean bl, String string2) {
            if (this.headerFooterMap != null) {
                this.headerFooterMap.put(string2, string);
            }
        }

        private void appendHeaderFooterText(StringBuffer stringBuffer, String string) {
            String string2 = this.headerFooterMap.get(string);
            if (string2 != null && string2.length() > 0) {
                string2 = this.handleHeaderFooterDelimiter(string2, "&L");
                string2 = this.handleHeaderFooterDelimiter(string2, "&C");
                string2 = this.handleHeaderFooterDelimiter(string2, "&R");
                stringBuffer.append(string2).append('\n');
            }
        }

        private String handleHeaderFooterDelimiter(String string, String string2) {
            int n = string.indexOf(string2);
            if (n == 0) {
                string = string.substring(2);
            } else if (n > 0) {
                string = string.substring(0, n) + "\t" + string.substring(n + 2);
            }
            return string;
        }

        private void appendHeaderText(StringBuffer stringBuffer) {
            this.appendHeaderFooterText(stringBuffer, "firstHeader");
            this.appendHeaderFooterText(stringBuffer, "oddHeader");
            this.appendHeaderFooterText(stringBuffer, "evenHeader");
        }

        private void appendFooterText(StringBuffer stringBuffer) {
            this.appendHeaderFooterText(stringBuffer, "firstFooter");
            this.appendHeaderFooterText(stringBuffer, "oddFooter");
            this.appendHeaderFooterText(stringBuffer, "evenFooter");
        }

        private void appendCellText(StringBuffer stringBuffer) {
            stringBuffer.append(this.output);
        }

        private void reset() {
            this.output.setLength(0);
            this.firstCellOfRow = true;
            if (this.headerFooterMap != null) {
                this.headerFooterMap.clear();
            }
        }
    }
}

