/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.eventusermodel;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.xssf.model.CommentsTable;
import ai2.org.apache.poi.xssf.model.SharedStringsTable;
import ai2.org.apache.poi.xssf.model.StylesTable;
import ai2.org.apache.poi.xssf.model.ThemesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import ai2.org.apache.poi.xssf.usermodel.XSSFShape;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorkbookDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFReader {
    private OPCPackage pkg;
    private PackagePart workbookPart;

    public XSSFReader(OPCPackage oPCPackage) throws IOException, OpenXML4JException {
        this.pkg = oPCPackage;
        PackageRelationship packageRelationship = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        this.workbookPart = this.pkg.getPart(packageRelationship);
    }

    public SharedStringsTable getSharedStringsTable() throws IOException, InvalidFormatException {
        ArrayList<PackagePart> arrayList = this.pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        return arrayList.size() == 0 ? null : new SharedStringsTable(arrayList.get(0), null);
    }

    public StylesTable getStylesTable() throws IOException, InvalidFormatException {
        ArrayList<PackagePart> arrayList = this.pkg.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (arrayList.size() == 0) {
            return null;
        }
        StylesTable stylesTable = new StylesTable(arrayList.get(0), null);
        arrayList = this.pkg.getPartsByContentType(XSSFRelation.THEME.getContentType());
        if (arrayList.size() != 0) {
            stylesTable.setTheme(new ThemesTable(arrayList.get(0), null));
        }
        return stylesTable;
    }

    public InputStream getSharedStringsData() throws IOException, InvalidFormatException {
        return XSSFRelation.SHARED_STRINGS.getContents(this.workbookPart);
    }

    public InputStream getStylesData() throws IOException, InvalidFormatException {
        return XSSFRelation.STYLES.getContents(this.workbookPart);
    }

    public InputStream getThemesData() throws IOException, InvalidFormatException {
        return XSSFRelation.THEME.getContents(this.workbookPart);
    }

    public InputStream getWorkbookData() throws IOException, InvalidFormatException {
        return this.workbookPart.getInputStream();
    }

    public InputStream getSheet(String string) throws IOException, InvalidFormatException {
        PackageRelationship packageRelationship = this.workbookPart.getRelationship(string);
        if (packageRelationship == null) {
            throw new IllegalArgumentException("No Sheet found with r:id " + string);
        }
        PackagePartName packagePartName = PackagingURIHelper.createPartName(packageRelationship.getTargetURI());
        PackagePart packagePart = this.pkg.getPart(packagePartName);
        if (packagePart == null) {
            throw new IllegalArgumentException("No data found for Sheet with r:id " + string);
        }
        return packagePart.getInputStream();
    }

    public Iterator<InputStream> getSheetsData() throws IOException, InvalidFormatException {
        return new SheetIterator(this.workbookPart);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SheetIterator
    implements Iterator<InputStream> {
        private Map<String, PackagePart> sheetMap;
        private CTSheet ctSheet;
        private Iterator<CTSheet> sheetIterator;

        private SheetIterator(PackagePart packagePart) throws IOException {
            try {
                this.sheetMap = new HashMap<String, PackagePart>();
                for (PackageRelationship packageRelationship : packagePart.getRelationships()) {
                    if (!packageRelationship.getRelationshipType().equals(XSSFRelation.WORKSHEET.getRelation()) && !packageRelationship.getRelationshipType().equals(XSSFRelation.CHARTSHEET.getRelation())) continue;
                    PackagePartName packagePartName = PackagingURIHelper.createPartName(packageRelationship.getTargetURI());
                    this.sheetMap.put(packageRelationship.getId(), packagePart.getPackage().getPart(packagePartName));
                }
                CTWorkbook cTWorkbook = WorkbookDocument.Factory.parse((InputStream)packagePart.getInputStream()).getWorkbook();
                this.sheetIterator = cTWorkbook.getSheets().getSheetList().iterator();
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new POIXMLException(invalidFormatException);
            }
            catch (XmlException xmlException) {
                throw new POIXMLException(xmlException);
            }
        }

        @Override
        public boolean hasNext() {
            return this.sheetIterator.hasNext();
        }

        @Override
        public InputStream next() {
            this.ctSheet = this.sheetIterator.next();
            String string = this.ctSheet.getId();
            try {
                PackagePart packagePart = this.sheetMap.get(string);
                return packagePart.getInputStream();
            }
            catch (IOException iOException) {
                throw new POIXMLException(iOException);
            }
        }

        public String getSheetName() {
            return this.ctSheet.getName();
        }

        public CommentsTable getSheetComments() {
            PackagePart packagePart = this.getSheetPart();
            try {
                PackageRelationshipCollection packageRelationshipCollection = packagePart.getRelationshipsByType(XSSFRelation.SHEET_COMMENTS.getRelation());
                if (packageRelationshipCollection.size() > 0) {
                    PackageRelationship packageRelationship = packageRelationshipCollection.getRelationship(0);
                    PackagePartName packagePartName = PackagingURIHelper.createPartName(packageRelationship.getTargetURI());
                    PackagePart packagePart2 = packagePart.getPackage().getPart(packagePartName);
                    return new CommentsTable(packagePart2, packageRelationship);
                }
            }
            catch (InvalidFormatException invalidFormatException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            return null;
        }

        public List<XSSFShape> getShapes() {
            PackagePart packagePart = this.getSheetPart();
            LinkedList<XSSFShape> linkedList = new LinkedList<XSSFShape>();
            try {
                PackageRelationshipCollection packageRelationshipCollection = packagePart.getRelationshipsByType(XSSFRelation.DRAWINGS.getRelation());
                for (int i = 0; i < packageRelationshipCollection.size(); ++i) {
                    PackageRelationship packageRelationship = packageRelationshipCollection.getRelationship(i);
                    PackagePartName packagePartName = PackagingURIHelper.createPartName(packageRelationship.getTargetURI());
                    PackagePart packagePart2 = packagePart.getPackage().getPart(packagePartName);
                    XSSFDrawing xSSFDrawing = new XSSFDrawing(packagePart2, packageRelationship);
                    for (XSSFShape xSSFShape : xSSFDrawing.getShapes()) {
                        linkedList.add(xSSFShape);
                    }
                }
            }
            catch (XmlException xmlException) {
                return null;
            }
            catch (InvalidFormatException invalidFormatException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            return linkedList;
        }

        public PackagePart getSheetPart() {
            String string = this.ctSheet.getId();
            return this.sheetMap.get(string);
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Not supported");
        }
    }
}

