/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.util.Internal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBaseStyles;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorMapping;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOfficeStyleSheet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;

public class XSLFTheme
extends POIXMLDocumentPart {
    private CTOfficeStyleSheet _theme;
    private Map<String, CTColor> _schemeColors;

    XSLFTheme() {
        this._theme = CTOfficeStyleSheet.Factory.newInstance();
    }

    public XSLFTheme(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, XmlException {
        super(packagePart, packageRelationship);
        ThemeDocument themeDocument = ThemeDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._theme = themeDocument.getTheme();
        this.initialize();
    }

    public void importTheme(XSLFTheme xSLFTheme) {
        this._theme = xSLFTheme.getXmlObject();
        this._schemeColors = xSLFTheme._schemeColors;
    }

    private void initialize() {
        CTBaseStyles cTBaseStyles = this._theme.getThemeElements();
        CTColorScheme cTColorScheme = cTBaseStyles.getClrScheme();
        this._schemeColors = new HashMap<String, CTColor>(12);
        for (XmlObject xmlObject : cTColorScheme.selectPath("*")) {
            CTColor cTColor = (CTColor)xmlObject;
            String string = cTColor.getDomNode().getLocalName();
            this._schemeColors.put(string, cTColor);
        }
    }

    void initColorMap(CTColorMapping cTColorMapping) {
        this._schemeColors.put("bg1", this._schemeColors.get(cTColorMapping.getBg1().toString()));
        this._schemeColors.put("bg2", this._schemeColors.get(cTColorMapping.getBg2().toString()));
        this._schemeColors.put("tx1", this._schemeColors.get(cTColorMapping.getTx1().toString()));
        this._schemeColors.put("tx2", this._schemeColors.get(cTColorMapping.getTx2().toString()));
    }

    public String getName() {
        return this._theme.getName();
    }

    public void setName(String string) {
        this._theme.setName(string);
    }

    CTColor getCTColor(String string) {
        return this._schemeColors.get(string);
    }

    @Internal
    public CTOfficeStyleSheet getXmlObject() {
        return this._theme;
    }

    protected final void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("http://schemas.openxmlformats.org/drawingml/2006/main", "a");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        xmlOptions.setSaveSyntheticDocumentElement(new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "theme"));
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.getXmlObject().save(outputStream, xmlOptions);
        outputStream.close();
    }

    public String getMajorFont() {
        return this._theme.getThemeElements().getFontScheme().getMajorFont().getLatin().getTypeface();
    }

    public String getMinorFont() {
        return this._theme.getThemeElements().getFontScheme().getMinorFont().getLatin().getTypeface();
    }

    CTTextParagraphProperties getDefaultParagraphStyle() {
        XmlObject[] xmlObjectArray = this._theme.selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//a:objectDefaults/a:spDef/a:lstStyle/a:defPPr");
        if (xmlObjectArray.length == 1) {
            return (CTTextParagraphProperties)xmlObjectArray[0];
        }
        return null;
    }
}

