/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawTextShape;
import ai2.org.apache.poi.sl.usermodel.Insets2D;
import ai2.org.apache.poi.sl.usermodel.TextShape;
import ai2.org.apache.poi.sl.usermodel.VerticalAlignment;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.model.TextBodyPropertyFetcher;
import ai2.org.apache.poi.xslf.usermodel.Placeholder;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextListStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextVerticalType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextWrappingType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSLFTextShape
extends XSLFSimpleShape
implements TextShape<XSLFShape, XSLFTextParagraph> {
    private final List<XSLFTextParagraph> _paragraphs = new ArrayList<XSLFTextParagraph>();

    XSLFTextShape(XmlObject xmlObject, XSLFSheet xSLFSheet) {
        super(xmlObject, xSLFSheet);
        CTTextBody cTTextBody = this.getTextBody(false);
        if (cTTextBody != null) {
            for (CTTextParagraph cTTextParagraph : cTTextBody.getPArray()) {
                this._paragraphs.add(new XSLFTextParagraph(cTTextParagraph, this));
            }
        }
    }

    @Override
    public Iterator<XSLFTextParagraph> iterator() {
        return this.getTextParagraphs().iterator();
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (XSLFTextParagraph xSLFTextParagraph : this._paragraphs) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(xSLFTextParagraph.getText());
        }
        return stringBuilder.toString();
    }

    public void clearText() {
        this._paragraphs.clear();
        CTTextBody cTTextBody = this.getTextBody(true);
        cTTextBody.setPArray(null);
    }

    public void setText(String string) {
        this.clearText();
        this.addNewTextParagraph().addNewTextRun().setText(string);
    }

    @Override
    public List<XSLFTextParagraph> getTextParagraphs() {
        return this._paragraphs;
    }

    public XSLFTextParagraph addNewTextParagraph() {
        CTTextBody cTTextBody = this.getTextBody(true);
        CTTextParagraph cTTextParagraph = cTTextBody.addNewP();
        XSLFTextParagraph xSLFTextParagraph = new XSLFTextParagraph(cTTextParagraph, this);
        this._paragraphs.add(xSLFTextParagraph);
        return xSLFTextParagraph;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null) {
            if (verticalAlignment == null) {
                if (cTTextBodyProperties.isSetAnchor()) {
                    cTTextBodyProperties.unsetAnchor();
                }
            } else {
                cTTextBodyProperties.setAnchor(STTextAnchoringType.Enum.forInt((int)(verticalAlignment.ordinal() + 1)));
            }
        }
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        TextBodyPropertyFetcher<VerticalAlignment> textBodyPropertyFetcher = new TextBodyPropertyFetcher<VerticalAlignment>(){

            @Override
            public boolean fetch(CTTextBodyProperties cTTextBodyProperties) {
                if (cTTextBodyProperties.isSetAnchor()) {
                    int n = cTTextBodyProperties.getAnchor().intValue();
                    this.setValue(VerticalAlignment.values()[n - 1]);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(textBodyPropertyFetcher);
        return textBodyPropertyFetcher.getValue() == null ? VerticalAlignment.TOP : (VerticalAlignment)((Object)textBodyPropertyFetcher.getValue());
    }

    public void setHorizontalCentered(Boolean bl) {
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null) {
            if (bl == null) {
                if (cTTextBodyProperties.isSetAnchorCtr()) {
                    cTTextBodyProperties.unsetAnchorCtr();
                }
            } else {
                cTTextBodyProperties.setAnchorCtr(bl.booleanValue());
            }
        }
    }

    @Override
    public boolean isHorizontalCentered() {
        TextBodyPropertyFetcher<Boolean> textBodyPropertyFetcher = new TextBodyPropertyFetcher<Boolean>(){

            @Override
            public boolean fetch(CTTextBodyProperties cTTextBodyProperties) {
                if (cTTextBodyProperties.isSetAnchorCtr()) {
                    this.setValue(cTTextBodyProperties.getAnchorCtr());
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(textBodyPropertyFetcher);
        return textBodyPropertyFetcher.getValue() == null ? false : (Boolean)textBodyPropertyFetcher.getValue();
    }

    public void setTextDirection(TextShape.TextDirection textDirection) {
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null) {
            if (textDirection == null) {
                if (cTTextBodyProperties.isSetVert()) {
                    cTTextBodyProperties.unsetVert();
                }
            } else {
                cTTextBodyProperties.setVert(STTextVerticalType.Enum.forInt((int)(textDirection.ordinal() + 1)));
            }
        }
    }

    @Override
    public TextShape.TextDirection getTextDirection() {
        STTextVerticalType.Enum enum_;
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null && (enum_ = cTTextBodyProperties.getVert()) != null) {
            return TextShape.TextDirection.values()[enum_.intValue() - 1];
        }
        return TextShape.TextDirection.HORIZONTAL;
    }

    public double getBottomInset() {
        TextBodyPropertyFetcher<Double> textBodyPropertyFetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties cTTextBodyProperties) {
                if (cTTextBodyProperties.isSetBIns()) {
                    double d = Units.toPoints(cTTextBodyProperties.getBIns());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(textBodyPropertyFetcher);
        return textBodyPropertyFetcher.getValue() == null ? 3.6 : (Double)textBodyPropertyFetcher.getValue();
    }

    public double getLeftInset() {
        TextBodyPropertyFetcher<Double> textBodyPropertyFetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties cTTextBodyProperties) {
                if (cTTextBodyProperties.isSetLIns()) {
                    double d = Units.toPoints(cTTextBodyProperties.getLIns());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(textBodyPropertyFetcher);
        return textBodyPropertyFetcher.getValue() == null ? 7.2 : (Double)textBodyPropertyFetcher.getValue();
    }

    public double getRightInset() {
        TextBodyPropertyFetcher<Double> textBodyPropertyFetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties cTTextBodyProperties) {
                if (cTTextBodyProperties.isSetRIns()) {
                    double d = Units.toPoints(cTTextBodyProperties.getRIns());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(textBodyPropertyFetcher);
        return textBodyPropertyFetcher.getValue() == null ? 7.2 : (Double)textBodyPropertyFetcher.getValue();
    }

    public double getTopInset() {
        TextBodyPropertyFetcher<Double> textBodyPropertyFetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties cTTextBodyProperties) {
                if (cTTextBodyProperties.isSetTIns()) {
                    double d = Units.toPoints(cTTextBodyProperties.getTIns());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(textBodyPropertyFetcher);
        return textBodyPropertyFetcher.getValue() == null ? 3.6 : (Double)textBodyPropertyFetcher.getValue();
    }

    public void setBottomInset(double d) {
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null) {
            if (d == -1.0) {
                cTTextBodyProperties.unsetBIns();
            } else {
                cTTextBodyProperties.setBIns(Units.toEMU(d));
            }
        }
    }

    public void setLeftInset(double d) {
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null) {
            if (d == -1.0) {
                cTTextBodyProperties.unsetLIns();
            } else {
                cTTextBodyProperties.setLIns(Units.toEMU(d));
            }
        }
    }

    public void setRightInset(double d) {
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null) {
            if (d == -1.0) {
                cTTextBodyProperties.unsetRIns();
            } else {
                cTTextBodyProperties.setRIns(Units.toEMU(d));
            }
        }
    }

    public void setTopInset(double d) {
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null) {
            if (d == -1.0) {
                cTTextBodyProperties.unsetTIns();
            } else {
                cTTextBodyProperties.setTIns(Units.toEMU(d));
            }
        }
    }

    @Override
    public Insets2D getInsets() {
        Insets2D insets2D = new Insets2D(this.getTopInset(), this.getLeftInset(), this.getBottomInset(), this.getRightInset());
        return insets2D;
    }

    @Override
    public boolean getWordWrap() {
        TextBodyPropertyFetcher<Boolean> textBodyPropertyFetcher = new TextBodyPropertyFetcher<Boolean>(){

            @Override
            public boolean fetch(CTTextBodyProperties cTTextBodyProperties) {
                if (cTTextBodyProperties.isSetWrap()) {
                    this.setValue(cTTextBodyProperties.getWrap() == STTextWrappingType.SQUARE);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(textBodyPropertyFetcher);
        return textBodyPropertyFetcher.getValue() == null ? true : (Boolean)textBodyPropertyFetcher.getValue();
    }

    public void setWordWrap(boolean bl) {
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null) {
            cTTextBodyProperties.setWrap(bl ? STTextWrappingType.SQUARE : STTextWrappingType.NONE);
        }
    }

    public void setTextAutofit(TextShape.TextAutofit textAutofit) {
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null) {
            if (cTTextBodyProperties.isSetSpAutoFit()) {
                cTTextBodyProperties.unsetSpAutoFit();
            }
            if (cTTextBodyProperties.isSetNoAutofit()) {
                cTTextBodyProperties.unsetNoAutofit();
            }
            if (cTTextBodyProperties.isSetNormAutofit()) {
                cTTextBodyProperties.unsetNormAutofit();
            }
            switch (textAutofit) {
                case NONE: {
                    cTTextBodyProperties.addNewNoAutofit();
                    break;
                }
                case NORMAL: {
                    cTTextBodyProperties.addNewNormAutofit();
                    break;
                }
                case SHAPE: {
                    cTTextBodyProperties.addNewSpAutoFit();
                }
            }
        }
    }

    public TextShape.TextAutofit getTextAutofit() {
        CTTextBodyProperties cTTextBodyProperties = this.getTextBodyPr();
        if (cTTextBodyProperties != null) {
            if (cTTextBodyProperties.isSetNoAutofit()) {
                return TextShape.TextAutofit.NONE;
            }
            if (cTTextBodyProperties.isSetNormAutofit()) {
                return TextShape.TextAutofit.NORMAL;
            }
            if (cTTextBodyProperties.isSetSpAutoFit()) {
                return TextShape.TextAutofit.SHAPE;
            }
        }
        return TextShape.TextAutofit.NORMAL;
    }

    protected CTTextBodyProperties getTextBodyPr() {
        CTTextBody cTTextBody = this.getTextBody(false);
        return cTTextBody == null ? null : cTTextBody.getBodyPr();
    }

    protected abstract CTTextBody getTextBody(boolean var1);

    @Override
    public void setPlaceholder(Placeholder placeholder) {
        super.setPlaceholder(placeholder);
    }

    public Placeholder getTextType() {
        CTPlaceholder cTPlaceholder = this.getCTPlaceholder();
        if (cTPlaceholder == null) {
            return null;
        }
        int n = cTPlaceholder.getType().intValue();
        return Placeholder.values()[n - 1];
    }

    @Override
    public double getTextHeight() {
        DrawFactory drawFactory = DrawFactory.getInstance(null);
        DrawTextShape drawTextShape = drawFactory.getDrawable(this);
        return drawTextShape.getTextHeight();
    }

    public Rectangle resizeToFitText() {
        Rectangle rectangle = this.getAnchor();
        if (rectangle.getWidth() == 0.0) {
            throw new POIXMLException("Anchor of the shape was not set.");
        }
        double d = this.getTextHeight();
        rectangle.setRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), d += 1.0);
        this.setAnchor(rectangle);
        return rectangle;
    }

    @Override
    void copy(XSLFShape xSLFShape) {
        VerticalAlignment verticalAlignment;
        double d;
        double d2;
        double d3;
        double d4;
        boolean bl;
        super.copy(xSLFShape);
        XSLFTextShape xSLFTextShape = (XSLFTextShape)xSLFShape;
        CTTextBody cTTextBody = xSLFTextShape.getTextBody(false);
        CTTextBody cTTextBody2 = this.getTextBody(true);
        if (cTTextBody == null) {
            return;
        }
        cTTextBody2.setBodyPr((CTTextBodyProperties)cTTextBody.getBodyPr().copy());
        if (cTTextBody2.isSetLstStyle()) {
            cTTextBody2.unsetLstStyle();
        }
        if (cTTextBody.isSetLstStyle()) {
            cTTextBody2.setLstStyle((CTTextListStyle)cTTextBody.getLstStyle().copy());
        }
        if ((bl = xSLFTextShape.getWordWrap()) != this.getWordWrap()) {
            this.setWordWrap(bl);
        }
        if ((d4 = xSLFTextShape.getLeftInset()) != this.getLeftInset()) {
            this.setLeftInset(d4);
        }
        if ((d3 = xSLFTextShape.getRightInset()) != this.getRightInset()) {
            this.setRightInset(d3);
        }
        if ((d2 = xSLFTextShape.getTopInset()) != this.getTopInset()) {
            this.setTopInset(d2);
        }
        if ((d = xSLFTextShape.getBottomInset()) != this.getBottomInset()) {
            this.setBottomInset(d);
        }
        if ((verticalAlignment = xSLFTextShape.getVerticalAlignment()) != this.getVerticalAlignment()) {
            this.setVerticalAlignment(verticalAlignment);
        }
        this.clearText();
        for (XSLFTextParagraph xSLFTextParagraph : xSLFTextShape.getTextParagraphs()) {
            XSLFTextParagraph xSLFTextParagraph2 = this.addNewTextParagraph();
            xSLFTextParagraph2.copy(xSLFTextParagraph);
        }
    }
}

