/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.TextRun;
import ai2.org.apache.poi.xslf.model.CharacterPropertyFetcher;
import ai2.org.apache.poi.xslf.usermodel.XMLSlideShow;
import ai2.org.apache.poi.xslf.usermodel.XSLFHyperlink;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.awt.Color;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextNormalAutofit;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextStrikeType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextUnderlineType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFTextRun
implements TextRun {
    private final CTRegularTextRun _r;
    private final XSLFTextParagraph _p;

    XSLFTextRun(CTRegularTextRun cTRegularTextRun, XSLFTextParagraph xSLFTextParagraph) {
        this._r = cTRegularTextRun;
        this._p = xSLFTextParagraph;
    }

    XSLFTextParagraph getParentParagraph() {
        return this._p;
    }

    @Override
    public String getRawText() {
        return this._r.getT();
    }

    String getRenderableText() {
        String string = this._r.getT();
        TextRun.TextCap textCap = this.getTextCap();
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\t') {
                stringBuffer.append("  ");
                continue;
            }
            switch (textCap) {
                case ALL: {
                    stringBuffer.append(Character.toUpperCase(c));
                    continue block4;
                }
                case SMALL: {
                    stringBuffer.append(Character.toLowerCase(c));
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void setText(String string) {
        this._r.setT(string);
    }

    public CTRegularTextRun getXmlObject() {
        return this._r;
    }

    @Override
    public void setFontColor(Color color) {
        this.setFontColor(DrawPaint.createSolidPaint(color));
    }

    @Override
    public void setFontColor(PaintStyle paintStyle) {
        if (!(paintStyle instanceof PaintStyle.SolidPaint)) {
            throw new IllegalArgumentException("Currently only SolidPaint is supported!");
        }
        PaintStyle.SolidPaint solidPaint = (PaintStyle.SolidPaint)paintStyle;
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        CTSolidColorFillProperties cTSolidColorFillProperties = cTTextCharacterProperties.isSetSolidFill() ? cTTextCharacterProperties.getSolidFill() : cTTextCharacterProperties.addNewSolidFill();
        CTSRgbColor cTSRgbColor = cTSolidColorFillProperties.isSetSrgbClr() ? cTSolidColorFillProperties.getSrgbClr() : cTSolidColorFillProperties.addNewSrgbClr();
        Color color = DrawPaint.applyColorTransform(solidPaint.getSolidColor());
        cTSRgbColor.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
        if (cTSolidColorFillProperties.isSetHslClr()) {
            cTSolidColorFillProperties.unsetHslClr();
        }
        if (cTSolidColorFillProperties.isSetPrstClr()) {
            cTSolidColorFillProperties.unsetPrstClr();
        }
        if (cTSolidColorFillProperties.isSetSchemeClr()) {
            cTSolidColorFillProperties.unsetSchemeClr();
        }
        if (cTSolidColorFillProperties.isSetScrgbClr()) {
            cTSolidColorFillProperties.unsetScrgbClr();
        }
        if (cTSolidColorFillProperties.isSetSysClr()) {
            cTSolidColorFillProperties.unsetSysClr();
        }
    }

    @Override
    public PaintStyle getFontColor() {
        CharacterPropertyFetcher<PaintStyle> characterPropertyFetcher = new CharacterPropertyFetcher<PaintStyle>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                PaintStyle paintStyle;
                XSLFTextShape xSLFTextShape = XSLFTextRun.this._p.getParentShape();
                CTShapeStyle cTShapeStyle = xSLFTextShape.getSpStyle();
                CTSchemeColor cTSchemeColor = null;
                if (cTShapeStyle != null && cTShapeStyle.getFontRef() != null) {
                    cTSchemeColor = cTShapeStyle.getFontRef().getSchemeClr();
                }
                if ((paintStyle = xSLFTextShape.getPaint((XmlObject)cTTextCharacterProperties, cTSchemeColor)) != null) {
                    this.setValue(paintStyle);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return (PaintStyle)characterPropertyFetcher.getValue();
    }

    @Override
    public void setFontSize(Double d) {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (d == null) {
            if (cTTextCharacterProperties.isSetSz()) {
                cTTextCharacterProperties.unsetSz();
            }
        } else {
            if (d < 1.0) {
                throw new IllegalArgumentException("Minimum font size is 1pt but was " + d);
            }
            cTTextCharacterProperties.setSz((int)(100.0 * d));
        }
    }

    @Override
    public Double getFontSize() {
        double d = 1.0;
        CTTextNormalAutofit cTTextNormalAutofit = this.getParentParagraph().getParentShape().getTextBodyPr().getNormAutofit();
        if (cTTextNormalAutofit != null) {
            d = (double)cTTextNormalAutofit.getFontScale() / 100000.0;
        }
        CharacterPropertyFetcher<Double> characterPropertyFetcher = new CharacterPropertyFetcher<Double>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                if (cTTextCharacterProperties.isSetSz()) {
                    this.setValue((double)cTTextCharacterProperties.getSz() * 0.01);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return characterPropertyFetcher.getValue() == null ? null : Double.valueOf((Double)characterPropertyFetcher.getValue() * d);
    }

    public double getCharacterSpacing() {
        CharacterPropertyFetcher<Double> characterPropertyFetcher = new CharacterPropertyFetcher<Double>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                if (cTTextCharacterProperties.isSetSpc()) {
                    this.setValue((double)cTTextCharacterProperties.getSpc() * 0.01);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return characterPropertyFetcher.getValue() == null ? 0.0 : (Double)characterPropertyFetcher.getValue();
    }

    public void setCharacterSpacing(double d) {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (d == 0.0) {
            if (cTTextCharacterProperties.isSetSpc()) {
                cTTextCharacterProperties.unsetSpc();
            }
        } else {
            cTTextCharacterProperties.setSpc((int)(100.0 * d));
        }
    }

    public void setFontFamily(String string) {
        this.setFontFamily(string, (byte)-1, (byte)-1, false);
    }

    public void setFontFamily(String string, byte by, byte by2, boolean bl) {
        CTTextCharacterProperties cTTextCharacterProperties = this.getRPr();
        if (string == null) {
            if (cTTextCharacterProperties.isSetLatin()) {
                cTTextCharacterProperties.unsetLatin();
            }
            if (cTTextCharacterProperties.isSetCs()) {
                cTTextCharacterProperties.unsetCs();
            }
            if (cTTextCharacterProperties.isSetSym()) {
                cTTextCharacterProperties.unsetSym();
            }
        } else if (bl) {
            CTTextFont cTTextFont = cTTextCharacterProperties.isSetSym() ? cTTextCharacterProperties.getSym() : cTTextCharacterProperties.addNewSym();
            cTTextFont.setTypeface(string);
        } else {
            CTTextFont cTTextFont = cTTextCharacterProperties.isSetLatin() ? cTTextCharacterProperties.getLatin() : cTTextCharacterProperties.addNewLatin();
            cTTextFont.setTypeface(string);
            if (by != -1) {
                cTTextFont.setCharset(by);
            }
            if (by2 != -1) {
                cTTextFont.setPitchFamily(by2);
            }
        }
    }

    @Override
    public String getFontFamily() {
        final XSLFTheme xSLFTheme = this._p.getParentShape().getSheet().getTheme();
        CharacterPropertyFetcher<String> characterPropertyFetcher = new CharacterPropertyFetcher<String>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                CTTextFont cTTextFont = cTTextCharacterProperties.getLatin();
                if (cTTextFont != null) {
                    String string = cTTextFont.getTypeface();
                    if ("+mj-lt".equals(string)) {
                        string = xSLFTheme.getMajorFont();
                    } else if ("+mn-lt".equals(string)) {
                        string = xSLFTheme.getMinorFont();
                    }
                    this.setValue(string);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return (String)characterPropertyFetcher.getValue();
    }

    @Override
    public byte getPitchAndFamily() {
        CharacterPropertyFetcher<Byte> characterPropertyFetcher = new CharacterPropertyFetcher<Byte>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                CTTextFont cTTextFont = cTTextCharacterProperties.getLatin();
                if (cTTextFont != null) {
                    this.setValue(cTTextFont.getPitchFamily());
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return characterPropertyFetcher.getValue() == null ? (byte)0 : (Byte)characterPropertyFetcher.getValue();
    }

    public void setStrikethrough(boolean bl) {
        this.getRPr().setStrike(bl ? STTextStrikeType.SNG_STRIKE : STTextStrikeType.NO_STRIKE);
    }

    @Override
    public boolean isStrikethrough() {
        CharacterPropertyFetcher<Boolean> characterPropertyFetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                if (cTTextCharacterProperties.isSetStrike()) {
                    this.setValue(cTTextCharacterProperties.getStrike() != STTextStrikeType.NO_STRIKE);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return characterPropertyFetcher.getValue() == null ? false : (Boolean)characterPropertyFetcher.getValue();
    }

    @Override
    public boolean isSuperscript() {
        CharacterPropertyFetcher<Boolean> characterPropertyFetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                if (cTTextCharacterProperties.isSetBaseline()) {
                    this.setValue(cTTextCharacterProperties.getBaseline() > 0);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return characterPropertyFetcher.getValue() == null ? false : (Boolean)characterPropertyFetcher.getValue();
    }

    public void setBaselineOffset(double d) {
        this.getRPr().setBaseline((int)d * 1000);
    }

    public void setSuperscript(boolean bl) {
        this.setBaselineOffset(bl ? 30.0 : 0.0);
    }

    public void setSubscript(boolean bl) {
        this.setBaselineOffset(bl ? -25.0 : 0.0);
    }

    @Override
    public boolean isSubscript() {
        CharacterPropertyFetcher<Boolean> characterPropertyFetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                if (cTTextCharacterProperties.isSetBaseline()) {
                    this.setValue(cTTextCharacterProperties.getBaseline() < 0);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return characterPropertyFetcher.getValue() == null ? false : (Boolean)characterPropertyFetcher.getValue();
    }

    @Override
    public TextRun.TextCap getTextCap() {
        CharacterPropertyFetcher<TextRun.TextCap> characterPropertyFetcher = new CharacterPropertyFetcher<TextRun.TextCap>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                if (cTTextCharacterProperties.isSetCap()) {
                    int n = cTTextCharacterProperties.getCap().intValue() - 1;
                    this.setValue(TextRun.TextCap.values()[n]);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return characterPropertyFetcher.getValue() == null ? TextRun.TextCap.NONE : (TextRun.TextCap)((Object)characterPropertyFetcher.getValue());
    }

    public void setBold(boolean bl) {
        this.getRPr().setB(bl);
    }

    @Override
    public boolean isBold() {
        CharacterPropertyFetcher<Boolean> characterPropertyFetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                if (cTTextCharacterProperties.isSetB()) {
                    this.setValue(cTTextCharacterProperties.getB());
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return characterPropertyFetcher.getValue() == null ? false : (Boolean)characterPropertyFetcher.getValue();
    }

    public void setItalic(boolean bl) {
        this.getRPr().setI(bl);
    }

    @Override
    public boolean isItalic() {
        CharacterPropertyFetcher<Boolean> characterPropertyFetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                if (cTTextCharacterProperties.isSetI()) {
                    this.setValue(cTTextCharacterProperties.getI());
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return characterPropertyFetcher.getValue() == null ? false : (Boolean)characterPropertyFetcher.getValue();
    }

    public void setUnderline(boolean bl) {
        this.getRPr().setU(bl ? STTextUnderlineType.SNG : STTextUnderlineType.NONE);
    }

    @Override
    public boolean isUnderlined() {
        CharacterPropertyFetcher<Boolean> characterPropertyFetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties cTTextCharacterProperties) {
                if (cTTextCharacterProperties.isSetU()) {
                    this.setValue(cTTextCharacterProperties.getU() != STTextUnderlineType.NONE);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(characterPropertyFetcher);
        return characterPropertyFetcher.getValue() == null ? false : (Boolean)characterPropertyFetcher.getValue();
    }

    protected CTTextCharacterProperties getRPr() {
        return this._r.isSetRPr() ? this._r.getRPr() : this._r.addNewRPr();
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getRawText();
    }

    public XSLFHyperlink createHyperlink() {
        XSLFHyperlink xSLFHyperlink = new XSLFHyperlink(this._r.getRPr().addNewHlinkClick(), this);
        return xSLFHyperlink;
    }

    public XSLFHyperlink getHyperlink() {
        if (!this._r.getRPr().isSetHlinkClick()) {
            return null;
        }
        return new XSLFHyperlink(this._r.getRPr().getHlinkClick(), this);
    }

    private boolean fetchCharacterProperty(CharacterPropertyFetcher<?> characterPropertyFetcher) {
        XMLSlideShow xMLSlideShow;
        CTTextParagraphProperties cTTextParagraphProperties;
        XSLFTextShape xSLFTextShape = this._p.getParentShape();
        XSLFSheet xSLFSheet = xSLFTextShape.getSheet();
        boolean bl = false;
        if (this._r.isSetRPr()) {
            bl = characterPropertyFetcher.fetch(this.getRPr());
        }
        if (bl) {
            return true;
        }
        bl = xSLFTextShape.fetchShapeProperty(characterPropertyFetcher);
        if (bl) {
            return true;
        }
        CTPlaceholder cTPlaceholder = xSLFTextShape.getCTPlaceholder();
        if (cTPlaceholder == null && (cTTextParagraphProperties = (xMLSlideShow = xSLFSheet.getSlideShow()).getDefaultParagraphStyle(this._p.getIndentLevel())) != null) {
            bl = characterPropertyFetcher.fetch(cTTextParagraphProperties);
        }
        if (bl) {
            return true;
        }
        xMLSlideShow = this._p.getDefaultMasterStyle();
        if (xMLSlideShow != null) {
            bl = characterPropertyFetcher.fetch((CTTextParagraphProperties)xMLSlideShow);
        }
        return bl;
    }

    void copy(XSLFTextRun xSLFTextRun) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        double d;
        PaintStyle paintStyle;
        String string = xSLFTextRun.getFontFamily();
        if (string != null && !string.equals(this.getFontFamily())) {
            this.setFontFamily(string);
        }
        if ((paintStyle = xSLFTextRun.getFontColor()) != null && !paintStyle.equals(this.getFontColor())) {
            this.setFontColor(paintStyle);
        }
        if ((d = xSLFTextRun.getFontSize().doubleValue()) != this.getFontSize()) {
            this.setFontSize(d);
        }
        if ((bl4 = xSLFTextRun.isBold()) != this.isBold()) {
            this.setBold(bl4);
        }
        if ((bl3 = xSLFTextRun.isItalic()) != this.isItalic()) {
            this.setItalic(bl3);
        }
        if ((bl2 = xSLFTextRun.isUnderlined()) != this.isUnderlined()) {
            this.setUnderline(bl2);
        }
        if ((bl = xSLFTextRun.isStrikethrough()) != this.isStrikethrough()) {
            this.setStrikethrough(bl);
        }
    }
}

