/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.usermodel.AutoNumberingScheme;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.TextParagraph;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.model.ParagraphPropertyFetcher;
import ai2.org.apache.poi.xslf.usermodel.XMLSlideShow;
import ai2.org.apache.poi.xslf.usermodel.XSLFColor;
import ai2.org.apache.poi.xslf.usermodel.XSLFLineBreak;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextRun;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextAutonumberBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePercent;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePoint;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextField;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextLineBreak;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextNormalAutofit;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacing;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStopList;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAlignType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAutonumberScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextFontAlignType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFTextParagraph
implements TextParagraph<XSLFShape, XSLFTextParagraph, XSLFTextRun> {
    private final CTTextParagraph _p;
    private final List<XSLFTextRun> _runs;
    private final XSLFTextShape _shape;

    XSLFTextParagraph(CTTextParagraph cTTextParagraph, XSLFTextShape xSLFTextShape) {
        this._p = cTTextParagraph;
        this._runs = new ArrayList<XSLFTextRun>();
        this._shape = xSLFTextShape;
        for (XmlObject xmlObject : this._p.selectPath("*")) {
            CTRegularTextRun cTRegularTextRun;
            CTRegularTextRun cTRegularTextRun2;
            if (xmlObject instanceof CTRegularTextRun) {
                cTRegularTextRun2 = (CTRegularTextRun)xmlObject;
                this._runs.add(new XSLFTextRun(cTRegularTextRun2, this));
                continue;
            }
            if (xmlObject instanceof CTTextLineBreak) {
                cTRegularTextRun2 = (CTTextLineBreak)xmlObject;
                cTRegularTextRun = CTRegularTextRun.Factory.newInstance();
                cTRegularTextRun.setRPr(cTRegularTextRun2.getRPr());
                cTRegularTextRun.setT("\n");
                this._runs.add(new XSLFTextRun(cTRegularTextRun, this));
                continue;
            }
            if (!(xmlObject instanceof CTTextField)) continue;
            cTRegularTextRun2 = (CTTextField)xmlObject;
            cTRegularTextRun = CTRegularTextRun.Factory.newInstance();
            cTRegularTextRun.setRPr(cTRegularTextRun2.getRPr());
            cTRegularTextRun.setT(cTRegularTextRun2.getT());
            this._runs.add(new XSLFTextRun(cTRegularTextRun, this));
        }
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (XSLFTextRun xSLFTextRun : this._runs) {
            stringBuilder.append(xSLFTextRun.getRawText());
        }
        return stringBuilder.toString();
    }

    String getRenderableText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (XSLFTextRun xSLFTextRun : this._runs) {
            stringBuilder.append(xSLFTextRun.getRenderableText());
        }
        return stringBuilder.toString();
    }

    @Internal
    public CTTextParagraph getXmlObject() {
        return this._p;
    }

    public XSLFTextShape getParentShape() {
        return this._shape;
    }

    public List<XSLFTextRun> getTextRuns() {
        return this._runs;
    }

    @Override
    public Iterator<XSLFTextRun> iterator() {
        return this._runs.iterator();
    }

    public XSLFTextRun addNewTextRun() {
        CTRegularTextRun cTRegularTextRun = this._p.addNewR();
        CTTextCharacterProperties cTTextCharacterProperties = cTRegularTextRun.addNewRPr();
        cTTextCharacterProperties.setLang("en-US");
        XSLFTextRun xSLFTextRun = new XSLFTextRun(cTRegularTextRun, this);
        this._runs.add(xSLFTextRun);
        return xSLFTextRun;
    }

    public XSLFTextRun addLineBreak() {
        CTRegularTextRun cTRegularTextRun;
        CTTextLineBreak cTTextLineBreak = this._p.addNewBr();
        CTTextCharacterProperties cTTextCharacterProperties = cTTextLineBreak.addNewRPr();
        if (this._runs.size() > 0) {
            cTRegularTextRun = this._runs.get(this._runs.size() - 1).getRPr();
            cTTextCharacterProperties.set((XmlObject)cTRegularTextRun);
        }
        cTRegularTextRun = CTRegularTextRun.Factory.newInstance();
        cTRegularTextRun.setRPr(cTTextCharacterProperties);
        cTRegularTextRun.setT("\n");
        XSLFLineBreak xSLFLineBreak = new XSLFLineBreak(cTRegularTextRun, this, cTTextCharacterProperties);
        this._runs.add(xSLFLineBreak);
        return xSLFLineBreak;
    }

    @Override
    public TextParagraph.TextAlign getTextAlign() {
        ParagraphPropertyFetcher<TextParagraph.TextAlign> paragraphPropertyFetcher = new ParagraphPropertyFetcher<TextParagraph.TextAlign>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetAlgn()) {
                    TextParagraph.TextAlign textAlign = TextParagraph.TextAlign.values()[cTTextParagraphProperties.getAlgn().intValue() - 1];
                    this.setValue(textAlign);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (TextParagraph.TextAlign)((Object)paragraphPropertyFetcher.getValue());
    }

    public void setTextAlign(TextParagraph.TextAlign textAlign) {
        CTTextParagraphProperties cTTextParagraphProperties;
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (textAlign == null) {
            if (cTTextParagraphProperties.isSetAlgn()) {
                cTTextParagraphProperties.unsetAlgn();
            }
        } else {
            cTTextParagraphProperties.setAlgn(STTextAlignType.Enum.forInt((int)(textAlign.ordinal() + 1)));
        }
    }

    @Override
    public TextParagraph.FontAlign getFontAlign() {
        ParagraphPropertyFetcher<TextParagraph.FontAlign> paragraphPropertyFetcher = new ParagraphPropertyFetcher<TextParagraph.FontAlign>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetFontAlgn()) {
                    TextParagraph.FontAlign fontAlign = TextParagraph.FontAlign.values()[cTTextParagraphProperties.getFontAlgn().intValue() - 1];
                    this.setValue(fontAlign);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (TextParagraph.FontAlign)((Object)paragraphPropertyFetcher.getValue());
    }

    public void setFontAlign(TextParagraph.FontAlign fontAlign) {
        CTTextParagraphProperties cTTextParagraphProperties;
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (fontAlign == null) {
            if (cTTextParagraphProperties.isSetFontAlgn()) {
                cTTextParagraphProperties.unsetFontAlgn();
            }
        } else {
            cTTextParagraphProperties.setFontAlgn(STTextFontAlignType.Enum.forInt((int)(fontAlign.ordinal() + 1)));
        }
    }

    public String getBulletFont() {
        ParagraphPropertyFetcher<String> paragraphPropertyFetcher = new ParagraphPropertyFetcher<String>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuFont()) {
                    this.setValue(cTTextParagraphProperties.getBuFont().getTypeface());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (String)paragraphPropertyFetcher.getValue();
    }

    public void setBulletFont(String string) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextFont cTTextFont = cTTextParagraphProperties.isSetBuFont() ? cTTextParagraphProperties.getBuFont() : cTTextParagraphProperties.addNewBuFont();
        cTTextFont.setTypeface(string);
    }

    public String getBulletCharacter() {
        ParagraphPropertyFetcher<String> paragraphPropertyFetcher = new ParagraphPropertyFetcher<String>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuChar()) {
                    this.setValue(cTTextParagraphProperties.getBuChar().getChar());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (String)paragraphPropertyFetcher.getValue();
    }

    public void setBulletCharacter(String string) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextCharBullet cTTextCharBullet = cTTextParagraphProperties.isSetBuChar() ? cTTextParagraphProperties.getBuChar() : cTTextParagraphProperties.addNewBuChar();
        cTTextCharBullet.setChar(string);
    }

    public PaintStyle getBulletFontColor() {
        final XSLFTheme xSLFTheme = this.getParentShape().getSheet().getTheme();
        ParagraphPropertyFetcher<Color> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Color>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuClr()) {
                    XSLFColor xSLFColor = new XSLFColor((XmlObject)cTTextParagraphProperties.getBuClr(), xSLFTheme, null);
                    this.setValue(xSLFColor.getColor());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        Color color = (Color)paragraphPropertyFetcher.getValue();
        return color == null ? null : DrawPaint.createSolidPaint(color);
    }

    public void setBulletFontColor(Color color) {
        this.setBulletFontColor(DrawPaint.createSolidPaint(color));
    }

    public void setBulletFontColor(PaintStyle paintStyle) {
        if (!(paintStyle instanceof PaintStyle.SolidPaint)) {
            throw new IllegalArgumentException("Currently XSLF only supports SolidPaint");
        }
        PaintStyle.SolidPaint solidPaint = (PaintStyle.SolidPaint)paintStyle;
        Color color = DrawPaint.applyColorTransform(solidPaint.getSolidColor());
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTColor cTColor = cTTextParagraphProperties.isSetBuClr() ? cTTextParagraphProperties.getBuClr() : cTTextParagraphProperties.addNewBuClr();
        CTSRgbColor cTSRgbColor = cTColor.isSetSrgbClr() ? cTColor.getSrgbClr() : cTColor.addNewSrgbClr();
        cTSRgbColor.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
    }

    public Double getBulletFontSize() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuSzPct()) {
                    this.setValue((double)cTTextParagraphProperties.getBuSzPct().getVal() * 0.001);
                    return true;
                }
                if (cTTextParagraphProperties.isSetBuSzPts()) {
                    this.setValue((double)(-cTTextParagraphProperties.getBuSzPts().getVal()) * 0.01);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (Double)paragraphPropertyFetcher.getValue();
    }

    public void setBulletFontSize(double d) {
        CTTextParagraphProperties cTTextParagraphProperties;
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (d >= 0.0) {
            CTTextBulletSizePercent cTTextBulletSizePercent = cTTextParagraphProperties.isSetBuSzPct() ? cTTextParagraphProperties.getBuSzPct() : cTTextParagraphProperties.addNewBuSzPct();
            cTTextBulletSizePercent.setVal((int)(d * 1000.0));
            if (cTTextParagraphProperties.isSetBuSzPts()) {
                cTTextParagraphProperties.unsetBuSzPts();
            }
        } else {
            CTTextBulletSizePoint cTTextBulletSizePoint = cTTextParagraphProperties.isSetBuSzPts() ? cTTextParagraphProperties.getBuSzPts() : cTTextParagraphProperties.addNewBuSzPts();
            cTTextBulletSizePoint.setVal((int)(-d * 100.0));
            if (cTTextParagraphProperties.isSetBuSzPct()) {
                cTTextParagraphProperties.unsetBuSzPct();
            }
        }
    }

    public AutoNumberingScheme getAutoNumberingScheme() {
        ParagraphPropertyFetcher<AutoNumberingScheme> paragraphPropertyFetcher = new ParagraphPropertyFetcher<AutoNumberingScheme>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                AutoNumberingScheme autoNumberingScheme;
                if (cTTextParagraphProperties.isSetBuAutoNum() && (autoNumberingScheme = AutoNumberingScheme.forOoxmlID(cTTextParagraphProperties.getBuAutoNum().getType().intValue())) != null) {
                    this.setValue(autoNumberingScheme);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (AutoNumberingScheme)((Object)paragraphPropertyFetcher.getValue());
    }

    public Integer getAutoNumberingStartAt() {
        ParagraphPropertyFetcher<Integer> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Integer>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuAutoNum() && cTTextParagraphProperties.getBuAutoNum().isSetStartAt()) {
                    this.setValue(cTTextParagraphProperties.getBuAutoNum().getStartAt());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (Integer)paragraphPropertyFetcher.getValue();
    }

    @Override
    public void setIndent(Double d) {
        CTTextParagraphProperties cTTextParagraphProperties;
        if (d == null && !this._p.isSetPPr()) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (d == null) {
            if (cTTextParagraphProperties.isSetIndent()) {
                cTTextParagraphProperties.unsetIndent();
            }
        } else {
            cTTextParagraphProperties.setIndent(Units.toEMU(d));
        }
    }

    @Override
    public Double getIndent() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetIndent()) {
                    this.setValue(Units.toPoints(cTTextParagraphProperties.getIndent()));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (Double)paragraphPropertyFetcher.getValue();
    }

    @Override
    public void setLeftMargin(Double d) {
        CTTextParagraphProperties cTTextParagraphProperties;
        if (d == null && !this._p.isSetPPr()) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (d == null) {
            if (cTTextParagraphProperties.isSetMarL()) {
                cTTextParagraphProperties.unsetMarL();
            }
        } else {
            cTTextParagraphProperties.setMarL(Units.toEMU(d));
        }
    }

    @Override
    public Double getLeftMargin() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetMarL()) {
                    double d = Units.toPoints(cTTextParagraphProperties.getMarL());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (Double)paragraphPropertyFetcher.getValue();
    }

    @Override
    public void setRightMargin(Double d) {
        CTTextParagraphProperties cTTextParagraphProperties;
        if (d == null && !this._p.isSetPPr()) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (d == null) {
            if (cTTextParagraphProperties.isSetMarR()) {
                cTTextParagraphProperties.unsetMarR();
            }
        } else {
            cTTextParagraphProperties.setMarR(Units.toEMU(d));
        }
    }

    @Override
    public Double getRightMargin() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetMarR()) {
                    double d = Units.toPoints(cTTextParagraphProperties.getMarR());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (Double)paragraphPropertyFetcher.getValue();
    }

    @Override
    public Double getDefaultTabSize() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetDefTabSz()) {
                    double d = Units.toPoints(cTTextParagraphProperties.getDefTabSz());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (Double)paragraphPropertyFetcher.getValue();
    }

    public double getTabStop(final int n) {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                CTTextTabStopList cTTextTabStopList;
                if (cTTextParagraphProperties.isSetTabLst() && n < (cTTextTabStopList = cTTextParagraphProperties.getTabLst()).sizeOfTabArray()) {
                    CTTextTabStop cTTextTabStop = cTTextTabStopList.getTabArray(n);
                    double d = Units.toPoints(cTTextTabStop.getPos());
                    this.setValue(d);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? 0.0 : (Double)paragraphPropertyFetcher.getValue();
    }

    public void addTabStop(double d) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextTabStopList cTTextTabStopList = cTTextParagraphProperties.isSetTabLst() ? cTTextParagraphProperties.getTabLst() : cTTextParagraphProperties.addNewTabLst();
        cTTextTabStopList.addNewTab().setPos(Units.toEMU(d));
    }

    @Override
    public void setLineSpacing(Double d) {
        CTTextParagraphProperties cTTextParagraphProperties;
        if (d == null && !this._p.isSetPPr()) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (d == null) {
            if (cTTextParagraphProperties.isSetLnSpc()) {
                cTTextParagraphProperties.unsetLnSpc();
            }
        } else {
            CTTextSpacing cTTextSpacing;
            CTTextSpacing cTTextSpacing2 = cTTextSpacing = cTTextParagraphProperties.isSetLnSpc() ? cTTextParagraphProperties.getLnSpc() : cTTextParagraphProperties.addNewLnSpc();
            if (d >= 0.0) {
                (cTTextSpacing.isSetSpcPct() ? cTTextSpacing.getSpcPct() : cTTextSpacing.addNewSpcPct()).setVal((int)(d * 1000.0));
                if (cTTextSpacing.isSetSpcPts()) {
                    cTTextSpacing.unsetSpcPts();
                }
            } else {
                (cTTextSpacing.isSetSpcPts() ? cTTextSpacing.getSpcPts() : cTTextSpacing.addNewSpcPts()).setVal((int)(-d.doubleValue() * 100.0));
                if (cTTextSpacing.isSetSpcPct()) {
                    cTTextSpacing.unsetSpcPct();
                }
            }
        }
    }

    @Override
    public Double getLineSpacing() {
        CTTextNormalAutofit cTTextNormalAutofit;
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetLnSpc()) {
                    CTTextSpacing cTTextSpacing = cTTextParagraphProperties.getLnSpc();
                    if (cTTextSpacing.isSetSpcPct()) {
                        this.setValue((double)cTTextSpacing.getSpcPct().getVal() * 0.001);
                    } else if (cTTextSpacing.isSetSpcPts()) {
                        this.setValue((double)(-cTTextSpacing.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        Double d = (Double)paragraphPropertyFetcher.getValue();
        if (d != null && d > 0.0 && (cTTextNormalAutofit = this.getParentShape().getTextBodyPr().getNormAutofit()) != null) {
            double d2 = 1.0 - (double)cTTextNormalAutofit.getLnSpcReduction() / 100000.0;
            d = d * d2;
        }
        return d;
    }

    @Override
    public void setSpaceBefore(Double d) {
        if (d == null && !this._p.isSetPPr()) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing cTTextSpacing = CTTextSpacing.Factory.newInstance();
        if (d >= 0.0) {
            cTTextSpacing.addNewSpcPct().setVal((int)(d * 1000.0));
        } else {
            cTTextSpacing.addNewSpcPts().setVal((int)(-d.doubleValue() * 100.0));
        }
        cTTextParagraphProperties.setSpcBef(cTTextSpacing);
    }

    @Override
    public Double getSpaceBefore() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetSpcBef()) {
                    CTTextSpacing cTTextSpacing = cTTextParagraphProperties.getSpcBef();
                    if (cTTextSpacing.isSetSpcPct()) {
                        this.setValue((double)cTTextSpacing.getSpcPct().getVal() * 0.001);
                    } else if (cTTextSpacing.isSetSpcPts()) {
                        this.setValue((double)(-cTTextSpacing.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (Double)paragraphPropertyFetcher.getValue();
    }

    @Override
    public void setSpaceAfter(Double d) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing cTTextSpacing = CTTextSpacing.Factory.newInstance();
        if (d >= 0.0) {
            cTTextSpacing.addNewSpcPct().setVal((int)(d * 1000.0));
        } else {
            cTTextSpacing.addNewSpcPts().setVal((int)(-d.doubleValue() * 100.0));
        }
        cTTextParagraphProperties.setSpcAft(cTTextSpacing);
    }

    @Override
    public Double getSpaceAfter() {
        ParagraphPropertyFetcher<Double> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetSpcAft()) {
                    CTTextSpacing cTTextSpacing = cTTextParagraphProperties.getSpcAft();
                    if (cTTextSpacing.isSetSpcPct()) {
                        this.setValue((double)cTTextSpacing.getSpcPct().getVal() * 0.001);
                    } else if (cTTextSpacing.isSetSpcPts()) {
                        this.setValue((double)(-cTTextSpacing.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return (Double)paragraphPropertyFetcher.getValue();
    }

    @Override
    public void setIndentLevel(int n) {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        cTTextParagraphProperties.setLvl(n);
    }

    @Override
    public int getIndentLevel() {
        CTTextParagraphProperties cTTextParagraphProperties = this._p.getPPr();
        return cTTextParagraphProperties == null || !cTTextParagraphProperties.isSetLvl() ? 0 : cTTextParagraphProperties.getLvl();
    }

    public boolean isBullet() {
        ParagraphPropertyFetcher<Boolean> paragraphPropertyFetcher = new ParagraphPropertyFetcher<Boolean>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties cTTextParagraphProperties) {
                if (cTTextParagraphProperties.isSetBuNone()) {
                    this.setValue(false);
                    return true;
                }
                if (cTTextParagraphProperties.isSetBuFont() || cTTextParagraphProperties.isSetBuChar()) {
                    this.setValue(true);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(paragraphPropertyFetcher);
        return paragraphPropertyFetcher.getValue() == null ? false : (Boolean)paragraphPropertyFetcher.getValue();
    }

    public void setBullet(boolean bl) {
        CTTextParagraphProperties cTTextParagraphProperties;
        if (this.isBullet() == bl) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties2 = cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (bl) {
            cTTextParagraphProperties.addNewBuFont().setTypeface("Arial");
            cTTextParagraphProperties.addNewBuChar().setChar("\u2022");
        } else {
            if (cTTextParagraphProperties.isSetBuFont()) {
                cTTextParagraphProperties.unsetBuFont();
            }
            if (cTTextParagraphProperties.isSetBuChar()) {
                cTTextParagraphProperties.unsetBuChar();
            }
            if (cTTextParagraphProperties.isSetBuAutoNum()) {
                cTTextParagraphProperties.unsetBuAutoNum();
            }
            if (cTTextParagraphProperties.isSetBuBlip()) {
                cTTextParagraphProperties.unsetBuBlip();
            }
            if (cTTextParagraphProperties.isSetBuClr()) {
                cTTextParagraphProperties.unsetBuClr();
            }
            if (cTTextParagraphProperties.isSetBuClrTx()) {
                cTTextParagraphProperties.unsetBuClrTx();
            }
            if (cTTextParagraphProperties.isSetBuFont()) {
                cTTextParagraphProperties.unsetBuFont();
            }
            if (cTTextParagraphProperties.isSetBuFontTx()) {
                cTTextParagraphProperties.unsetBuFontTx();
            }
            if (cTTextParagraphProperties.isSetBuSzPct()) {
                cTTextParagraphProperties.unsetBuSzPct();
            }
            if (cTTextParagraphProperties.isSetBuSzPts()) {
                cTTextParagraphProperties.unsetBuSzPts();
            }
            if (cTTextParagraphProperties.isSetBuSzTx()) {
                cTTextParagraphProperties.unsetBuSzTx();
            }
            cTTextParagraphProperties.addNewBuNone();
        }
    }

    public void setBulletAutoNumber(AutoNumberingScheme autoNumberingScheme, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Start Number must be greater or equal that 1");
        }
        CTTextParagraphProperties cTTextParagraphProperties = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextAutonumberBullet cTTextAutonumberBullet = cTTextParagraphProperties.isSetBuAutoNum() ? cTTextParagraphProperties.getBuAutoNum() : cTTextParagraphProperties.addNewBuAutoNum();
        cTTextAutonumberBullet.setType(STTextAutonumberScheme.Enum.forInt((int)autoNumberingScheme.ooxmlId));
        cTTextAutonumberBullet.setStartAt(n);
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getText();
    }

    CTTextParagraphProperties getDefaultMasterStyle() {
        XSLFSheet xSLFSheet;
        String string;
        CTPlaceholder cTPlaceholder = this._shape.getCTPlaceholder();
        switch (cTPlaceholder == null ? -1 : cTPlaceholder.getType().intValue()) {
            case 1: 
            case 3: {
                string = "titleStyle";
                break;
            }
            case -1: 
            case 5: 
            case 6: 
            case 7: {
                string = "otherStyle";
                break;
            }
            default: {
                string = "bodyStyle";
            }
        }
        int n = this.getIndentLevel();
        String[] stringArray = new String[]{"declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//p:txStyles/p:" + string + "/a:lvl" + (n + 1) + "pPr", "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//p:notesStyle/a:lvl" + (n + 1) + "pPr"};
        for (XSLFSheet xSLFSheet2 = xSLFSheet = this._shape.getSheet(); xSLFSheet2 != null; xSLFSheet2 = (XSLFSheet)((Object)xSLFSheet2.getMasterSheet())) {
            xSLFSheet = xSLFSheet2;
            XmlObject xmlObject = xSLFSheet.getXmlObject();
            for (String string2 : stringArray) {
                XmlObject[] xmlObjectArray = xmlObject.selectPath(string2);
                if (xmlObjectArray.length != 1) continue;
                return (CTTextParagraphProperties)xmlObjectArray[0];
            }
        }
        return null;
    }

    private <T> boolean fetchParagraphProperty(ParagraphPropertyFetcher<T> paragraphPropertyFetcher) {
        XMLSlideShow xMLSlideShow;
        CTTextParagraphProperties cTTextParagraphProperties;
        boolean bl = false;
        XSLFTextShape xSLFTextShape = this.getParentShape();
        XSLFSheet xSLFSheet = xSLFTextShape.getSheet();
        if (this._p.isSetPPr()) {
            bl = paragraphPropertyFetcher.fetch(this._p.getPPr());
        }
        if (bl) {
            return true;
        }
        bl = xSLFTextShape.fetchShapeProperty(paragraphPropertyFetcher);
        if (bl) {
            return true;
        }
        CTPlaceholder cTPlaceholder = xSLFTextShape.getCTPlaceholder();
        if (cTPlaceholder == null && (cTTextParagraphProperties = (xMLSlideShow = xSLFSheet.getSlideShow()).getDefaultParagraphStyle(this.getIndentLevel())) != null) {
            bl = paragraphPropertyFetcher.fetch(cTTextParagraphProperties);
        }
        if (bl) {
            return true;
        }
        xMLSlideShow = this.getDefaultMasterStyle();
        if (xMLSlideShow != null) {
            bl = paragraphPropertyFetcher.fetch((CTTextParagraphProperties)xMLSlideShow);
        }
        return bl;
    }

    void copy(XSLFTextParagraph xSLFTextParagraph) {
        Double d;
        Double d2;
        Double d3;
        Double d4;
        Object object;
        int n2;
        if (xSLFTextParagraph == this) {
            return;
        }
        CTTextParagraph cTTextParagraph = this.getXmlObject();
        CTTextParagraph cTTextParagraph2 = xSLFTextParagraph.getXmlObject();
        if (cTTextParagraph.isSetPPr()) {
            cTTextParagraph.unsetPPr();
        }
        if (cTTextParagraph.isSetEndParaRPr()) {
            cTTextParagraph.unsetEndParaRPr();
        }
        this._runs.clear();
        for (n2 = cTTextParagraph.sizeOfBrArray(); n2 > 0; --n2) {
            cTTextParagraph.removeBr(n2 - 1);
        }
        for (n2 = cTTextParagraph.sizeOfRArray(); n2 > 0; --n2) {
            cTTextParagraph.removeR(n2 - 1);
        }
        for (n2 = cTTextParagraph.sizeOfFldArray(); n2 > 0; --n2) {
            cTTextParagraph.removeFld(n2 - 1);
        }
        XmlCursor xmlCursor = cTTextParagraph.newCursor();
        xmlCursor.toEndToken();
        XmlCursor xmlCursor2 = cTTextParagraph2.newCursor();
        xmlCursor2.copyXmlContents(xmlCursor);
        xmlCursor2.dispose();
        xmlCursor.dispose();
        List<XSLFTextRun> list = xSLFTextParagraph.getTextRuns();
        int n3 = 0;
        CTRegularTextRun[] object3 = cTTextParagraph.getRArray();
        int n = object3.length;
        for (int string = 0; string < n; ++string) {
            CTRegularTextRun cTRegularTextRun = object3[string];
            object = new XSLFTextRun(cTRegularTextRun, this);
            ((XSLFTextRun)object).copy(list.get(n3++));
            this._runs.add((XSLFTextRun)object);
        }
        TextParagraph.TextAlign textAlign = xSLFTextParagraph.getTextAlign();
        if (textAlign != this.getTextAlign()) {
            this.setTextAlign(textAlign);
        }
        if ((n = (int)(xSLFTextParagraph.isBullet() ? 1 : 0)) != this.isBullet()) {
            this.setBullet(n != 0);
            if (n != 0) {
                String string;
                String d22 = xSLFTextParagraph.getBulletFont();
                if (d22 != null && !d22.equals(this.getBulletFont())) {
                    this.setBulletFont(d22);
                }
                if ((string = xSLFTextParagraph.getBulletCharacter()) != null && !string.equals(this.getBulletCharacter())) {
                    this.setBulletCharacter(string);
                }
                if ((object = xSLFTextParagraph.getBulletFontColor()) != null && !object.equals(this.getBulletFontColor())) {
                    this.setBulletFontColor((PaintStyle)object);
                }
                if (!XSLFTextParagraph.doubleEquals(d4 = xSLFTextParagraph.getBulletFontSize(), this.getBulletFontSize())) {
                    this.setBulletFontSize(d4);
                }
            }
        }
        if (!XSLFTextParagraph.doubleEquals(d3 = xSLFTextParagraph.getLeftMargin(), this.getLeftMargin())) {
            this.setLeftMargin(d3);
        }
        if (!XSLFTextParagraph.doubleEquals(d2 = xSLFTextParagraph.getIndent(), this.getIndent())) {
            this.setIndent(d2);
        }
        if (!XSLFTextParagraph.doubleEquals((Double)(object = xSLFTextParagraph.getSpaceAfter()), this.getSpaceAfter())) {
            this.setSpaceAfter((Double)object);
        }
        if (!XSLFTextParagraph.doubleEquals(d4 = xSLFTextParagraph.getSpaceBefore(), this.getSpaceBefore())) {
            this.setSpaceBefore(d4);
        }
        if (!XSLFTextParagraph.doubleEquals(d = xSLFTextParagraph.getLineSpacing(), this.getLineSpacing())) {
            this.setLineSpacing(d);
        }
    }

    private static boolean doubleEquals(Double d, Double d2) {
        return d == d2 || d != null && d.equals(d2);
    }

    @Override
    public Double getDefaultFontSize() {
        CTTextCharacterProperties cTTextCharacterProperties = this._p.getEndParaRPr();
        return cTTextCharacterProperties == null || !cTTextCharacterProperties.isSetSz() ? 12.0 : (double)cTTextCharacterProperties.getSz() / 100.0;
    }

    @Override
    public String getDefaultFontFamily() {
        return this._runs.isEmpty() ? "Arial" : this._runs.get(0).getFontFamily();
    }

    @Override
    public TextParagraph.BulletStyle getBulletStyle() {
        if (!this.isBullet()) {
            return null;
        }
        return new TextParagraph.BulletStyle(){

            public String getBulletCharacter() {
                return XSLFTextParagraph.this.getBulletCharacter();
            }

            public String getBulletFont() {
                return XSLFTextParagraph.this.getBulletFont();
            }

            public Double getBulletFontSize() {
                return XSLFTextParagraph.this.getBulletFontSize();
            }

            public PaintStyle getBulletFontColor() {
                return XSLFTextParagraph.this.getBulletFontColor();
            }

            public void setBulletFontColor(Color color) {
                this.setBulletFontColor(DrawPaint.createSolidPaint(color));
            }

            public void setBulletFontColor(PaintStyle paintStyle) {
                XSLFTextParagraph.this.setBulletFontColor(paintStyle);
            }

            public AutoNumberingScheme getAutoNumberingScheme() {
                return XSLFTextParagraph.this.getAutoNumberingScheme();
            }

            public Integer getAutoNumberingStartAt() {
                return XSLFTextParagraph.this.getAutoNumberingStartAt();
            }
        };
    }
}

