/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.usermodel.XSLFTable;
import ai2.org.apache.poi.xslf.usermodel.XSLFTableCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCell;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFTableRow
implements Iterable<XSLFTableCell> {
    private CTTableRow _row;
    private List<XSLFTableCell> _cells;
    private XSLFTable _table;

    XSLFTableRow(CTTableRow cTTableRow, XSLFTable xSLFTable) {
        this._row = cTTableRow;
        this._table = xSLFTable;
        CTTableCell[] cTTableCellArray = this._row.getTcArray();
        this._cells = new ArrayList<XSLFTableCell>(cTTableCellArray.length);
        for (CTTableCell cTTableCell : cTTableCellArray) {
            this._cells.add(new XSLFTableCell(cTTableCell, xSLFTable.getSheet()));
        }
    }

    public CTTableRow getXmlObject() {
        return this._row;
    }

    @Override
    public Iterator<XSLFTableCell> iterator() {
        return this._cells.iterator();
    }

    public List<XSLFTableCell> getCells() {
        return Collections.unmodifiableList(this._cells);
    }

    public double getHeight() {
        return Units.toPoints(this._row.getH());
    }

    public void setHeight(double d) {
        this._row.setH((long)Units.toEMU(d));
    }

    public XSLFTableCell addCell() {
        CTTableCell cTTableCell = this._row.addNewTc();
        cTTableCell.set((XmlObject)XSLFTableCell.prototype());
        XSLFTableCell xSLFTableCell = new XSLFTableCell(cTTableCell, this._table.getSheet());
        this._cells.add(xSLFTableCell);
        if (this._table.getNumberOfColumns() < this._row.sizeOfTcArray()) {
            this._table.getCTTable().getTblGrid().addNewGridCol().setW((long)Units.toEMU(100.0));
        }
        return xSLFTableCell;
    }
}

