/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.sl.usermodel.TableCell;
import ai2.org.apache.poi.sl.usermodel.VerticalAlignment;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextShape;
import java.awt.Color;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineEndProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCell;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableCellProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.STCompoundLine;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineCap;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndLength;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndType;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndWidth;
import org.openxmlformats.schemas.drawingml.x2006.main.STPenAlignment;
import org.openxmlformats.schemas.drawingml.x2006.main.STPresetLineDashVal;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFTableCell
extends XSLFTextShape
implements TableCell<XSLFShape, XSLFTextParagraph> {
    static double defaultBorderWidth = 1.0;
    private CTTableCellProperties _tcPr = null;

    XSLFTableCell(CTTableCell cTTableCell, XSLFSheet xSLFSheet) {
        super((XmlObject)cTTableCell, xSLFSheet);
    }

    @Override
    protected CTTextBody getTextBody(boolean bl) {
        CTTableCell cTTableCell = (CTTableCell)this.getXmlObject();
        CTTextBody cTTextBody = cTTableCell.getTxBody();
        if (cTTextBody == null && bl) {
            cTTextBody = cTTableCell.addNewTxBody();
            cTTextBody.addNewBodyPr();
            cTTextBody.addNewLstStyle();
        }
        return cTTextBody;
    }

    static CTTableCell prototype() {
        CTTableCell cTTableCell = CTTableCell.Factory.newInstance();
        CTTableCellProperties cTTableCellProperties = cTTableCell.addNewTcPr();
        cTTableCellProperties.addNewLnL().addNewNoFill();
        cTTableCellProperties.addNewLnR().addNewNoFill();
        cTTableCellProperties.addNewLnT().addNewNoFill();
        cTTableCellProperties.addNewLnB().addNewNoFill();
        return cTTableCell;
    }

    protected CTTableCellProperties getCellProperties(boolean bl) {
        if (this._tcPr == null) {
            CTTableCell cTTableCell = (CTTableCell)this.getXmlObject();
            this._tcPr = cTTableCell.getTcPr();
            if (this._tcPr == null && bl) {
                this._tcPr = cTTableCell.addNewTcPr();
            }
        }
        return this._tcPr;
    }

    @Override
    public void setLeftInset(double d) {
        CTTableCellProperties cTTableCellProperties = this.getCellProperties(true);
        cTTableCellProperties.setMarL(Units.toEMU(d));
    }

    @Override
    public void setRightInset(double d) {
        CTTableCellProperties cTTableCellProperties = this.getCellProperties(true);
        cTTableCellProperties.setMarR(Units.toEMU(d));
    }

    @Override
    public void setTopInset(double d) {
        CTTableCellProperties cTTableCellProperties = this.getCellProperties(true);
        cTTableCellProperties.setMarT(Units.toEMU(d));
    }

    @Override
    public void setBottomInset(double d) {
        CTTableCellProperties cTTableCellProperties = this.getCellProperties(true);
        cTTableCellProperties.setMarB(Units.toEMU(d));
    }

    private CTLineProperties getCTLine(char c, boolean bl) {
        CTTableCellProperties cTTableCellProperties = this.getCellProperties(bl);
        if (cTTableCellProperties == null) {
            return null;
        }
        switch (c) {
            case 'b': {
                return cTTableCellProperties.isSetLnB() ? cTTableCellProperties.getLnB() : (bl ? cTTableCellProperties.addNewLnB() : null);
            }
            case 'l': {
                return cTTableCellProperties.isSetLnL() ? cTTableCellProperties.getLnL() : (bl ? cTTableCellProperties.addNewLnL() : null);
            }
            case 't': {
                return cTTableCellProperties.isSetLnT() ? cTTableCellProperties.getLnT() : (bl ? cTTableCellProperties.addNewLnT() : null);
            }
            case 'r': {
                return cTTableCellProperties.isSetLnR() ? cTTableCellProperties.getLnR() : (bl ? cTTableCellProperties.addNewLnR() : null);
            }
        }
        return null;
    }

    private void setBorderWidth(char c, double d) {
        CTLineProperties cTLineProperties = this.getCTLine(c, true);
        cTLineProperties.setW(Units.toEMU(d));
    }

    private double getBorderWidth(char c) {
        CTLineProperties cTLineProperties = this.getCTLine(c, false);
        return cTLineProperties == null || !cTLineProperties.isSetW() ? defaultBorderWidth : Units.toPoints(cTLineProperties.getW());
    }

    private void setBorderColor(char c, Color color) {
        CTLineProperties cTLineProperties = this.getCTLine(c, true);
        if (color == null) {
            cTLineProperties.addNewNoFill();
            if (cTLineProperties.isSetSolidFill()) {
                cTLineProperties.unsetSolidFill();
            }
        } else {
            if (cTLineProperties.isSetNoFill()) {
                cTLineProperties.unsetNoFill();
            }
            if (!cTLineProperties.isSetPrstDash()) {
                cTLineProperties.addNewPrstDash().setVal(STPresetLineDashVal.SOLID);
            }
            cTLineProperties.setCmpd(STCompoundLine.SNG);
            cTLineProperties.setAlgn(STPenAlignment.CTR);
            cTLineProperties.setCap(STLineCap.FLAT);
            cTLineProperties.addNewRound();
            CTLineEndProperties cTLineEndProperties = cTLineProperties.addNewHeadEnd();
            cTLineEndProperties.setType(STLineEndType.NONE);
            cTLineEndProperties.setW(STLineEndWidth.MED);
            cTLineEndProperties.setLen(STLineEndLength.MED);
            CTLineEndProperties cTLineEndProperties2 = cTLineProperties.addNewTailEnd();
            cTLineEndProperties2.setType(STLineEndType.NONE);
            cTLineEndProperties2.setW(STLineEndWidth.MED);
            cTLineEndProperties2.setLen(STLineEndLength.MED);
            CTSRgbColor cTSRgbColor = CTSRgbColor.Factory.newInstance();
            cTSRgbColor.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            cTLineProperties.addNewSolidFill().setSrgbClr(cTSRgbColor);
        }
    }

    private Color getBorderColor(char c) {
        CTLineProperties cTLineProperties = this.getCTLine(c, false);
        if (cTLineProperties == null || cTLineProperties.isSetNoFill() || !cTLineProperties.isSetSolidFill()) {
            return null;
        }
        CTSolidColorFillProperties cTSolidColorFillProperties = cTLineProperties.getSolidFill();
        if (!cTSolidColorFillProperties.isSetSrgbClr()) {
            return null;
        }
        byte[] byArray = cTSolidColorFillProperties.getSrgbClr().getVal();
        return new Color(0xFF & byArray[0], 0xFF & byArray[1], 0xFF & byArray[2]);
    }

    public void setBorderLeft(double d) {
        this.setBorderWidth('l', d);
    }

    public double getBorderLeft() {
        return this.getBorderWidth('l');
    }

    public void setBorderLeftColor(Color color) {
        this.setBorderColor('l', color);
    }

    public Color getBorderLeftColor() {
        return this.getBorderColor('l');
    }

    public void setBorderRight(double d) {
        this.setBorderWidth('r', d);
    }

    public double getBorderRight() {
        return this.getBorderWidth('r');
    }

    public void setBorderRightColor(Color color) {
        this.setBorderColor('r', color);
    }

    public Color getBorderRightColor() {
        return this.getBorderColor('r');
    }

    public void setBorderTop(double d) {
        this.setBorderWidth('t', d);
    }

    public double getBorderTop() {
        return this.getBorderWidth('t');
    }

    public void setBorderTopColor(Color color) {
        this.setBorderColor('t', color);
    }

    public Color getBorderTopColor() {
        return this.getBorderColor('t');
    }

    public void setBorderBottom(double d) {
        this.setBorderWidth('b', d);
    }

    public double getBorderBottom() {
        return this.getBorderWidth('b');
    }

    public void setBorderBottomColor(Color color) {
        this.setBorderColor('b', color);
    }

    public Color getBorderBottomColor() {
        return this.getBorderColor('b');
    }

    @Override
    public void setFillColor(Color color) {
        CTTableCellProperties cTTableCellProperties = this.getCellProperties(true);
        if (color == null) {
            if (cTTableCellProperties.isSetSolidFill()) {
                cTTableCellProperties.unsetSolidFill();
            }
        } else {
            CTSolidColorFillProperties cTSolidColorFillProperties = cTTableCellProperties.isSetSolidFill() ? cTTableCellProperties.getSolidFill() : cTTableCellProperties.addNewSolidFill();
            CTSRgbColor cTSRgbColor = CTSRgbColor.Factory.newInstance();
            cTSRgbColor.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            cTSolidColorFillProperties.setSrgbClr(cTSRgbColor);
        }
    }

    @Override
    public Color getFillColor() {
        CTTableCellProperties cTTableCellProperties = this.getCellProperties(false);
        if (cTTableCellProperties == null || !cTTableCellProperties.isSetSolidFill()) {
            return null;
        }
        CTSolidColorFillProperties cTSolidColorFillProperties = cTTableCellProperties.getSolidFill();
        if (!cTSolidColorFillProperties.isSetSrgbClr()) {
            return null;
        }
        byte[] byArray = cTSolidColorFillProperties.getSrgbClr().getVal();
        return new Color(0xFF & byArray[0], 0xFF & byArray[1], 0xFF & byArray[2]);
    }

    void setGridSpan(int n) {
        ((CTTableCell)this.getXmlObject()).setGridSpan(n);
    }

    void setRowSpan(int n) {
        ((CTTableCell)this.getXmlObject()).setRowSpan(n);
    }

    void setHMerge(boolean bl) {
        ((CTTableCell)this.getXmlObject()).setHMerge(bl);
    }

    void setVMerge(boolean bl) {
        ((CTTableCell)this.getXmlObject()).setVMerge(bl);
    }

    @Override
    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        CTTableCellProperties cTTableCellProperties = this.getCellProperties(true);
        if (verticalAlignment == null) {
            if (cTTableCellProperties.isSetAnchor()) {
                cTTableCellProperties.unsetAnchor();
            }
        } else {
            cTTableCellProperties.setAnchor(STTextAnchoringType.Enum.forInt((int)(verticalAlignment.ordinal() + 1)));
        }
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        CTTableCellProperties cTTableCellProperties = this.getCellProperties(false);
        VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
        if (cTTableCellProperties != null && cTTableCellProperties.isSetAnchor()) {
            int n = cTTableCellProperties.getAnchor().intValue();
            verticalAlignment = VerticalAlignment.values()[n - 1];
        }
        return verticalAlignment;
    }
}

