/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.sl.usermodel.MasterSheet;
import ai2.org.apache.poi.xslf.usermodel.Placeholder;
import ai2.org.apache.poi.xslf.usermodel.SlideLayout;
import ai2.org.apache.poi.xslf.usermodel.XSLFBackground;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorMapping;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextListStyle;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMaster;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMasterTextStyles;
import org.openxmlformats.schemas.presentationml.x2006.main.SldMasterDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFSlideMaster
extends XSLFSheet
implements MasterSheet<XSLFShape, XSLFTextParagraph> {
    private CTSlideMaster _slide;
    private Map<String, XSLFSlideLayout> _layouts;
    private XSLFTheme _theme;

    XSLFSlideMaster() {
        this._slide = CTSlideMaster.Factory.newInstance();
    }

    protected XSLFSlideMaster(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, XmlException {
        super(packagePart, packageRelationship);
        SldMasterDocument sldMasterDocument = SldMasterDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._slide = sldMasterDocument.getSldMaster();
        this.setCommonSlideData(this._slide.getCSld());
    }

    public CTSlideMaster getXmlObject() {
        return this._slide;
    }

    @Override
    protected String getRootElementName() {
        return "sldMaster";
    }

    public XSLFSlideMaster getMasterSheet() {
        return null;
    }

    private Map<String, XSLFSlideLayout> getLayouts() {
        if (this._layouts == null) {
            this._layouts = new HashMap<String, XSLFSlideLayout>();
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                if (!(pOIXMLDocumentPart instanceof XSLFSlideLayout)) continue;
                XSLFSlideLayout xSLFSlideLayout = (XSLFSlideLayout)pOIXMLDocumentPart;
                this._layouts.put(xSLFSlideLayout.getName().toLowerCase(Locale.ROOT), xSLFSlideLayout);
            }
        }
        return this._layouts;
    }

    public XSLFSlideLayout[] getSlideLayouts() {
        return this.getLayouts().values().toArray(new XSLFSlideLayout[this._layouts.size()]);
    }

    public XSLFSlideLayout getLayout(SlideLayout slideLayout) {
        for (XSLFSlideLayout xSLFSlideLayout : this.getLayouts().values()) {
            if (xSLFSlideLayout.getType() != slideLayout) continue;
            return xSLFSlideLayout;
        }
        return null;
    }

    public XSLFSlideLayout getLayout(String string) {
        return this.getLayouts().get(string.toLowerCase(Locale.ROOT));
    }

    @Override
    public XSLFTheme getTheme() {
        if (this._theme == null) {
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                if (!(pOIXMLDocumentPart instanceof XSLFTheme)) continue;
                this._theme = (XSLFTheme)pOIXMLDocumentPart;
                CTColorMapping cTColorMapping = this._slide.getClrMap();
                if (cTColorMapping == null) break;
                this._theme.initColorMap(cTColorMapping);
                break;
            }
        }
        return this._theme;
    }

    protected CTTextListStyle getTextProperties(Placeholder placeholder) {
        CTTextListStyle cTTextListStyle;
        CTSlideMasterTextStyles cTSlideMasterTextStyles = this.getXmlObject().getTxStyles();
        switch (placeholder) {
            case TITLE: 
            case CENTERED_TITLE: 
            case SUBTITLE: {
                cTTextListStyle = cTSlideMasterTextStyles.getTitleStyle();
                break;
            }
            case BODY: {
                cTTextListStyle = cTSlideMasterTextStyles.getBodyStyle();
                break;
            }
            default: {
                cTTextListStyle = cTSlideMasterTextStyles.getOtherStyle();
            }
        }
        return cTTextListStyle;
    }

    @Override
    protected boolean canDraw(XSLFShape xSLFShape) {
        XSLFSimpleShape xSLFSimpleShape;
        CTPlaceholder cTPlaceholder;
        return !(xSLFShape instanceof XSLFSimpleShape) || (cTPlaceholder = (xSLFSimpleShape = (XSLFSimpleShape)xSLFShape).getCTPlaceholder()) == null;
    }

    @Override
    public XSLFBackground getBackground() {
        CTBackground cTBackground = this._slide.getCSld().getBg();
        if (cTBackground != null) {
            return new XSLFBackground(cTBackground, (XSLFSheet)this);
        }
        return null;
    }
}

