/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.sl.usermodel.MasterSheet;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xslf.usermodel.Placeholder;
import ai2.org.apache.poi.xslf.usermodel.SlideLayout;
import ai2.org.apache.poi.xslf.usermodel.XSLFBackground;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlide;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideLayout;
import org.openxmlformats.schemas.presentationml.x2006.main.SldLayoutDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFSlideLayout
extends XSLFSheet
implements MasterSheet<XSLFShape, XSLFTextParagraph> {
    private CTSlideLayout _layout;
    private XSLFSlideMaster _master;

    XSLFSlideLayout() {
        this._layout = CTSlideLayout.Factory.newInstance();
    }

    public XSLFSlideLayout(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, XmlException {
        super(packagePart, packageRelationship);
        SldLayoutDocument sldLayoutDocument = SldLayoutDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._layout = sldLayoutDocument.getSldLayout();
        this.setCommonSlideData(this._layout.getCSld());
    }

    public String getName() {
        return this._layout.getCSld().getName();
    }

    @Internal
    public CTSlideLayout getXmlObject() {
        return this._layout;
    }

    @Override
    protected String getRootElementName() {
        return "sldLayout";
    }

    public XSLFSlideMaster getSlideMaster() {
        if (this._master == null) {
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                if (!(pOIXMLDocumentPart instanceof XSLFSlideMaster)) continue;
                this._master = (XSLFSlideMaster)pOIXMLDocumentPart;
            }
        }
        if (this._master == null) {
            throw new IllegalStateException("SlideMaster was not found for " + this.toString());
        }
        return this._master;
    }

    public XSLFSlideMaster getMasterSheet() {
        return this.getSlideMaster();
    }

    @Override
    public XSLFTheme getTheme() {
        return this.getSlideMaster().getTheme();
    }

    @Override
    public boolean getFollowMasterGraphics() {
        return !this._layout.isSetShowMasterSp() || this._layout.getShowMasterSp();
    }

    @Override
    protected boolean canDraw(XSLFShape xSLFShape) {
        XSLFSimpleShape xSLFSimpleShape;
        CTPlaceholder cTPlaceholder;
        return !(xSLFShape instanceof XSLFSimpleShape) || (cTPlaceholder = (xSLFSimpleShape = (XSLFSimpleShape)xSLFShape).getCTPlaceholder()) == null;
    }

    @Override
    public XSLFBackground getBackground() {
        CTBackground cTBackground = this._layout.getCSld().getBg();
        if (cTBackground != null) {
            return new XSLFBackground(cTBackground, (XSLFSheet)this);
        }
        return this.getMasterSheet().getBackground();
    }

    public void copyLayout(XSLFSlide xSLFSlide) {
        block3: for (XSLFShape xSLFShape : this.getShapes()) {
            XSLFTextShape xSLFTextShape;
            Placeholder placeholder;
            if (!(xSLFShape instanceof XSLFTextShape) || (placeholder = (xSLFTextShape = (XSLFTextShape)xSLFShape).getTextType()) == null) continue;
            switch (placeholder) {
                case DATETIME: 
                case SLIDE_NUMBER: 
                case FOOTER: {
                    continue block3;
                }
            }
            xSLFSlide.getSpTree().addNewSp().set(xSLFTextShape.getXmlObject().copy());
        }
    }

    public SlideLayout getType() {
        int n = this._layout.getType().intValue() - 1;
        return SlideLayout.values()[n];
    }
}

