/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawSlide;
import ai2.org.apache.poi.sl.usermodel.Notes;
import ai2.org.apache.poi.sl.usermodel.Slide;
import ai2.org.apache.poi.xslf.usermodel.Placeholder;
import ai2.org.apache.poi.xslf.usermodel.XSLFBackground;
import ai2.org.apache.poi.xslf.usermodel.XSLFComments;
import ai2.org.apache.poi.xslf.usermodel.XSLFNotes;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShapeNonVisual;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.SldDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSLFSlide
extends XSLFSheet
implements Slide<XSLFShape, XSLFTextParagraph> {
    private final CTSlide _slide;
    private XSLFSlideLayout _layout;
    private XSLFComments _comments;
    private XSLFNotes _notes;

    XSLFSlide() {
        this._slide = XSLFSlide.prototype();
        this.setCommonSlideData(this._slide.getCSld());
    }

    XSLFSlide(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, XmlException {
        super(packagePart, packageRelationship);
        SldDocument sldDocument = SldDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._slide = sldDocument.getSld();
        this.setCommonSlideData(this._slide.getCSld());
    }

    private static CTSlide prototype() {
        CTSlide cTSlide = CTSlide.Factory.newInstance();
        CTCommonSlideData cTCommonSlideData = cTSlide.addNewCSld();
        CTGroupShape cTGroupShape = cTCommonSlideData.addNewSpTree();
        CTGroupShapeNonVisual cTGroupShapeNonVisual = cTGroupShape.addNewNvGrpSpPr();
        CTNonVisualDrawingProps cTNonVisualDrawingProps = cTGroupShapeNonVisual.addNewCNvPr();
        cTNonVisualDrawingProps.setId(1L);
        cTNonVisualDrawingProps.setName("");
        cTGroupShapeNonVisual.addNewCNvGrpSpPr();
        cTGroupShapeNonVisual.addNewNvPr();
        CTGroupShapeProperties cTGroupShapeProperties = cTGroupShape.addNewGrpSpPr();
        CTGroupTransform2D cTGroupTransform2D = cTGroupShapeProperties.addNewXfrm();
        CTPoint2D cTPoint2D = cTGroupTransform2D.addNewOff();
        cTPoint2D.setX(0L);
        cTPoint2D.setY(0L);
        CTPositiveSize2D cTPositiveSize2D = cTGroupTransform2D.addNewExt();
        cTPositiveSize2D.setCx(0L);
        cTPositiveSize2D.setCy(0L);
        CTPoint2D cTPoint2D2 = cTGroupTransform2D.addNewChOff();
        cTPoint2D2.setX(0L);
        cTPoint2D2.setY(0L);
        CTPositiveSize2D cTPositiveSize2D2 = cTGroupTransform2D.addNewChExt();
        cTPositiveSize2D2.setCx(0L);
        cTPositiveSize2D2.setCy(0L);
        cTSlide.addNewClrMapOvr().addNewMasterClrMapping();
        return cTSlide;
    }

    public CTSlide getXmlObject() {
        return this._slide;
    }

    @Override
    protected String getRootElementName() {
        return "sld";
    }

    public XSLFSlideLayout getMasterSheet() {
        return this.getSlideLayout();
    }

    public XSLFSlideLayout getSlideLayout() {
        if (this._layout == null) {
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                if (!(pOIXMLDocumentPart instanceof XSLFSlideLayout)) continue;
                this._layout = (XSLFSlideLayout)pOIXMLDocumentPart;
            }
        }
        if (this._layout == null) {
            throw new IllegalArgumentException("SlideLayout was not found for " + this.toString());
        }
        return this._layout;
    }

    public XSLFSlideMaster getSlideMaster() {
        return this.getSlideLayout().getSlideMaster();
    }

    public XSLFComments getComments() {
        if (this._comments == null) {
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                if (!(pOIXMLDocumentPart instanceof XSLFComments)) continue;
                this._comments = (XSLFComments)pOIXMLDocumentPart;
            }
        }
        if (this._comments == null) {
            return null;
        }
        return this._comments;
    }

    public XSLFNotes getNotes() {
        if (this._notes == null) {
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                if (!(pOIXMLDocumentPart instanceof XSLFNotes)) continue;
                this._notes = (XSLFNotes)pOIXMLDocumentPart;
            }
        }
        if (this._notes == null) {
            return null;
        }
        return this._notes;
    }

    @Override
    public String getTitle() {
        XSLFTextShape xSLFTextShape = this.getTextShapeByType(Placeholder.TITLE);
        return xSLFTextShape == null ? null : xSLFTextShape.getText();
    }

    @Override
    public XSLFTheme getTheme() {
        return this.getSlideLayout().getSlideMaster().getTheme();
    }

    @Override
    public XSLFBackground getBackground() {
        CTBackground cTBackground = this._slide.getCSld().getBg();
        if (cTBackground != null) {
            return new XSLFBackground(cTBackground, (XSLFSheet)this);
        }
        return this.getMasterSheet().getBackground();
    }

    @Override
    public boolean getFollowMasterGraphics() {
        return !this._slide.isSetShowMasterSp() || this._slide.getShowMasterSp();
    }

    public void setFollowMasterGraphics(boolean bl) {
        this._slide.setShowMasterSp(bl);
    }

    @Override
    public boolean getFollowMasterObjects() {
        return this.getFollowMasterGraphics();
    }

    @Override
    public void setFollowMasterObjects(boolean bl) {
        this.setFollowMasterGraphics(bl);
    }

    @Override
    public XSLFSlide importContent(XSLFSheet xSLFSheet) {
        CTBackground cTBackground;
        super.importContent(xSLFSheet);
        XSLFBackground xSLFBackground = this.getBackground();
        if (xSLFBackground != null && (cTBackground = (CTBackground)xSLFBackground.getXmlObject()).isSetBgPr() && cTBackground.getBgPr().isSetBlipFill()) {
            CTBlip cTBlip = cTBackground.getBgPr().getBlipFill().getBlip();
            String string = cTBlip.getEmbed();
            String string2 = this.importBlip(string, xSLFSheet.getPackagePart());
            cTBlip.setEmbed(string2);
        }
        return this;
    }

    @Override
    public boolean getFollowMasterBackground() {
        return false;
    }

    @Override
    public void setFollowMasterBackground(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getFollowMasterColourScheme() {
        return false;
    }

    @Override
    public void setFollowMasterColourScheme(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNotes(Notes<XSLFShape, XSLFTextParagraph> notes) {
        assert (notes instanceof XSLFNotes);
    }

    @Override
    public int getSlideNumber() {
        int n = this.getSlideShow().getSlides().indexOf(this);
        return n == -1 ? n : n + 1;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        DrawFactory drawFactory = DrawFactory.getInstance(graphics2D);
        DrawSlide drawSlide = drawFactory.getDrawable(this);
        drawSlide.draw(graphics2D);
    }
}

