/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawPictureShape;
import ai2.org.apache.poi.sl.draw.DrawSheet;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.sl.usermodel.Sheet;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xslf.usermodel.Placeholder;
import ai2.org.apache.poi.xslf.usermodel.XMLSlideShow;
import ai2.org.apache.poi.xslf.usermodel.XSLFAutoShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFBackground;
import ai2.org.apache.poi.xslf.usermodel.XSLFCommonSlideData;
import ai2.org.apache.poi.xslf.usermodel.XSLFConnectorShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFDrawing;
import ai2.org.apache.poi.xslf.usermodel.XSLFFreeformShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFGraphicFrame;
import ai2.org.apache.poi.xslf.usermodel.XSLFGroupShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFPictureData;
import ai2.org.apache.poi.xslf.usermodel.XSLFPictureShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFRelation;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFShapeContainer;
import ai2.org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTable;
import ai2.org.apache.poi.xslf.usermodel.XSLFTableRow;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextBox;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTConnector;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSLFSheet
extends POIXMLDocumentPart
implements XSLFShapeContainer,
Sheet<XSLFShape, XSLFTextParagraph> {
    private XSLFCommonSlideData _commonSlideData;
    private XSLFDrawing _drawing;
    private List<XSLFShape> _shapes;
    private CTGroupShape _spTree;
    private List<XSLFTextShape> _placeholders;
    private Map<Integer, XSLFSimpleShape> _placeholderByIdMap;
    private Map<Integer, XSLFSimpleShape> _placeholderByTypeMap;

    public XSLFSheet() {
    }

    public XSLFSheet(PackagePart packagePart, PackageRelationship packageRelationship) {
        super(packagePart, packageRelationship);
    }

    public XMLSlideShow getSlideShow() {
        for (POIXMLDocumentPart pOIXMLDocumentPart = this.getParent(); pOIXMLDocumentPart != null; pOIXMLDocumentPart = pOIXMLDocumentPart.getParent()) {
            if (!(pOIXMLDocumentPart instanceof XMLSlideShow)) continue;
            return (XMLSlideShow)pOIXMLDocumentPart;
        }
        throw new IllegalStateException("SlideShow was not found");
    }

    protected List<XSLFShape> buildShapes(CTGroupShape cTGroupShape) {
        ArrayList<XSLFShape> arrayList = new ArrayList<XSLFShape>();
        for (XmlObject xmlObject : cTGroupShape.selectPath("*")) {
            XSLFShape xSLFShape;
            if (xmlObject instanceof CTShape) {
                xSLFShape = XSLFAutoShape.create((CTShape)xmlObject, this);
                arrayList.add(xSLFShape);
                continue;
            }
            if (xmlObject instanceof CTGroupShape) {
                arrayList.add(new XSLFGroupShape((CTGroupShape)xmlObject, this));
                continue;
            }
            if (xmlObject instanceof CTConnector) {
                arrayList.add(new XSLFConnectorShape((CTConnector)xmlObject, this));
                continue;
            }
            if (xmlObject instanceof CTPicture) {
                arrayList.add(new XSLFPictureShape((CTPicture)xmlObject, this));
                continue;
            }
            if (!(xmlObject instanceof CTGraphicalObjectFrame)) continue;
            xSLFShape = XSLFGraphicFrame.create((CTGraphicalObjectFrame)xmlObject, this);
            arrayList.add(xSLFShape);
        }
        return arrayList;
    }

    public abstract XmlObject getXmlObject();

    @Internal
    public XSLFCommonSlideData getCommonSlideData() {
        return this._commonSlideData;
    }

    protected void setCommonSlideData(CTCommonSlideData cTCommonSlideData) {
        this._commonSlideData = cTCommonSlideData == null ? null : new XSLFCommonSlideData(cTCommonSlideData);
    }

    private XSLFDrawing getDrawing() {
        this.initDrawingAndShapes();
        return this._drawing;
    }

    @Override
    public List<XSLFShape> getShapes() {
        this.initDrawingAndShapes();
        return this._shapes;
    }

    private void initDrawingAndShapes() {
        CTGroupShape cTGroupShape = this.getSpTree();
        if (this._drawing == null) {
            this._drawing = new XSLFDrawing(this, cTGroupShape);
        }
        if (this._shapes == null) {
            this._shapes = this.buildShapes(cTGroupShape);
        }
    }

    @Override
    public XSLFAutoShape createAutoShape() {
        XSLFAutoShape xSLFAutoShape = this.getDrawing().createAutoShape();
        this.getShapes().add(xSLFAutoShape);
        xSLFAutoShape.setParent(this);
        return xSLFAutoShape;
    }

    @Override
    public XSLFFreeformShape createFreeform() {
        XSLFFreeformShape xSLFFreeformShape = this.getDrawing().createFreeform();
        this.getShapes().add(xSLFFreeformShape);
        xSLFFreeformShape.setParent(this);
        return xSLFFreeformShape;
    }

    @Override
    public XSLFTextBox createTextBox() {
        XSLFTextBox xSLFTextBox = this.getDrawing().createTextBox();
        this.getShapes().add(xSLFTextBox);
        xSLFTextBox.setParent(this);
        return xSLFTextBox;
    }

    @Override
    public XSLFConnectorShape createConnector() {
        XSLFConnectorShape xSLFConnectorShape = this.getDrawing().createConnector();
        this.getShapes().add(xSLFConnectorShape);
        xSLFConnectorShape.setParent(this);
        return xSLFConnectorShape;
    }

    @Override
    public XSLFGroupShape createGroup() {
        XSLFGroupShape xSLFGroupShape = this.getDrawing().createGroup();
        this.getShapes().add(xSLFGroupShape);
        xSLFGroupShape.setParent(this);
        return xSLFGroupShape;
    }

    @Override
    public XSLFPictureShape createPicture(PictureData pictureData) {
        if (!(pictureData instanceof XSLFPictureData)) {
            throw new IllegalArgumentException("pictureData needs to be of type XSLFPictureData");
        }
        XSLFPictureData xSLFPictureData = (XSLFPictureData)pictureData;
        PackagePart packagePart = xSLFPictureData.getPackagePart();
        PackageRelationship packageRelationship = this.getPackagePart().addRelationship(packagePart.getPartName(), TargetMode.INTERNAL, XSLFRelation.IMAGES.getRelation());
        this.addRelation(packageRelationship.getId(), new XSLFPictureData(packagePart, packageRelationship));
        XSLFPictureShape xSLFPictureShape = this.getDrawing().createPicture(packageRelationship.getId());
        new DrawPictureShape(xSLFPictureShape).resize();
        this.getShapes().add(xSLFPictureShape);
        xSLFPictureShape.setParent(this);
        return xSLFPictureShape;
    }

    public XSLFTable createTable() {
        XSLFTable xSLFTable = this.getDrawing().createTable();
        this.getShapes().add(xSLFTable);
        xSLFTable.setParent(this);
        return xSLFTable;
    }

    public XSLFTable createTable(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("numRows and numCols must be greater than 0");
        }
        XSLFTable xSLFTable = this.getDrawing().createTable();
        this.getShapes().add(xSLFTable);
        xSLFTable.setParent(this);
        for (int i = 0; i < n; ++i) {
            XSLFTableRow xSLFTableRow = xSLFTable.addRow();
            for (int j = 0; j < n2; ++j) {
                xSLFTableRow.addCell();
            }
        }
        return xSLFTable;
    }

    @Override
    public Iterator<XSLFShape> iterator() {
        return this.getShapes().iterator();
    }

    @Override
    public void addShape(XSLFShape xSLFShape) {
        throw new UnsupportedOperationException("Adding a shape from a different container is not supported - create it from scratch witht XSLFSheet.create* methods");
    }

    @Override
    public boolean removeShape(XSLFShape xSLFShape) {
        XmlObject xmlObject = xSLFShape.getXmlObject();
        CTGroupShape cTGroupShape = this.getSpTree();
        if (xmlObject instanceof CTShape) {
            cTGroupShape.getSpList().remove(xmlObject);
        } else if (xmlObject instanceof CTGroupShape) {
            cTGroupShape.getGrpSpList().remove(xmlObject);
        } else if (xmlObject instanceof CTConnector) {
            cTGroupShape.getCxnSpList().remove(xmlObject);
        } else {
            throw new IllegalArgumentException("Unsupported shape: " + xSLFShape);
        }
        return this.getShapes().remove(xSLFShape);
    }

    @Override
    public void clear() {
        ArrayList<XSLFShape> arrayList = new ArrayList<XSLFShape>(this.getShapes());
        for (XSLFShape xSLFShape : arrayList) {
            this.removeShape(xSLFShape);
        }
    }

    protected abstract String getRootElementName();

    protected CTGroupShape getSpTree() {
        if (this._spTree == null) {
            XmlObject xmlObject = this.getXmlObject();
            XmlObject[] xmlObjectArray = xmlObject.selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:spTree");
            if (xmlObjectArray.length == 0) {
                throw new IllegalStateException("CTGroupShape was not found");
            }
            this._spTree = (CTGroupShape)xmlObjectArray[0];
        }
        return this._spTree;
    }

    @Override
    protected final void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        hashMap.put("http://schemas.openxmlformats.org/drawingml/2006/main", "a");
        hashMap.put("http://schemas.openxmlformats.org/presentationml/2006/main", "p");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        String string = this.getRootElementName();
        if (string != null) {
            xmlOptions.setSaveSyntheticDocumentElement(new QName("http://schemas.openxmlformats.org/presentationml/2006/main", string));
        }
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.getXmlObject().save(outputStream, xmlOptions);
        outputStream.close();
    }

    public XSLFSheet importContent(XSLFSheet xSLFSheet) {
        this._shapes = null;
        this._spTree = null;
        this._drawing = null;
        this._spTree = null;
        this._placeholders = null;
        this.getSpTree().set((XmlObject)xSLFSheet.getSpTree());
        List<XSLFShape> list = this.getShapes();
        List<XSLFShape> list2 = xSLFSheet.getShapes();
        for (int i = 0; i < list.size(); ++i) {
            XSLFShape xSLFShape = list2.get(i);
            XSLFShape xSLFShape2 = list.get(i);
            xSLFShape2.copy(xSLFShape);
        }
        return this;
    }

    public XSLFSheet appendContent(XSLFSheet xSLFSheet) {
        CTGroupShape cTGroupShape = this.getSpTree();
        int n = this.getShapes().size();
        CTGroupShape cTGroupShape2 = xSLFSheet.getSpTree();
        for (Object object : cTGroupShape2.selectPath("*")) {
            if (object instanceof CTShape) {
                cTGroupShape.addNewSp().set(object);
                continue;
            }
            if (object instanceof CTGroupShape) {
                cTGroupShape.addNewGrpSp().set(object);
                continue;
            }
            if (object instanceof CTConnector) {
                cTGroupShape.addNewCxnSp().set(object);
                continue;
            }
            if (object instanceof CTPicture) {
                cTGroupShape.addNewPic().set(object);
                continue;
            }
            if (!(object instanceof CTGraphicalObjectFrame)) continue;
            cTGroupShape.addNewGraphicFrame().set(object);
        }
        this._shapes = null;
        this._spTree = null;
        this._drawing = null;
        this._spTree = null;
        this._placeholders = null;
        List<XSLFShape> list = this.getShapes();
        List<XSLFShape> list2 = xSLFSheet.getShapes();
        for (int i = 0; i < list2.size(); ++i) {
            Object object;
            object = list2.get(i);
            XSLFShape xSLFShape = (XSLFShape)list.get(n + i);
            xSLFShape.copy((XSLFShape)object);
        }
        return this;
    }

    XSLFTheme getTheme() {
        return null;
    }

    protected XSLFTextShape getTextShapeByType(Placeholder placeholder) {
        for (XSLFShape xSLFShape : this.getShapes()) {
            XSLFTextShape xSLFTextShape;
            if (!(xSLFShape instanceof XSLFTextShape) || (xSLFTextShape = (XSLFTextShape)xSLFShape).getTextType() != placeholder) continue;
            return xSLFTextShape;
        }
        return null;
    }

    XSLFSimpleShape getPlaceholder(CTPlaceholder cTPlaceholder) {
        XSLFSimpleShape xSLFSimpleShape = null;
        if (cTPlaceholder.isSetIdx()) {
            xSLFSimpleShape = this.getPlaceholderById((int)cTPlaceholder.getIdx());
        }
        if (xSLFSimpleShape == null && cTPlaceholder.isSetType()) {
            xSLFSimpleShape = this.getPlaceholderByType(cTPlaceholder.getType().intValue());
        }
        return xSLFSimpleShape;
    }

    void initPlaceholders() {
        if (this._placeholders == null) {
            this._placeholders = new ArrayList<XSLFTextShape>();
            this._placeholderByIdMap = new HashMap<Integer, XSLFSimpleShape>();
            this._placeholderByTypeMap = new HashMap<Integer, XSLFSimpleShape>();
            for (XSLFShape xSLFShape : this.getShapes()) {
                XSLFTextShape xSLFTextShape;
                CTPlaceholder cTPlaceholder;
                if (!(xSLFShape instanceof XSLFTextShape) || (cTPlaceholder = (xSLFTextShape = (XSLFTextShape)xSLFShape).getCTPlaceholder()) == null) continue;
                this._placeholders.add(xSLFTextShape);
                if (cTPlaceholder.isSetIdx()) {
                    int n = (int)cTPlaceholder.getIdx();
                    this._placeholderByIdMap.put(n, xSLFTextShape);
                }
                if (!cTPlaceholder.isSetType()) continue;
                this._placeholderByTypeMap.put(cTPlaceholder.getType().intValue(), xSLFTextShape);
            }
        }
    }

    XSLFSimpleShape getPlaceholderById(int n) {
        this.initPlaceholders();
        return this._placeholderByIdMap.get(n);
    }

    XSLFSimpleShape getPlaceholderByType(int n) {
        this.initPlaceholders();
        return this._placeholderByTypeMap.get(n);
    }

    public XSLFTextShape getPlaceholder(int n) {
        this.initPlaceholders();
        return this._placeholders.get(n);
    }

    public XSLFTextShape[] getPlaceholders() {
        this.initPlaceholders();
        return this._placeholders.toArray(new XSLFTextShape[this._placeholders.size()]);
    }

    protected boolean canDraw(XSLFShape xSLFShape) {
        return true;
    }

    @Override
    public boolean getFollowMasterGraphics() {
        return false;
    }

    public XSLFBackground getBackground() {
        return null;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        DrawFactory drawFactory = DrawFactory.getInstance(graphics2D);
        DrawSheet drawSheet = drawFactory.getDrawable(this);
        drawSheet.draw(graphics2D);
    }

    String importBlip(String string, PackagePart packagePart) {
        PackagePart packagePart2;
        PackageRelationship packageRelationship = packagePart.getRelationship(string);
        try {
            packagePart2 = packagePart.getRelatedPart(packageRelationship);
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new POIXMLException(invalidFormatException);
        }
        XSLFPictureData xSLFPictureData = new XSLFPictureData(packagePart2, null);
        XMLSlideShow xMLSlideShow = this.getSlideShow();
        XSLFPictureData xSLFPictureData2 = xMLSlideShow.addPicture(xSLFPictureData.getData(), xSLFPictureData.getType());
        PackagePart packagePart3 = xSLFPictureData2.getPackagePart();
        PackageRelationship packageRelationship2 = this.getPackagePart().addRelationship(packagePart3.getPartName(), TargetMode.INTERNAL, packageRelationship.getRelationshipType());
        this.addRelation(packageRelationship2.getId(), new XSLFPictureData(packagePart3, packageRelationship2));
        return packageRelationship2.getId();
    }

    PackagePart importPart(PackageRelationship packageRelationship, PackagePart packagePart) {
        PackagePart packagePart2 = this.getPackagePart();
        PackagePartName packagePartName = packagePart.getPartName();
        OPCPackage oPCPackage = packagePart2.getPackage();
        if (oPCPackage.containPart(packagePartName)) {
            return oPCPackage.getPart(packagePartName);
        }
        packagePart2.addRelationship(packagePartName, TargetMode.INTERNAL, packageRelationship.getRelationshipType());
        PackagePart packagePart3 = oPCPackage.createPart(packagePartName, packagePart.getContentType());
        try {
            OutputStream outputStream = packagePart3.getOutputStream();
            InputStream inputStream = packagePart.getInputStream();
            IOUtils.copy(inputStream, outputStream);
            inputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new POIXMLException(iOException);
        }
        return packagePart3;
    }
}

