/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.Shadow;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.usermodel.XSLFColor;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.awt.Color;
import java.awt.Rectangle;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOuterShadowEffect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFShadow
extends XSLFShape
implements Shadow<XSLFShape, XSLFTextParagraph> {
    private XSLFSimpleShape _parent;

    XSLFShadow(CTOuterShadowEffect cTOuterShadowEffect, XSLFSimpleShape xSLFSimpleShape) {
        super((XmlObject)cTOuterShadowEffect, xSLFSimpleShape.getSheet());
        this._parent = xSLFSimpleShape;
    }

    public XSLFSimpleShape getShadowParent() {
        return this._parent;
    }

    @Override
    public Rectangle getAnchor() {
        return this._parent.getAnchor();
    }

    public void setAnchor(Rectangle rectangle) {
        throw new IllegalStateException("You can't set anchor of a shadow");
    }

    @Override
    public double getDistance() {
        CTOuterShadowEffect cTOuterShadowEffect = (CTOuterShadowEffect)this.getXmlObject();
        return cTOuterShadowEffect.isSetDist() ? Units.toPoints(cTOuterShadowEffect.getDist()) : 0.0;
    }

    @Override
    public double getAngle() {
        CTOuterShadowEffect cTOuterShadowEffect = (CTOuterShadowEffect)this.getXmlObject();
        return cTOuterShadowEffect.isSetDir() ? (double)cTOuterShadowEffect.getDir() / 60000.0 : 0.0;
    }

    @Override
    public double getBlur() {
        CTOuterShadowEffect cTOuterShadowEffect = (CTOuterShadowEffect)this.getXmlObject();
        return cTOuterShadowEffect.isSetBlurRad() ? Units.toPoints(cTOuterShadowEffect.getBlurRad()) : 0.0;
    }

    public Color getFillColor() {
        PaintStyle.SolidPaint solidPaint = this.getFillStyle();
        if (solidPaint == null) {
            return null;
        }
        Color color = DrawPaint.applyColorTransform(solidPaint.getSolidColor());
        return color;
    }

    @Override
    public PaintStyle.SolidPaint getFillStyle() {
        XSLFTheme xSLFTheme = this.getSheet().getTheme();
        CTOuterShadowEffect cTOuterShadowEffect = (CTOuterShadowEffect)this.getXmlObject();
        if (cTOuterShadowEffect == null) {
            return null;
        }
        CTSchemeColor cTSchemeColor = cTOuterShadowEffect.getSchemeClr();
        XSLFColor xSLFColor = new XSLFColor((XmlObject)cTOuterShadowEffect, xSLFTheme, cTSchemeColor);
        return DrawPaint.createSolidPaint(xSLFColor.getColorStyle());
    }
}

