/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.hslf.blip.EMF;
import ai2.org.apache.poi.hslf.blip.PICT;
import ai2.org.apache.poi.hslf.blip.WMF;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.usermodel.XSLFRelation;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public final class XSLFPictureData
extends POIXMLDocumentPart
implements PictureData {
    private static final POILogger logger = POILogFactory.getLogger(XSLFPictureData.class);
    private Long checksum = null;
    private Dimension _origSize = null;
    private int index = -1;

    protected XSLFPictureData() {
    }

    public XSLFPictureData(PackagePart packagePart, PackageRelationship packageRelationship) {
        super(packagePart, packageRelationship);
    }

    public InputStream getInputStream() throws IOException {
        return this.getPackagePart().getInputStream();
    }

    public byte[] getData() {
        try {
            return IOUtils.toByteArray(this.getInputStream());
        }
        catch (IOException iOException) {
            throw new POIXMLException(iOException);
        }
    }

    public String getFileName() {
        String string = this.getPackagePart().getPartName().getName();
        if (string == null) {
            return null;
        }
        return string.substring(string.lastIndexOf(47) + 1);
    }

    public String suggestFileExtension() {
        return this.getPackagePart().getPartName().getExtension();
    }

    public byte[] getChecksum() {
        this.cacheProperties();
        byte[] byArray = new byte[8];
        LittleEndian.putLong(byArray, 0, this.checksum);
        return byArray;
    }

    public Dimension getImageDimension() {
        this.cacheProperties();
        return this._origSize;
    }

    public Dimension getImageDimensionInPixels() {
        Dimension dimension = this.getImageDimension();
        return new Dimension(Units.pointsToPixel(dimension.getWidth()), Units.pointsToPixel(dimension.getHeight()));
    }

    protected void cacheProperties() {
        if (this._origSize == null || this.checksum == null) {
            byte[] byArray = this.getData();
            this.checksum = IOUtils.calculateChecksum(byArray);
            switch (this.getType()) {
                case EMF: {
                    this._origSize = new EMF.NativeHeader(byArray, 0).getSize();
                    break;
                }
                case WMF: {
                    this._origSize = new WMF.NativeHeader(byArray, 0).getSize();
                    break;
                }
                case PICT: {
                    this._origSize = new PICT.NativeHeader(byArray, 0).getSize();
                    break;
                }
                default: {
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                    }
                    catch (IOException iOException) {
                        logger.log(5, new Object[]{"Can't determine image dimensions", iOException});
                    }
                    this._origSize = bufferedImage == null ? new Dimension(200, 200) : new Dimension((int)Units.pixelToPoints(bufferedImage.getWidth()), (int)Units.pixelToPoints(bufferedImage.getHeight()));
                }
            }
        }
    }

    protected void prepareForCommit() {
    }

    public String getContentType() {
        return this.getPackagePart().getContentType();
    }

    public void setData(byte[] byArray) throws IOException {
        OutputStream outputStream = this.getPackagePart().getOutputStream();
        outputStream.write(byArray);
        outputStream.close();
        this.checksum = IOUtils.calculateChecksum(byArray);
        this._origSize = null;
    }

    public PictureData.PictureType getType() {
        String string = this.getContentType();
        if (XSLFRelation.IMAGE_EMF.getContentType().equals(string)) {
            return PictureData.PictureType.EMF;
        }
        if (XSLFRelation.IMAGE_WMF.getContentType().equals(string)) {
            return PictureData.PictureType.WMF;
        }
        if (XSLFRelation.IMAGE_PICT.getContentType().equals(string)) {
            return PictureData.PictureType.PICT;
        }
        if (XSLFRelation.IMAGE_JPEG.getContentType().equals(string)) {
            return PictureData.PictureType.JPEG;
        }
        if (XSLFRelation.IMAGE_PNG.getContentType().equals(string)) {
            return PictureData.PictureType.PNG;
        }
        if (XSLFRelation.IMAGE_DIB.getContentType().equals(string)) {
            return PictureData.PictureType.DIB;
        }
        if (XSLFRelation.IMAGE_GIF.getContentType().equals(string)) {
            return PictureData.PictureType.GIF;
        }
        if (XSLFRelation.IMAGE_EPS.getContentType().equals(string)) {
            return PictureData.PictureType.EPS;
        }
        if (XSLFRelation.IMAGE_BMP.getContentType().equals(string)) {
            return PictureData.PictureType.BMP;
        }
        if (XSLFRelation.IMAGE_WPG.getContentType().equals(string)) {
            return PictureData.PictureType.WPG;
        }
        if (XSLFRelation.IMAGE_WDP.getContentType().equals(string)) {
            return PictureData.PictureType.WDP;
        }
        return null;
    }

    static XSLFRelation getRelationForType(PictureData.PictureType pictureType) {
        switch (pictureType) {
            case EMF: {
                return XSLFRelation.IMAGE_EMF;
            }
            case WMF: {
                return XSLFRelation.IMAGE_WMF;
            }
            case PICT: {
                return XSLFRelation.IMAGE_PICT;
            }
            case JPEG: {
                return XSLFRelation.IMAGE_JPEG;
            }
            case PNG: {
                return XSLFRelation.IMAGE_PNG;
            }
            case DIB: {
                return XSLFRelation.IMAGE_DIB;
            }
            case GIF: {
                return XSLFRelation.IMAGE_GIF;
            }
            case EPS: {
                return XSLFRelation.IMAGE_EPS;
            }
            case BMP: {
                return XSLFRelation.IMAGE_BMP;
            }
            case WPG: {
                return XSLFRelation.IMAGE_WPG;
            }
            case WDP: {
                return XSLFRelation.IMAGE_WDP;
            }
        }
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }
}

