/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.sl.usermodel.MasterSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorMapping;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesMaster;
import org.openxmlformats.schemas.presentationml.x2006.main.NotesMasterDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFNotesMaster
extends XSLFSheet
implements MasterSheet<XSLFShape, XSLFTextParagraph> {
    private CTNotesMaster _slide;
    private XSLFTheme _theme;

    XSLFNotesMaster() {
        this._slide = XSLFNotesMaster.prototype();
    }

    protected XSLFNotesMaster(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, XmlException {
        super(packagePart, packageRelationship);
        NotesMasterDocument notesMasterDocument = NotesMasterDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._slide = notesMasterDocument.getNotesMaster();
        this.setCommonSlideData(this._slide.getCSld());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CTNotesMaster prototype() {
        CTNotesMaster cTNotesMaster;
        InputStream inputStream = XSLFNotesMaster.class.getResourceAsStream("notesMaster.xml");
        if (inputStream == null) {
            throw new POIXMLException("Missing resource 'notesMaster.xml'");
        }
        try {
            CTNotesMaster cTNotesMaster2;
            NotesMasterDocument notesMasterDocument = NotesMasterDocument.Factory.parse((InputStream)inputStream);
            cTNotesMaster = cTNotesMaster2 = notesMasterDocument.getNotesMaster();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw new POIXMLException("Can't initialize NotesMaster", exception);
            }
        }
        inputStream.close();
        return cTNotesMaster;
    }

    public CTNotesMaster getXmlObject() {
        return this._slide;
    }

    @Override
    protected String getRootElementName() {
        return "notesMaster";
    }

    @Override
    public MasterSheet<XSLFShape, XSLFTextParagraph> getMasterSheet() {
        return null;
    }

    @Override
    public XSLFTheme getTheme() {
        if (this._theme == null) {
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                if (!(pOIXMLDocumentPart instanceof XSLFTheme)) continue;
                this._theme = (XSLFTheme)pOIXMLDocumentPart;
                CTColorMapping cTColorMapping = this._slide.getClrMap();
                if (cTColorMapping == null) break;
                this._theme.initColorMap(cTColorMapping);
                break;
            }
        }
        return this._theme;
    }
}

