/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.sl.usermodel.Notes;
import ai2.org.apache.poi.xslf.usermodel.XSLFNotesMaster;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.NotesDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSLFNotes
extends XSLFSheet
implements Notes<XSLFShape, XSLFTextParagraph> {
    private CTNotesSlide _notes;

    XSLFNotes() {
        this._notes = XSLFNotes.prototype();
        this.setCommonSlideData(this._notes.getCSld());
    }

    XSLFNotes(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, XmlException {
        super(packagePart, packageRelationship);
        NotesDocument notesDocument = NotesDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._notes = notesDocument.getNotes();
        this.setCommonSlideData(this._notes.getCSld());
    }

    private static CTNotesSlide prototype() {
        CTNotesSlide cTNotesSlide = CTNotesSlide.Factory.newInstance();
        CTCommonSlideData cTCommonSlideData = cTNotesSlide.addNewCSld();
        cTCommonSlideData.addNewSpTree();
        return cTNotesSlide;
    }

    public CTNotesSlide getXmlObject() {
        return this._notes;
    }

    @Override
    protected String getRootElementName() {
        return "notes";
    }

    @Override
    public XSLFTheme getTheme() {
        return this.getMasterSheet().getTheme();
    }

    public XSLFNotesMaster getMasterSheet() {
        for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
            if (!(pOIXMLDocumentPart instanceof XSLFNotesMaster)) continue;
            return (XSLFNotesMaster)pOIXMLDocumentPart;
        }
        return null;
    }

    @Override
    public List<List<XSLFTextParagraph>> getTextParagraphs() {
        ArrayList<List<XSLFTextParagraph>> arrayList = new ArrayList<List<XSLFTextParagraph>>();
        for (XSLFShape xSLFShape : super.getShapes()) {
            if (!(xSLFShape instanceof XSLFTextShape)) continue;
            XSLFTextShape xSLFTextShape = (XSLFTextShape)xSLFShape;
            arrayList.add(xSLFTextShape.getTextParagraphs());
        }
        return arrayList;
    }
}

