/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.POIXMLFactory;
import ai2.org.apache.poi.POIXMLRelation;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xslf.usermodel.XSLFRelation;
import java.lang.reflect.Constructor;

public final class XSLFFactory
extends POIXMLFactory {
    private static final POILogger logger = POILogFactory.getLogger(XSLFFactory.class);
    private static final XSLFFactory inst = new XSLFFactory();

    private XSLFFactory() {
    }

    public static XSLFFactory getInstance() {
        return inst;
    }

    public POIXMLDocumentPart createDocumentPart(POIXMLDocumentPart pOIXMLDocumentPart, PackageRelationship packageRelationship, PackagePart packagePart) {
        XSLFRelation xSLFRelation = XSLFRelation.getInstance(packageRelationship.getRelationshipType());
        if (xSLFRelation == null || xSLFRelation.getRelationClass() == null) {
            logger.log(1, new Object[]{"using default POIXMLDocumentPart for " + packageRelationship.getRelationshipType()});
            return new POIXMLDocumentPart(packagePart, packageRelationship);
        }
        try {
            Class<? extends POIXMLDocumentPart> clazz = xSLFRelation.getRelationClass();
            Constructor<? extends POIXMLDocumentPart> constructor = clazz.getDeclaredConstructor(PackagePart.class, PackageRelationship.class);
            return constructor.newInstance(packagePart, packageRelationship);
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }

    public POIXMLDocumentPart newDocumentPart(POIXMLRelation pOIXMLRelation) {
        try {
            Class<? extends POIXMLDocumentPart> clazz = pOIXMLRelation.getRelationClass();
            Constructor<? extends POIXMLDocumentPart> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }
}

