/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.xslf.usermodel.XSLFAutoShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFConnectorShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFFreeformShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFGroupShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFPictureShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTable;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextBox;
import java.awt.Color;
import java.awt.Rectangle;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTConnector;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

public class XSLFDrawing {
    private XSLFSheet _sheet;
    private int _shapeId = 1;
    private CTGroupShape _spTree;

    XSLFDrawing(XSLFSheet xSLFSheet, CTGroupShape cTGroupShape) {
        XmlObject[] xmlObjectArray;
        this._sheet = xSLFSheet;
        this._spTree = cTGroupShape;
        for (XmlObject xmlObject : xmlObjectArray = xSLFSheet.getSpTree().selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:cNvPr")) {
            if (!(xmlObject instanceof CTNonVisualDrawingProps)) continue;
            CTNonVisualDrawingProps cTNonVisualDrawingProps = (CTNonVisualDrawingProps)xmlObject;
            this._shapeId = (int)Math.max((long)this._shapeId, cTNonVisualDrawingProps.getId());
        }
    }

    public XSLFAutoShape createAutoShape() {
        CTShape cTShape = this._spTree.addNewSp();
        cTShape.set((XmlObject)XSLFAutoShape.prototype(this._shapeId++));
        XSLFAutoShape xSLFAutoShape = new XSLFAutoShape(cTShape, this._sheet);
        xSLFAutoShape.setAnchor(new Rectangle());
        return xSLFAutoShape;
    }

    public XSLFFreeformShape createFreeform() {
        CTShape cTShape = this._spTree.addNewSp();
        cTShape.set((XmlObject)XSLFFreeformShape.prototype(this._shapeId++));
        XSLFFreeformShape xSLFFreeformShape = new XSLFFreeformShape(cTShape, this._sheet);
        xSLFFreeformShape.setAnchor(new Rectangle());
        return xSLFFreeformShape;
    }

    public XSLFTextBox createTextBox() {
        CTShape cTShape = this._spTree.addNewSp();
        cTShape.set((XmlObject)XSLFTextBox.prototype(this._shapeId++));
        XSLFTextBox xSLFTextBox = new XSLFTextBox(cTShape, this._sheet);
        xSLFTextBox.setAnchor(new Rectangle());
        return xSLFTextBox;
    }

    public XSLFConnectorShape createConnector() {
        CTConnector cTConnector = this._spTree.addNewCxnSp();
        cTConnector.set((XmlObject)XSLFConnectorShape.prototype(this._shapeId++));
        XSLFConnectorShape xSLFConnectorShape = new XSLFConnectorShape(cTConnector, this._sheet);
        xSLFConnectorShape.setAnchor(new Rectangle());
        xSLFConnectorShape.setLineColor(Color.black);
        xSLFConnectorShape.setLineWidth(0.75);
        return xSLFConnectorShape;
    }

    public XSLFGroupShape createGroup() {
        CTGroupShape cTGroupShape = this._spTree.addNewGrpSp();
        cTGroupShape.set((XmlObject)XSLFGroupShape.prototype(this._shapeId++));
        XSLFGroupShape xSLFGroupShape = new XSLFGroupShape(cTGroupShape, this._sheet);
        xSLFGroupShape.setAnchor(new Rectangle());
        return xSLFGroupShape;
    }

    public XSLFPictureShape createPicture(String string) {
        CTPicture cTPicture = this._spTree.addNewPic();
        cTPicture.set((XmlObject)XSLFPictureShape.prototype(this._shapeId++, string));
        XSLFPictureShape xSLFPictureShape = new XSLFPictureShape(cTPicture, this._sheet);
        xSLFPictureShape.setAnchor(new Rectangle());
        return xSLFPictureShape;
    }

    public XSLFTable createTable() {
        CTGraphicalObjectFrame cTGraphicalObjectFrame = this._spTree.addNewGraphicFrame();
        cTGraphicalObjectFrame.set((XmlObject)XSLFTable.prototype(this._shapeId++));
        XSLFTable xSLFTable = new XSLFTable(cTGraphicalObjectFrame, this._sheet);
        xSLFTable.setAnchor(new Rectangle());
        return xSLFTable;
    }
}

