/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.sl.usermodel.AutoShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFFreeformShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextBox;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShapeNonVisual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFAutoShape
extends XSLFTextShape
implements AutoShape<XSLFShape, XSLFTextParagraph> {
    XSLFAutoShape(CTShape cTShape, XSLFSheet xSLFSheet) {
        super((XmlObject)cTShape, xSLFSheet);
    }

    static XSLFAutoShape create(CTShape cTShape, XSLFSheet xSLFSheet) {
        if (cTShape.getSpPr().isSetCustGeom()) {
            return new XSLFFreeformShape(cTShape, xSLFSheet);
        }
        if (cTShape.getNvSpPr().getCNvSpPr().isSetTxBox()) {
            return new XSLFTextBox(cTShape, xSLFSheet);
        }
        return new XSLFAutoShape(cTShape, xSLFSheet);
    }

    static CTShape prototype(int n) {
        CTShape cTShape = CTShape.Factory.newInstance();
        CTShapeNonVisual cTShapeNonVisual = cTShape.addNewNvSpPr();
        CTNonVisualDrawingProps cTNonVisualDrawingProps = cTShapeNonVisual.addNewCNvPr();
        cTNonVisualDrawingProps.setName("AutoShape " + n);
        cTNonVisualDrawingProps.setId((long)(n + 1));
        cTShapeNonVisual.addNewCNvSpPr();
        cTShapeNonVisual.addNewNvPr();
        CTShapeProperties cTShapeProperties = cTShape.addNewSpPr();
        CTPresetGeometry2D cTPresetGeometry2D = cTShapeProperties.addNewPrstGeom();
        cTPresetGeometry2D.setPrst(STShapeType.RECT);
        cTPresetGeometry2D.addNewAvLst();
        return cTShape;
    }

    @Override
    protected CTTextBody getTextBody(boolean bl) {
        CTShape cTShape = (CTShape)this.getXmlObject();
        CTTextBody cTTextBody = cTShape.getTxBody();
        if (cTTextBody == null && bl) {
            cTTextBody = cTShape.addNewTxBody();
            cTTextBody.addNewBodyPr();
            cTTextBody.addNewLstStyle();
        }
        return cTTextBody;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] " + this.getShapeName();
    }
}

