/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.usermodel;

import ai2.org.apache.poi.POIXMLDocument;
import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.sl.usermodel.MasterSheet;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.sl.usermodel.Resources;
import ai2.org.apache.poi.sl.usermodel.SlideShow;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.PackageHelper;
import ai2.org.apache.poi.util.Units;
import ai2.org.apache.poi.xslf.XSLFSlideShow;
import ai2.org.apache.poi.xslf.usermodel.SlideLayout;
import ai2.org.apache.poi.xslf.usermodel.XSLFCommentAuthors;
import ai2.org.apache.poi.xslf.usermodel.XSLFFactory;
import ai2.org.apache.poi.xslf.usermodel.XSLFNotes;
import ai2.org.apache.poi.xslf.usermodel.XSLFNotesMaster;
import ai2.org.apache.poi.xslf.usermodel.XSLFPictureData;
import ai2.org.apache.poi.xslf.usermodel.XSLFRelation;
import ai2.org.apache.poi.xslf.usermodel.XSLFShape;
import ai2.org.apache.poi.xslf.usermodel.XSLFSheet;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlide;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import ai2.org.apache.poi.xslf.usermodel.XSLFTableStyles;
import ai2.org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import ai2.org.apache.poi.xslf.usermodel.XSLFTheme;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesMasterIdList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesMasterIdListEntry;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPresentation;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideSize;
import org.openxmlformats.schemas.presentationml.x2006.main.PresentationDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSlideShow
extends POIXMLDocument
implements SlideShow<XSLFShape, XSLFTextParagraph> {
    private static POILogger _logger = POILogFactory.getLogger(XMLSlideShow.class);
    private CTPresentation _presentation;
    private List<XSLFSlide> _slides;
    private List<XSLFSlideMaster> _masters;
    private List<XSLFPictureData> _pictures;
    private XSLFTableStyles _tableStyles;
    private XSLFNotesMaster _notesMaster;
    private XSLFCommentAuthors _commentAuthors;

    public XMLSlideShow() {
        this(XMLSlideShow.empty());
    }

    public XMLSlideShow(OPCPackage oPCPackage) {
        super(oPCPackage);
        try {
            if (this.getCorePart().getContentType().equals(XSLFRelation.THEME_MANAGER.getContentType())) {
                this.rebase(this.getPackage());
            }
            this.load(XSLFFactory.getInstance());
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }

    public XMLSlideShow(InputStream inputStream) throws IOException {
        this(PackageHelper.open(inputStream));
    }

    static final OPCPackage empty() {
        InputStream inputStream = XMLSlideShow.class.getResourceAsStream("empty.pptx");
        if (inputStream == null) {
            throw new POIXMLException("Missing resource 'empty.pptx'");
        }
        try {
            OPCPackage oPCPackage = OPCPackage.open(inputStream);
            return oPCPackage;
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                throw new POIXMLException(exception);
            }
        }
    }

    @Deprecated
    public XSLFSlideShow _getXSLFSlideShow() throws OpenXML4JException, IOException, XmlException {
        return new XSLFSlideShow(this.getPackage());
    }

    @Override
    protected void onDocumentRead() throws IOException {
        try {
            XSLFSheet xSLFSheet;
            PresentationDocument presentationDocument = PresentationDocument.Factory.parse((InputStream)this.getCorePart().getInputStream());
            this._presentation = presentationDocument.getPresentation();
            HashMap<String, XSLFSlideMaster> hashMap = new HashMap<String, XSLFSlideMaster>();
            HashMap<String, XSLFSlide> hashMap2 = new HashMap<String, XSLFSlide>();
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                if (pOIXMLDocumentPart instanceof XSLFSlide) {
                    hashMap2.put(pOIXMLDocumentPart.getPackageRelationship().getId(), (XSLFSlide)pOIXMLDocumentPart);
                    continue;
                }
                if (pOIXMLDocumentPart instanceof XSLFSlideMaster) {
                    hashMap.put(this.getRelationId(pOIXMLDocumentPart), (XSLFSlideMaster)pOIXMLDocumentPart);
                    continue;
                }
                if (pOIXMLDocumentPart instanceof XSLFTableStyles) {
                    this._tableStyles = (XSLFTableStyles)pOIXMLDocumentPart;
                    continue;
                }
                if (pOIXMLDocumentPart instanceof XSLFNotesMaster) {
                    this._notesMaster = (XSLFNotesMaster)pOIXMLDocumentPart;
                    continue;
                }
                if (!(pOIXMLDocumentPart instanceof XSLFCommentAuthors)) continue;
                this._commentAuthors = (XSLFCommentAuthors)pOIXMLDocumentPart;
            }
            this._masters = new ArrayList<XSLFSlideMaster>(hashMap.size());
            for (POIXMLDocumentPart pOIXMLDocumentPart : this._presentation.getSldMasterIdLst().getSldMasterIdList()) {
                xSLFSheet = (XSLFSlideMaster)hashMap.get(pOIXMLDocumentPart.getId2());
                this._masters.add((XSLFSlideMaster)xSLFSheet);
            }
            this._slides = new ArrayList<XSLFSlide>(hashMap2.size());
            if (this._presentation.isSetSldIdLst()) {
                for (POIXMLDocumentPart pOIXMLDocumentPart : this._presentation.getSldIdLst().getSldIdList()) {
                    xSLFSheet = (XSLFSlide)hashMap2.get(pOIXMLDocumentPart.getId2());
                    if (xSLFSheet == null) {
                        _logger.log(5, new Object[]{"Slide with r:id " + pOIXMLDocumentPart.getId() + " was defined, but didn't exist in package, skipping"});
                        continue;
                    }
                    this._slides.add((XSLFSlide)xSLFSheet);
                }
            }
        }
        catch (XmlException xmlException) {
            throw new POIXMLException(xmlException);
        }
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this._presentation.save(outputStream, xmlOptions);
        outputStream.close();
    }

    @Override
    public List<PackagePart> getAllEmbedds() throws OpenXML4JException {
        return Collections.unmodifiableList(this.getPackage().getPartsByName(Pattern.compile("/ppt/embeddings/.*?")));
    }

    @Override
    public List<XSLFPictureData> getPictureData() {
        if (this._pictures == null) {
            List<PackagePart> list = this.getPackage().getPartsByName(Pattern.compile("/ppt/media/.*?"));
            this._pictures = new ArrayList<XSLFPictureData>(list.size());
            for (PackagePart packagePart : list) {
                XSLFPictureData xSLFPictureData = new XSLFPictureData(packagePart, null);
                xSLFPictureData.setIndex(this._pictures.size());
                this._pictures.add(xSLFPictureData);
            }
        }
        return Collections.unmodifiableList(this._pictures);
    }

    public XSLFSlide createSlide(XSLFSlideLayout xSLFSlideLayout) {
        CTSlideIdList cTSlideIdList;
        int n = 256;
        int n2 = 1;
        if (!this._presentation.isSetSldIdLst()) {
            cTSlideIdList = this._presentation.addNewSldIdLst();
        } else {
            cTSlideIdList = this._presentation.getSldIdLst();
            for (CTSlideIdListEntry cTSlideIdListEntry : cTSlideIdList.getSldIdArray()) {
                n = (int)Math.max(cTSlideIdListEntry.getId() + 1L, (long)n);
                ++n2;
            }
        }
        XSLFSlide xSLFSlide = (XSLFSlide)this.createRelationship(XSLFRelation.SLIDE, XSLFFactory.getInstance(), n2);
        CTSlideIdListEntry cTSlideIdListEntry = cTSlideIdList.addNewSldId();
        cTSlideIdListEntry.setId((long)n);
        cTSlideIdListEntry.setId2(xSLFSlide.getPackageRelationship().getId());
        xSLFSlideLayout.copyLayout(xSLFSlide);
        xSLFSlide.addRelation(xSLFSlideLayout.getPackageRelationship().getId(), xSLFSlideLayout);
        PackagePartName packagePartName = xSLFSlideLayout.getPackagePart().getPartName();
        xSLFSlide.getPackagePart().addRelationship(packagePartName, TargetMode.INTERNAL, xSLFSlideLayout.getPackageRelationship().getRelationshipType());
        this._slides.add(xSLFSlide);
        return xSLFSlide;
    }

    public XSLFSlide createSlide() {
        XSLFSlideLayout xSLFSlideLayout = this._masters.get(0).getLayout(SlideLayout.BLANK);
        if (xSLFSlideLayout == null) {
            throw new IllegalArgumentException("Blank layout was not found");
        }
        return this.createSlide(xSLFSlideLayout);
    }

    public XSLFNotes getNotesSlide(XSLFSlide xSLFSlide) {
        XSLFNotes xSLFNotes = xSLFSlide.getNotes();
        if (xSLFNotes == null) {
            xSLFNotes = this.createNotesSlide(xSLFSlide);
        }
        return xSLFNotes;
    }

    private XSLFNotes createNotesSlide(XSLFSlide xSLFSlide) {
        if (this._notesMaster == null) {
            this.createNotesMaster();
        }
        Integer n = XSLFRelation.SLIDE.getFileNameIndex(xSLFSlide);
        XSLFNotes xSLFNotes = (XSLFNotes)this.createRelationship(XSLFRelation.NOTES, XSLFFactory.getInstance(), n);
        xSLFNotes.addRelation(this._notesMaster.getPackageRelationship().getId(), this._notesMaster);
        PackagePartName packagePartName = this._notesMaster.getPackagePart().getPartName();
        xSLFNotes.getPackagePart().addRelationship(packagePartName, TargetMode.INTERNAL, this._notesMaster.getPackageRelationship().getRelationshipType());
        xSLFSlide.addRelation(xSLFNotes.getPackageRelationship().getId(), xSLFNotes);
        PackagePartName packagePartName2 = xSLFNotes.getPackagePart().getPartName();
        xSLFSlide.getPackagePart().addRelationship(packagePartName2, TargetMode.INTERNAL, xSLFNotes.getPackageRelationship().getRelationshipType());
        xSLFNotes.addRelation(xSLFSlide.getPackageRelationship().getId(), xSLFSlide);
        PackagePartName packagePartName3 = xSLFSlide.getPackagePart().getPartName();
        xSLFNotes.getPackagePart().addRelationship(packagePartName3, TargetMode.INTERNAL, xSLFSlide.getPackageRelationship().getRelationshipType());
        xSLFNotes.importContent(this._notesMaster);
        return xSLFNotes;
    }

    /*
     * WARNING - void declaration
     */
    public void createNotesMaster() {
        Object object;
        this._notesMaster = (XSLFNotesMaster)this.createRelationship(XSLFRelation.NOTES_MASTER, XSLFFactory.getInstance(), 1);
        CTNotesMasterIdList cTNotesMasterIdList = this._presentation.addNewNotesMasterIdLst();
        CTNotesMasterIdListEntry cTNotesMasterIdListEntry = cTNotesMasterIdList.addNewNotesMasterId();
        cTNotesMasterIdListEntry.setId(this._notesMaster.getPackageRelationship().getId());
        Integer object3 = 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (POIXMLDocumentPart object22 : this.getRelations()) {
            if (!(object22 instanceof XSLFTheme)) continue;
            arrayList.add(XSLFRelation.THEME.getFileNameIndex(object22));
        }
        if (!arrayList.isEmpty()) {
            void var6_8;
            object = false;
            Integer n = 1;
            while (var6_8.intValue() <= arrayList.size()) {
                Integer n2;
                if (!arrayList.contains(var6_8)) {
                    object = true;
                    object3 = var6_8;
                }
                void var7_12 = var6_8;
                Integer n3 = n2 = Integer.valueOf(var6_8.intValue() + 1);
            }
            if (!((Boolean)object).booleanValue()) {
                object3 = arrayList.size() + 1;
            }
        }
        object = (XSLFTheme)this.createRelationship(XSLFRelation.THEME, XSLFFactory.getInstance(), object3);
        ((XSLFTheme)object).importTheme(this.getSlides().get(0).getTheme());
        this._notesMaster.addRelation(((POIXMLDocumentPart)object).getPackageRelationship().getId(), (POIXMLDocumentPart)object);
        PackagePartName packagePartName = ((POIXMLDocumentPart)object).getPackagePart().getPartName();
        this._notesMaster.getPackagePart().addRelationship(packagePartName, TargetMode.INTERNAL, ((POIXMLDocumentPart)object).getPackageRelationship().getRelationshipType());
    }

    public XSLFNotesMaster getNotesMaster() {
        return this._notesMaster;
    }

    @Override
    public List<XSLFSlideMaster> getSlideMasters() {
        return this._masters;
    }

    @Override
    public List<XSLFSlide> getSlides() {
        return this._slides;
    }

    public XSLFCommentAuthors getCommentAuthors() {
        return this._commentAuthors;
    }

    public void setSlideOrder(XSLFSlide xSLFSlide, int n) {
        int n2 = this._slides.indexOf(xSLFSlide);
        if (n2 == -1) {
            throw new IllegalArgumentException("Slide not found");
        }
        if (n2 == n) {
            return;
        }
        this._slides.add(n, this._slides.remove(n2));
        CTSlideIdList cTSlideIdList = this._presentation.getSldIdLst();
        CTSlideIdListEntry[] cTSlideIdListEntryArray = cTSlideIdList.getSldIdArray();
        CTSlideIdListEntry cTSlideIdListEntry = cTSlideIdListEntryArray[n2];
        if (n2 < n) {
            System.arraycopy(cTSlideIdListEntryArray, n2 + 1, cTSlideIdListEntryArray, n2, n - n2);
        } else {
            System.arraycopy(cTSlideIdListEntryArray, n, cTSlideIdListEntryArray, n + 1, n2 - n);
        }
        cTSlideIdListEntryArray[n] = cTSlideIdListEntry;
        cTSlideIdList.setSldIdArray(cTSlideIdListEntryArray);
    }

    public XSLFSlide removeSlide(int n) {
        XSLFSlide xSLFSlide = this._slides.remove(n);
        this.removeRelation(xSLFSlide);
        this._presentation.getSldIdLst().removeSldId(n);
        return xSLFSlide;
    }

    @Override
    public Dimension getPageSize() {
        CTSlideSize cTSlideSize = this._presentation.getSldSz();
        int n = cTSlideSize.getCx();
        int n2 = cTSlideSize.getCy();
        return new Dimension((int)Units.toPoints(n), (int)Units.toPoints(n2));
    }

    public void setPageSize(Dimension dimension) {
        CTSlideSize cTSlideSize = CTSlideSize.Factory.newInstance();
        cTSlideSize.setCx(Units.toEMU(dimension.getWidth()));
        cTSlideSize.setCy(Units.toEMU(dimension.getHeight()));
        this._presentation.setSldSz(cTSlideSize);
    }

    @Internal
    public CTPresentation getCTPresentation() {
        return this._presentation;
    }

    @Override
    public XSLFPictureData addPicture(byte[] byArray, PictureData.PictureType pictureType) {
        XSLFPictureData xSLFPictureData = this.findPictureData(byArray);
        if (xSLFPictureData != null) {
            return xSLFPictureData;
        }
        int n = this._pictures.size();
        XSLFRelation xSLFRelation = XSLFPictureData.getRelationForType(pictureType);
        if (xSLFRelation == null) {
            throw new IllegalArgumentException("Picture type " + (Object)((Object)pictureType) + " is not supported.");
        }
        xSLFPictureData = (XSLFPictureData)this.createRelationship(xSLFRelation, XSLFFactory.getInstance(), n + 1, true);
        xSLFPictureData.setIndex(n);
        this._pictures.add(xSLFPictureData);
        try {
            OutputStream outputStream = xSLFPictureData.getPackagePart().getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new POIXMLException(iOException);
        }
        return xSLFPictureData;
    }

    XSLFPictureData findPictureData(byte[] byArray) {
        long l = IOUtils.calculateChecksum(byArray);
        byte[] byArray2 = new byte[8];
        LittleEndian.putLong(byArray2, 0, l);
        for (XSLFPictureData xSLFPictureData : this.getPictureData()) {
            if (!Arrays.equals(xSLFPictureData.getChecksum(), byArray2)) continue;
            return xSLFPictureData;
        }
        return null;
    }

    public XSLFSlideLayout findLayout(String string) {
        for (XSLFSlideMaster xSLFSlideMaster : this.getSlideMasters()) {
            XSLFSlideLayout xSLFSlideLayout = xSLFSlideMaster.getLayout(string);
            if (xSLFSlideLayout == null) continue;
            return xSLFSlideLayout;
        }
        return null;
    }

    public XSLFTableStyles getTableStyles() {
        return this._tableStyles;
    }

    CTTextParagraphProperties getDefaultParagraphStyle(int n) {
        XmlObject[] xmlObjectArray = this._presentation.selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//p:defaultTextStyle/a:lvl" + (n + 1) + "pPr");
        if (xmlObjectArray.length == 1) {
            return (CTTextParagraphProperties)xmlObjectArray[0];
        }
        return null;
    }

    @Override
    public MasterSheet<XSLFShape, XSLFTextParagraph> createMasterSheet() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resources getResources() {
        throw new UnsupportedOperationException();
    }
}

