/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf.extractor;

import ai2.org.apache.poi.POITextExtractor;
import ai2.org.apache.poi.POIXMLTextExtractor;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.xslf.XSLFSlideShow;
import ai2.org.apache.poi.xslf.usermodel.DrawingParagraph;
import ai2.org.apache.poi.xslf.usermodel.DrawingTextBody;
import ai2.org.apache.poi.xslf.usermodel.DrawingTextPlaceholder;
import ai2.org.apache.poi.xslf.usermodel.XMLSlideShow;
import ai2.org.apache.poi.xslf.usermodel.XSLFCommentAuthors;
import ai2.org.apache.poi.xslf.usermodel.XSLFComments;
import ai2.org.apache.poi.xslf.usermodel.XSLFCommonSlideData;
import ai2.org.apache.poi.xslf.usermodel.XSLFNotes;
import ai2.org.apache.poi.xslf.usermodel.XSLFRelation;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlide;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import ai2.org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import java.io.IOException;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTComment;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommentAuthor;

public class XSLFPowerPointExtractor
extends POIXMLTextExtractor {
    public static final XSLFRelation[] SUPPORTED_TYPES = new XSLFRelation[]{XSLFRelation.MAIN, XSLFRelation.MACRO, XSLFRelation.MACRO_TEMPLATE, XSLFRelation.PRESENTATIONML, XSLFRelation.PRESENTATIONML_TEMPLATE, XSLFRelation.PRESENTATION_MACRO};
    private XMLSlideShow slideshow;
    private boolean slidesByDefault = true;
    private boolean notesByDefault = false;
    private boolean masterByDefault = false;

    public XSLFPowerPointExtractor(XMLSlideShow xMLSlideShow) {
        super(xMLSlideShow);
        this.slideshow = xMLSlideShow;
    }

    public XSLFPowerPointExtractor(XSLFSlideShow xSLFSlideShow) throws XmlException, IOException {
        this(new XMLSlideShow(xSLFSlideShow.getPackage()));
    }

    public XSLFPowerPointExtractor(OPCPackage oPCPackage) throws XmlException, OpenXML4JException, IOException {
        this(new XSLFSlideShow(oPCPackage));
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Use:");
            System.err.println("  XSLFPowerPointExtractor <filename.pptx>");
            System.exit(1);
        }
        XSLFPowerPointExtractor xSLFPowerPointExtractor = new XSLFPowerPointExtractor(new XSLFSlideShow(stringArray[0]));
        System.out.println(((POITextExtractor)xSLFPowerPointExtractor).getText());
        xSLFPowerPointExtractor.close();
    }

    public void setSlidesByDefault(boolean bl) {
        this.slidesByDefault = bl;
    }

    public void setNotesByDefault(boolean bl) {
        this.notesByDefault = bl;
    }

    public void setMasterByDefault(boolean bl) {
        this.masterByDefault = bl;
    }

    public String getText() {
        return this.getText(this.slidesByDefault, this.notesByDefault);
    }

    public String getText(boolean bl, boolean bl2) {
        return this.getText(bl, bl2, this.masterByDefault);
    }

    public String getText(boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        List<XSLFSlide> list = this.slideshow.getSlides();
        XSLFCommentAuthors xSLFCommentAuthors = this.slideshow.getCommentAuthors();
        for (XSLFSlide xSLFSlide : list) {
            try {
                XSLFNotes xSLFNotes = xSLFSlide.getNotes();
                XSLFComments xSLFComments = xSLFSlide.getComments();
                XSLFSlideLayout xSLFSlideLayout = xSLFSlide.getSlideLayout();
                XSLFSlideMaster xSLFSlideMaster = xSLFSlideLayout.getSlideMaster();
                if (bl) {
                    this.extractText(xSLFSlide.getCommonSlideData(), false, stringBuffer);
                    if (bl3) {
                        if (xSLFSlideLayout != null) {
                            this.extractText(xSLFSlideLayout.getCommonSlideData(), true, stringBuffer);
                        }
                        if (xSLFSlideMaster != null) {
                            this.extractText(xSLFSlideMaster.getCommonSlideData(), true, stringBuffer);
                        }
                    }
                    if (xSLFComments != null) {
                        for (CTComment cTComment : xSLFComments.getCTCommentsList().getCmArray()) {
                            CTCommentAuthor cTCommentAuthor;
                            if (xSLFCommentAuthors != null && (cTCommentAuthor = xSLFCommentAuthors.getAuthorById(cTComment.getAuthorId())) != null) {
                                stringBuffer.append(cTCommentAuthor.getName() + ": ");
                            }
                            stringBuffer.append(cTComment.getText());
                            stringBuffer.append("\n");
                        }
                    }
                }
                if (!bl2 || xSLFNotes == null) continue;
                this.extractText(xSLFNotes.getCommonSlideData(), false, stringBuffer);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return stringBuffer.toString();
    }

    private void extractText(XSLFCommonSlideData xSLFCommonSlideData, boolean bl, StringBuffer stringBuffer) {
        for (DrawingTextBody drawingTextBody : xSLFCommonSlideData.getDrawingText()) {
            Object object;
            if (bl && drawingTextBody instanceof DrawingTextPlaceholder && !((DrawingTextPlaceholder)(object = (DrawingTextPlaceholder)drawingTextBody)).isPlaceholderCustom()) continue;
            object = drawingTextBody.getParagraphs();
            int n = ((DrawingParagraph[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                stringBuffer.append(((DrawingParagraph)object2).getText());
                stringBuffer.append("\n");
            }
        }
    }
}

