/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xslf;

import ai2.org.apache.poi.POIXMLDocument;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xslf.usermodel.XSLFRelation;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPresentation;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMaster;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMasterIdList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMasterIdListEntry;
import org.openxmlformats.schemas.presentationml.x2006.main.CmLstDocument;
import org.openxmlformats.schemas.presentationml.x2006.main.NotesDocument;
import org.openxmlformats.schemas.presentationml.x2006.main.PresentationDocument;
import org.openxmlformats.schemas.presentationml.x2006.main.SldDocument;
import org.openxmlformats.schemas.presentationml.x2006.main.SldMasterDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFSlideShow
extends POIXMLDocument {
    private PresentationDocument presentationDoc;
    private List<PackagePart> embedds;

    public XSLFSlideShow(OPCPackage oPCPackage) throws OpenXML4JException, IOException, XmlException {
        super(oPCPackage);
        if (this.getCorePart().getContentType().equals(XSLFRelation.THEME_MANAGER.getContentType())) {
            this.rebase(this.getPackage());
        }
        this.presentationDoc = PresentationDocument.Factory.parse((InputStream)this.getCorePart().getInputStream());
        this.embedds = new LinkedList<PackagePart>();
        for (CTSlideIdListEntry cTSlideIdListEntry : this.getSlideReferences().getSldIdArray()) {
            PackagePart packagePart = this.getCorePart();
            PackagePart packagePart2 = packagePart.getRelatedPart(packagePart.getRelationship(cTSlideIdListEntry.getId2()));
            for (PackageRelationship packageRelationship : packagePart2.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject")) {
                this.embedds.add(packagePart2.getRelatedPart(packageRelationship));
            }
            for (PackageRelationship packageRelationship : packagePart2.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/package")) {
                this.embedds.add(packagePart2.getRelatedPart(packageRelationship));
            }
        }
    }

    public XSLFSlideShow(String string) throws OpenXML4JException, IOException, XmlException {
        this(XSLFSlideShow.openPackage(string));
    }

    @Internal
    public CTPresentation getPresentation() {
        return this.presentationDoc.getPresentation();
    }

    @Internal
    public CTSlideIdList getSlideReferences() {
        if (!this.getPresentation().isSetSldIdLst()) {
            this.getPresentation().setSldIdLst(CTSlideIdList.Factory.newInstance());
        }
        return this.getPresentation().getSldIdLst();
    }

    @Internal
    public CTSlideMasterIdList getSlideMasterReferences() {
        return this.getPresentation().getSldMasterIdLst();
    }

    public PackagePart getSlideMasterPart(CTSlideMasterIdListEntry cTSlideMasterIdListEntry) throws IOException, XmlException {
        try {
            PackagePart packagePart = this.getCorePart();
            return packagePart.getRelatedPart(packagePart.getRelationship(cTSlideMasterIdListEntry.getId2()));
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new XmlException((Throwable)invalidFormatException);
        }
    }

    @Internal
    public CTSlideMaster getSlideMaster(CTSlideMasterIdListEntry cTSlideMasterIdListEntry) throws IOException, XmlException {
        PackagePart packagePart = this.getSlideMasterPart(cTSlideMasterIdListEntry);
        SldMasterDocument sldMasterDocument = SldMasterDocument.Factory.parse((InputStream)packagePart.getInputStream());
        return sldMasterDocument.getSldMaster();
    }

    public PackagePart getSlidePart(CTSlideIdListEntry cTSlideIdListEntry) throws IOException, XmlException {
        try {
            PackagePart packagePart = this.getCorePart();
            return packagePart.getRelatedPart(packagePart.getRelationship(cTSlideIdListEntry.getId2()));
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new XmlException((Throwable)invalidFormatException);
        }
    }

    @Internal
    public CTSlide getSlide(CTSlideIdListEntry cTSlideIdListEntry) throws IOException, XmlException {
        PackagePart packagePart = this.getSlidePart(cTSlideIdListEntry);
        SldDocument sldDocument = SldDocument.Factory.parse((InputStream)packagePart.getInputStream());
        return sldDocument.getSld();
    }

    public PackagePart getNodesPart(CTSlideIdListEntry cTSlideIdListEntry) throws IOException, XmlException {
        PackageRelationshipCollection packageRelationshipCollection;
        PackagePart packagePart = this.getSlidePart(cTSlideIdListEntry);
        try {
            packageRelationshipCollection = packagePart.getRelationshipsByType(XSLFRelation.NOTES.getRelation());
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IllegalStateException(invalidFormatException);
        }
        if (packageRelationshipCollection.size() == 0) {
            return null;
        }
        if (packageRelationshipCollection.size() > 1) {
            throw new IllegalStateException("Expecting 0 or 1 notes for a slide, but found " + packageRelationshipCollection.size());
        }
        try {
            return packagePart.getRelatedPart(packageRelationshipCollection.getRelationship(0));
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IllegalStateException(invalidFormatException);
        }
    }

    @Internal
    public CTNotesSlide getNotes(CTSlideIdListEntry cTSlideIdListEntry) throws IOException, XmlException {
        PackagePart packagePart = this.getNodesPart(cTSlideIdListEntry);
        if (packagePart == null) {
            return null;
        }
        NotesDocument notesDocument = NotesDocument.Factory.parse((InputStream)packagePart.getInputStream());
        return notesDocument.getNotes();
    }

    @Internal
    public CTCommentList getSlideComments(CTSlideIdListEntry cTSlideIdListEntry) throws IOException, XmlException {
        PackageRelationshipCollection packageRelationshipCollection;
        PackagePart packagePart = this.getSlidePart(cTSlideIdListEntry);
        try {
            packageRelationshipCollection = packagePart.getRelationshipsByType(XSLFRelation.COMMENTS.getRelation());
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IllegalStateException(invalidFormatException);
        }
        if (packageRelationshipCollection.size() == 0) {
            return null;
        }
        if (packageRelationshipCollection.size() > 1) {
            throw new IllegalStateException("Expecting 0 or 1 comments for a slide, but found " + packageRelationshipCollection.size());
        }
        try {
            PackagePart packagePart2 = packagePart.getRelatedPart(packageRelationshipCollection.getRelationship(0));
            CmLstDocument cmLstDocument = CmLstDocument.Factory.parse((InputStream)packagePart2.getInputStream());
            return cmLstDocument.getCmLst();
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IllegalStateException(invalidFormatException);
        }
    }

    @Override
    public List<PackagePart> getAllEmbedds() throws OpenXML4JException {
        return this.embedds;
    }
}

