/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlSort {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("    java XmlSort <XML_File> [<XPath>]");
            return;
        }
        File file = new File(stringArray[0]);
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((File)file);
            XmlObject xmlObject2 = null;
            if (stringArray.length > 1) {
                String string = stringArray[1];
                XmlObject[] xmlObjectArray = xmlObject.selectPath(string);
                if (xmlObjectArray.length == 0) {
                    System.out.println("ERROR: XPath \"" + string + "\" did not return any results");
                } else if (xmlObjectArray.length > 1) {
                    System.out.println("ERROR: XPath \"" + string + "\" returned more than one " + "node (" + xmlObjectArray.length + ")");
                } else {
                    xmlObject2 = xmlObjectArray[0];
                }
            } else {
                XmlCursor xmlCursor = xmlObject.newCursor();
                xmlCursor.toFirstChild();
                xmlObject2 = xmlCursor.getObject();
                xmlCursor.dispose();
            }
            if (xmlObject2 != null) {
                XmlSort.sort(xmlObject2, new QNameComparator(1));
            }
            System.out.println(xmlObject.xmlText());
        }
        catch (IOException iOException) {
            System.out.println("ERROR: Could not open file: \"" + stringArray[0] + "\": " + iOException.getMessage());
        }
        catch (XmlException xmlException) {
            System.out.println("ERROR: Could not parse file: \"" + stringArray[0] + "\": " + xmlException.getMessage());
        }
    }

    public static void sort(XmlObject xmlObject, Comparator<XmlCursor> comparator) {
        XmlCursor xmlCursor = xmlObject.newCursor();
        if (!xmlCursor.isStart()) {
            throw new IllegalStateException("The element parameter must point to a STARTDOC");
        }
        boolean bl = xmlCursor.toFirstChild();
        if (!bl) {
            return;
        }
        XmlCursor xmlCursor2 = xmlCursor.newCursor();
        boolean bl2 = xmlCursor2.toNextSibling();
        while (bl2) {
            bl = false;
            while (xmlCursor.comparePosition(xmlCursor2) < 0) {
                if (comparator.compare(xmlCursor, xmlCursor2) > 0) {
                    xmlCursor2.moveXml(xmlCursor);
                    while (!xmlCursor2.isStart() && !xmlCursor2.isEnd()) {
                        xmlCursor2.moveXml(xmlCursor);
                    }
                    bl2 = xmlCursor2.isStart();
                    bl = true;
                    break;
                }
                xmlCursor.toNextSibling();
            }
            if (!bl) {
                bl2 = xmlCursor2.toNextSibling();
            }
            xmlCursor.toParent();
            xmlCursor.toFirstChild();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class QNameComparator
    implements Comparator<XmlCursor> {
        public static final int ASCENDING = 1;
        public static final int DESCENDING = 2;
        private int order;

        public QNameComparator(int n) {
            this.order = n;
            if (n != 1 && n != 2) {
                throw new IllegalArgumentException("Please specify one of ASCENDING or DESCENDING comparison orders");
            }
        }

        @Override
        public int compare(XmlCursor xmlCursor, XmlCursor xmlCursor2) {
            QName qName = xmlCursor.getName();
            QName qName2 = xmlCursor2.getName();
            int n = qName.getNamespaceURI().compareTo(qName2.getNamespaceURI());
            if (n == 0) {
                return this.order == 1 ? qName.getLocalPart().compareTo(qName2.getLocalPart()) : -qName.getLocalPart().compareTo(qName2.getLocalPart());
            }
            return this.order == 1 ? n : -n;
        }
    }
}

