/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.TempFileCreationStrategy;
import java.io.File;
import java.io.IOException;

public final class TempFile {
    private static TempFileCreationStrategy strategy = new DefaultTempFileCreationStrategy();

    public static void setTempFileCreationStrategy(TempFileCreationStrategy tempFileCreationStrategy) {
        if (tempFileCreationStrategy == null) {
            throw new IllegalArgumentException("strategy == null");
        }
        strategy = tempFileCreationStrategy;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return strategy.createTempFile(string, string2);
    }

    public static class DefaultTempFileCreationStrategy
    implements TempFileCreationStrategy {
        private File dir;

        public DefaultTempFileCreationStrategy() {
            this(null);
        }

        public DefaultTempFileCreationStrategy(File file) {
            this.dir = file;
        }

        public File createTempFile(String string, String string2) throws IOException {
            if (this.dir == null) {
                this.dir = new File(System.getProperty("java.io.tmpdir"), "poifiles");
                this.dir.mkdir();
                if (System.getProperty("poi.keep.tmp.files") == null) {
                    this.dir.deleteOnExit();
                }
            }
            File file = File.createTempFile(string, string2, this.dir);
            if (System.getProperty("poi.keep.tmp.files") == null) {
                file.deleteOnExit();
            }
            return file;
        }
    }
}

