/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;
import java.nio.charset.Charset;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class StringUtil {
    protected static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    protected static final Charset UTF16LE = Charset.forName("UTF-16LE");
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static Map<Integer, Integer> msCodepointToUnicode;
    private static final int[] symbolMap_f020;
    private static final int[] symbolMap_f0a0;

    private StringUtil() {
    }

    public static String getFromUnicodeLE(byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset " + n + " (String data is of length " + byArray.length + ")");
        }
        if (n2 < 0 || (byArray.length - n) / 2 < n2) {
            throw new IllegalArgumentException("Illegal length " + n2);
        }
        return new String(byArray, n, n2 * 2, UTF16LE);
    }

    public static String getFromUnicodeLE(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        return StringUtil.getFromUnicodeLE(byArray, 0, byArray.length / 2);
    }

    public static byte[] getToUnicodeLE(String string) {
        return string.getBytes(UTF16LE);
    }

    public static String getFromCompressedUnicode(byte[] byArray, int n, int n2) {
        int n3 = Math.min(n2, byArray.length - n);
        return new String(byArray, n, n3, ISO_8859_1);
    }

    public static String readCompressedUnicode(LittleEndianInput littleEndianInput, int n) {
        byte[] byArray = new byte[n];
        littleEndianInput.readFully(byArray);
        return new String(byArray, ISO_8859_1);
    }

    public static String readUnicodeString(LittleEndianInput littleEndianInput) {
        int n = littleEndianInput.readUShort();
        byte by = littleEndianInput.readByte();
        if ((by & 1) == 0) {
            return StringUtil.readCompressedUnicode(littleEndianInput, n);
        }
        return StringUtil.readUnicodeLE(littleEndianInput, n);
    }

    public static String readUnicodeString(LittleEndianInput littleEndianInput, int n) {
        byte by = littleEndianInput.readByte();
        if ((by & 1) == 0) {
            return StringUtil.readCompressedUnicode(littleEndianInput, n);
        }
        return StringUtil.readUnicodeLE(littleEndianInput, n);
    }

    public static void writeUnicodeString(LittleEndianOutput littleEndianOutput, String string) {
        int n = string.length();
        littleEndianOutput.writeShort(n);
        boolean bl = StringUtil.hasMultibyte(string);
        littleEndianOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            StringUtil.putUnicodeLE(string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(string, littleEndianOutput);
        }
    }

    public static void writeUnicodeStringFlagAndData(LittleEndianOutput littleEndianOutput, String string) {
        boolean bl = StringUtil.hasMultibyte(string);
        littleEndianOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            StringUtil.putUnicodeLE(string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(string, littleEndianOutput);
        }
    }

    public static int getEncodedSize(String string) {
        int n = 3;
        return n += string.length() * (StringUtil.hasMultibyte(string) ? 2 : 1);
    }

    public static void putCompressedUnicode(String string, byte[] byArray, int n) {
        byte[] byArray2 = string.getBytes(ISO_8859_1);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void putCompressedUnicode(String string, LittleEndianOutput littleEndianOutput) {
        byte[] byArray = string.getBytes(ISO_8859_1);
        littleEndianOutput.write(byArray);
    }

    public static void putUnicodeLE(String string, byte[] byArray, int n) {
        byte[] byArray2 = string.getBytes(UTF16LE);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void putUnicodeLE(String string, LittleEndianOutput littleEndianOutput) {
        byte[] byArray = string.getBytes(UTF16LE);
        littleEndianOutput.write(byArray);
    }

    public static String readUnicodeLE(LittleEndianInput littleEndianInput, int n) {
        byte[] byArray = new byte[n * 2];
        littleEndianInput.readFully(byArray);
        return new String(byArray, UTF16LE);
    }

    public static String format(String string, Object[] objectArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '%') {
                if (n >= objectArray.length) {
                    stringBuffer.append("?missing data?");
                    continue;
                }
                if (objectArray[n] instanceof Number && i + 1 < string.length()) {
                    i += StringUtil.matchOptionalFormatting((Number)objectArray[n++], string.substring(i + 1), stringBuffer);
                    continue;
                }
                stringBuffer.append(objectArray[n++].toString());
                continue;
            }
            if (string.charAt(i) == '\\' && i + 1 < string.length() && string.charAt(i + 1) == '%') {
                stringBuffer.append('%');
                ++i;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static int matchOptionalFormatting(Number number, String string, StringBuffer stringBuffer) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        if (0 < string.length() && Character.isDigit(string.charAt(0))) {
            numberFormat.setMinimumIntegerDigits(Integer.parseInt(string.charAt(0) + ""));
            if (2 < string.length() && string.charAt(1) == '.' && Character.isDigit(string.charAt(2))) {
                numberFormat.setMaximumFractionDigits(Integer.parseInt(string.charAt(2) + ""));
                numberFormat.format(number, stringBuffer, new FieldPosition(0));
                return 3;
            }
            numberFormat.format(number, stringBuffer, new FieldPosition(0));
            return 1;
        }
        if (0 < string.length() && string.charAt(0) == '.' && 1 < string.length() && Character.isDigit(string.charAt(1))) {
            numberFormat.setMaximumFractionDigits(Integer.parseInt(string.charAt(1) + ""));
            numberFormat.format(number, stringBuffer, new FieldPosition(0));
            return 2;
        }
        numberFormat.format(number, stringBuffer, new FieldPosition(0));
        return 1;
    }

    public static String getPreferredEncoding() {
        return ISO_8859_1.name();
    }

    public static boolean hasMultibyte(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public static boolean isUnicodeString(String string) {
        return !string.equals(new String(string.getBytes(ISO_8859_1), ISO_8859_1));
    }

    public static String mapMsCodepointString(String string) {
        Integer n;
        if (string == null || "".equals(string)) {
            return string;
        }
        StringUtil.initMsCodepointMap();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            Integer n3 = msCodepointToUnicode.get(n);
            stringBuilder.appendCodePoint(n3 == null ? n : n3);
        }
        return stringBuilder.toString();
    }

    public static synchronized void mapMsCodepoint(int n, int n2) {
        StringUtil.initMsCodepointMap();
        msCodepointToUnicode.put(n, n2);
    }

    private static synchronized void initMsCodepointMap() {
        if (msCodepointToUnicode != null) {
            return;
        }
        msCodepointToUnicode = new HashMap<Integer, Integer>();
        int n = 61472;
        for (int n2 : symbolMap_f020) {
            msCodepointToUnicode.put(n++, n2);
        }
        n = 61600;
        for (int n2 : symbolMap_f0a0) {
            msCodepointToUnicode.put(n++, n2);
        }
    }

    static {
        symbolMap_f020 = new int[]{32, 33, 8704, 35, 8707, 37, 38, 8717, 40, 41, 8727, 43, 44, 8722, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 8773, 913, 914, 935, 916, 917, 934, 915, 919, 921, 977, 922, 923, 924, 925, 927, 928, 920, 929, 931, 932, 933, 962, 937, 926, 936, 918, 91, 8765, 93, 8869, 95, 32, 945, 946, 967, 948, 949, 966, 947, 951, 953, 981, 954, 955, 956, 957, 959, 960, 952, 961, 963, 964, 965, 982, 969, 958, 968, 950, 123, 124, 125, 8764, 32};
        symbolMap_f0a0 = new int[]{8364, 978, 8242, 8804, 8260, 8734, 402, 9827, 9830, 9829, 9824, 8596, 8591, 8593, 8594, 8595, 176, 177, 8243, 8805, 215, 181, 8706, 8729, 247, 8800, 8801, 8776, 8230, 9168, 9135, 8629, 8501, 8475, 8476, 8472, 8855, 8853, 8709, 8745, 8746, 8835, 8839, 8836, 8834, 8838, 8712, 8713, 8736, 8711, 174, 169, 8482, 8719, 8730, 8901, 172, 8743, 8744, 8660, 8656, 8657, 8658, 8659, 9674, 9001, 174, 169, 8482, 8721, 9115, 9116, 9117, 9121, 9122, 9123, 9127, 9128, 9129, 9130, 32, 9002, 8747, 8992, 9134, 8993, 9118, 9119, 9120, 9124, 9125, 9126, 9131, 9132, 9133, 32};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringsIterator
    implements Iterator<String> {
        private String[] strings;
        private int position = 0;

        public StringsIterator(String[] stringArray) {
            this.strings = stringArray != null ? stringArray : new String[0];
        }

        @Override
        public boolean hasNext() {
            return this.position < this.strings.length;
        }

        @Override
        public String next() {
            int n;
            if ((n = this.position++) >= this.strings.length) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            return this.strings[n];
        }

        @Override
        public void remove() {
        }
    }
}

