/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

public class ShortList {
    private short[] _array;
    private int _limit;
    private static final int _default_size = 128;

    public ShortList() {
        this(128);
    }

    public ShortList(ShortList shortList) {
        this(shortList._array.length);
        System.arraycopy(shortList._array, 0, this._array, 0, this._array.length);
        this._limit = shortList._limit;
    }

    public ShortList(int n) {
        this._array = new short[n];
        this._limit = 0;
    }

    public void add(int n, short s) {
        if (n > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (n == this._limit) {
            this.add(s);
        } else {
            if (this._limit == this._array.length) {
                this.growArray(this._limit * 2);
            }
            System.arraycopy(this._array, n, this._array, n + 1, this._limit - n);
            this._array[n] = s;
            ++this._limit;
        }
    }

    public boolean add(short s) {
        if (this._limit == this._array.length) {
            this.growArray(this._limit * 2);
        }
        this._array[this._limit++] = s;
        return true;
    }

    public boolean addAll(ShortList shortList) {
        if (shortList._limit != 0) {
            if (this._limit + shortList._limit > this._array.length) {
                this.growArray(this._limit + shortList._limit);
            }
            System.arraycopy(shortList._array, 0, this._array, this._limit, shortList._limit);
            this._limit += shortList._limit;
        }
        return true;
    }

    public boolean addAll(int n, ShortList shortList) {
        if (n > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (shortList._limit != 0) {
            if (this._limit + shortList._limit > this._array.length) {
                this.growArray(this._limit + shortList._limit);
            }
            System.arraycopy(this._array, n, this._array, n + shortList._limit, this._limit - n);
            System.arraycopy(shortList._array, 0, this._array, n, shortList._limit);
            this._limit += shortList._limit;
        }
        return true;
    }

    public void clear() {
        this._limit = 0;
    }

    public boolean contains(short s) {
        boolean bl = false;
        for (int i = 0; !bl && i < this._limit; ++i) {
            if (this._array[i] != s) continue;
            bl = true;
        }
        return bl;
    }

    public boolean containsAll(ShortList shortList) {
        boolean bl = true;
        if (this != shortList) {
            for (int i = 0; bl && i < shortList._limit; ++i) {
                if (this.contains(shortList._array[i])) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object != null && object.getClass() == this.getClass()) {
            ShortList shortList = (ShortList)object;
            if (shortList._limit == this._limit) {
                bl = true;
                for (int i = 0; bl && i < this._limit; ++i) {
                    bl = this._array[i] == shortList._array[i];
                }
            }
        }
        return bl;
    }

    public short get(int n) {
        if (n >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        return this._array[n];
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._limit; ++i) {
            n = 31 * n + this._array[i];
        }
        return n;
    }

    public int indexOf(short s) {
        int n;
        for (n = 0; n < this._limit && s != this._array[n]; ++n) {
        }
        if (n == this._limit) {
            n = -1;
        }
        return n;
    }

    public boolean isEmpty() {
        return this._limit == 0;
    }

    public int lastIndexOf(short s) {
        int n;
        for (n = this._limit - 1; n >= 0 && s != this._array[n]; --n) {
        }
        return n;
    }

    public short remove(int n) {
        if (n >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        short s = this._array[n];
        System.arraycopy(this._array, n + 1, this._array, n, this._limit - n);
        --this._limit;
        return s;
    }

    public boolean removeValue(short s) {
        boolean bl = false;
        for (int i = 0; !bl && i < this._limit; ++i) {
            if (s != this._array[i]) continue;
            System.arraycopy(this._array, i + 1, this._array, i, this._limit - i);
            --this._limit;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(ShortList shortList) {
        boolean bl = false;
        for (int i = 0; i < shortList._limit; ++i) {
            if (!this.removeValue(shortList._array[i])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(ShortList shortList) {
        boolean bl = false;
        int n = 0;
        while (n < this._limit) {
            if (!shortList.contains(this._array[n])) {
                this.remove(n);
                bl = true;
                continue;
            }
            ++n;
        }
        return bl;
    }

    public short set(int n, short s) {
        if (n >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        short s2 = this._array[n];
        this._array[n] = s;
        return s2;
    }

    public int size() {
        return this._limit;
    }

    public short[] toArray() {
        short[] sArray = new short[this._limit];
        System.arraycopy(this._array, 0, sArray, 0, this._limit);
        return sArray;
    }

    public short[] toArray(short[] sArray) {
        short[] sArray2;
        if (sArray.length == this._limit) {
            System.arraycopy(this._array, 0, sArray, 0, this._limit);
            sArray2 = sArray;
        } else {
            sArray2 = this.toArray();
        }
        return sArray2;
    }

    private void growArray(int n) {
        int n2 = n == this._array.length ? n + 1 : n;
        short[] sArray = new short[n2];
        System.arraycopy(this._array, 0, sArray, 0, this._limit);
        this._array = sArray;
    }
}

