/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OOXMLLite {
    private static Field _classes;
    private File _destDest;
    private File _testDir;
    private File _ooxmlJar;

    OOXMLLite(String string, String string2, String string3) {
        this._destDest = new File(string);
        this._testDir = new File(string2);
        this._ooxmlJar = new File(string3);
    }

    public static void main(String[] stringArray) throws IOException, ClassNotFoundException {
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-dest")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-test")) {
                string2 = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equals("-ooxml")) continue;
            string3 = stringArray[++i];
        }
        OOXMLLite oOXMLLite = new OOXMLLite(string, string2, string3);
        oOXMLLite.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void build() throws IOException, ClassNotFoundException {
        File file;
        Object object;
        Object object2;
        ArrayList arrayList = new ArrayList();
        System.out.println("Collecting unit tests from " + this._testDir);
        OOXMLLite.collectTests(this._testDir, this._testDir, arrayList, ".+.class$", ".+(BaseTestXCell|TestUnfixedBugs|MemoryUsage|TestDataProvider|TestDataSamples|All.+Tests|ZipFileAssert|PkiTestUtils|TestCellFormatPart\\$\\d|TestSignatureInfo\\$\\d|TestSXSSFWorkbook\\$\\d|TestCertificateEncryption\\$CertData|TestPOIXMLDocument\\$OPCParser|TestPOIXMLDocument\\$TestFactory|TestXSLFTextParagraph\\$DrawTextParagraphProxy|TestXSSFExportToXML\\$\\d|TestXSSFExportToXML\\$DummyEntityResolver|TestSXSSFWorkbook\\$NullOutputStream|TestFormulaEvaluatorOnXSSF\\$Result|TestFormulaEvaluatorOnXSSF\\$SS|TestMultiSheetFormulaEvaluatorOnXSSF\\$Result|TestMultiSheetFormulaEvaluatorOnXSSF\\$SS|TestXSSFBugs\\$\\d).class");
        System.out.println("Found " + arrayList.size() + " classes");
        JUnitCore jUnitCore = new JUnitCore();
        jUnitCore.addListener((RunListener)new TextListener(System.out));
        Result result = jUnitCore.run(arrayList.toArray(new Class[arrayList.size()]));
        if (!result.wasSuccessful()) {
            throw new RuntimeException("Tests did not succeed, cannot build ooxml-lite jar");
        }
        System.out.println("Copying classes to " + this._destDest);
        Map<String, Class<?>> map = OOXMLLite.getLoadedClasses(this._ooxmlJar.getName());
        for (Class<?> serializable2 : map.values()) {
            object2 = serializable2.getName();
            object = ((String)object2).replace('.', '/') + ".class";
            file = new File(this._destDest, (String)object);
            OOXMLLite.copyFile(serializable2.getResourceAsStream('/' + (String)object), file);
            if (!serializable2.isInterface()) continue;
            for (Class<?> clazz : serializable2.getDeclaredClasses()) {
                object2 = clazz.getName();
                object = ((String)object2).replace('.', '/') + ".class";
                file = new File(this._destDest, (String)object);
                OOXMLLite.copyFile(clazz.getResourceAsStream('/' + (String)object), file);
            }
        }
        System.out.println("Copying .xsb resources");
        JarFile jarFile = new JarFile(this._ooxmlJar);
        Pattern pattern = Pattern.compile("schemaorg_apache_xmlbeans/(system|element)/.*\\.xsb");
        try {
            object2 = jarFile.entries();
            while (object2.hasMoreElements()) {
                object = (JarEntry)object2.nextElement();
                if (!pattern.matcher(((ZipEntry)object).getName()).matches()) continue;
                file = new File(this._destDest, ((ZipEntry)object).getName());
                OOXMLLite.copyFile(jarFile.getInputStream((ZipEntry)object), file);
            }
        }
        finally {
            jarFile.close();
        }
    }

    private static boolean checkForTestAnnotation(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Test.class)) continue;
            return true;
        }
        if (clazz.getSuperclass() != null) {
            for (Method method : clazz.getSuperclass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Test.class)) continue;
                return true;
            }
        }
        System.out.println("Class " + clazz.getName() + " does not derive from TestCase and does not have a @Test annotation");
        return false;
    }

    private static void collectTests(File file, File file2, List<Class<?>> list, String string, String string2) throws ClassNotFoundException {
        if (file2.isDirectory()) {
            for (File file3 : file2.listFiles()) {
                OOXMLLite.collectTests(file, file3, list, string, string2);
            }
        } else {
            String string3;
            String string4 = file2.getAbsolutePath();
            String string5 = string4.substring((string3 = file.getAbsolutePath()).length() + 1).replace(File.separator, ".");
            if (!string5.matches(string)) {
                return;
            }
            if (string5.matches(string2)) {
                return;
            }
            if (string5.indexOf(36) != -1) {
                System.out.println("Inner class " + string5 + " not included");
                return;
            }
            Class<?> clazz = Class.forName(string5 = string5.replace(".class", ""));
            if (TestCase.class.isAssignableFrom(clazz) || OOXMLLite.checkForTestAnnotation(clazz)) {
                list.add(clazz);
            }
        }
    }

    private static Map<String, Class<?>> getLoadedClasses(String string) {
        try {
            _classes = ClassLoader.class.getDeclaredField("classes");
            _classes.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            Vector vector = (Vector)_classes.get(classLoader);
            HashMap hashMap = new HashMap();
            for (Class clazz : vector) {
                String string2;
                URL uRL;
                CodeSource codeSource;
                ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                if (protectionDomain == null || (codeSource = protectionDomain.getCodeSource()) == null || (uRL = codeSource.getLocation()) == null || (string2 = uRL.toString()).indexOf(string) == -1) continue;
                hashMap.put(clazz.getName(), clazz);
            }
            return hashMap;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(InputStream inputStream, File file) throws IOException {
        File file2 = file.getParentFile();
        file2.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            IOUtils.copy(inputStream, fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }
}

