/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LittleEndianInput;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream
implements LittleEndianInput {
    public LittleEndianInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int available() {
        try {
            return super.available();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public byte readByte() {
        return (byte)this.readUByte();
    }

    public int readUByte() {
        byte[] byArray = new byte[1];
        try {
            LittleEndianInputStream.checkEOF(this.read(byArray), 1);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return LittleEndian.getUByte(byArray);
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public int readInt() {
        byte[] byArray = new byte[4];
        try {
            LittleEndianInputStream.checkEOF(this.read(byArray), byArray.length);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return LittleEndian.getInt(byArray);
    }

    public long readUInt() {
        long l = this.readInt();
        return l & 0xFFFFFFFFL;
    }

    public long readLong() {
        byte[] byArray = new byte[8];
        try {
            LittleEndianInputStream.checkEOF(this.read(byArray), 8);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return LittleEndian.getLong(byArray);
    }

    public short readShort() {
        return (short)this.readUShort();
    }

    public int readUShort() {
        byte[] byArray = new byte[2];
        try {
            LittleEndianInputStream.checkEOF(this.read(byArray), 2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return LittleEndian.getUShort(byArray);
    }

    private static void checkEOF(int n, int n2) {
        if (n2 != 0 && (n == -1 || n != n2)) {
            throw new RuntimeException("Unexpected end-of-file");
        }
    }

    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) {
        try {
            LittleEndianInputStream.checkEOF(this.read(byArray, n, n2), n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

