/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.util;

import java.util.LinkedList;
import java.util.ListIterator;

public class IdentifierManager {
    public static final long MAX_ID = 0x7FFFFFFFFFFFFFFEL;
    public static final long MIN_ID = 0L;
    private final long upperbound;
    private final long lowerbound;
    private LinkedList<Segment> segments;

    public IdentifierManager(long l, long l2) {
        if (l > l2) {
            String string = "lowerbound must not be greater than upperbound";
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = "lowerbound must be greater than or equal to " + Long.toString(0L);
            throw new IllegalArgumentException(string);
        }
        if (l2 > 0x7FFFFFFFFFFFFFFEL) {
            String string = "upperbound must be less thean or equal " + Long.toString(0x7FFFFFFFFFFFFFFEL);
            throw new IllegalArgumentException(string);
        }
        this.lowerbound = l;
        this.upperbound = l2;
        this.segments = new LinkedList();
        this.segments.add(new Segment(l, l2));
    }

    public long reserve(long l) {
        if (l < this.lowerbound || l > this.upperbound) {
            throw new IllegalArgumentException("Value for parameter 'id' was out of bounds");
        }
        this.verifyIdentifiersLeft();
        if (l == this.upperbound) {
            Segment segment = this.segments.getLast();
            if (segment.end == this.upperbound) {
                segment.end = this.upperbound - 1L;
                if (segment.start > segment.end) {
                    this.segments.removeLast();
                }
                return l;
            }
            return this.reserveNew();
        }
        if (l == this.lowerbound) {
            Segment segment = this.segments.getFirst();
            if (segment.start == this.lowerbound) {
                segment.start = this.lowerbound + 1L;
                if (segment.end < segment.start) {
                    this.segments.removeFirst();
                }
                return l;
            }
            return this.reserveNew();
        }
        ListIterator<Segment> listIterator = this.segments.listIterator();
        while (listIterator.hasNext()) {
            Segment segment = (Segment)listIterator.next();
            if (segment.end < l) continue;
            if (segment.start > l) break;
            if (segment.start == l) {
                segment.start = l + 1L;
                if (segment.end < segment.start) {
                    listIterator.remove();
                }
                return l;
            }
            if (segment.end == l) {
                segment.end = l - 1L;
                if (segment.start > segment.end) {
                    listIterator.remove();
                }
                return l;
            }
            listIterator.add(new Segment(l + 1L, segment.end));
            segment.end = l - 1L;
            return l;
        }
        return this.reserveNew();
    }

    public long reserveNew() {
        this.verifyIdentifiersLeft();
        Segment segment = this.segments.getFirst();
        long l = segment.start++;
        if (segment.start > segment.end) {
            this.segments.removeFirst();
        }
        return l;
    }

    public boolean release(long l) {
        if (l < this.lowerbound || l > this.upperbound) {
            throw new IllegalArgumentException("Value for parameter 'id' was out of bounds");
        }
        if (l == this.upperbound) {
            Segment segment = this.segments.getLast();
            if (segment.end == this.upperbound - 1L) {
                segment.end = this.upperbound;
                return true;
            }
            if (segment.end == this.upperbound) {
                return false;
            }
            this.segments.add(new Segment(this.upperbound, this.upperbound));
            return true;
        }
        if (l == this.lowerbound) {
            Segment segment = this.segments.getFirst();
            if (segment.start == this.lowerbound + 1L) {
                segment.start = this.lowerbound;
                return true;
            }
            if (segment.start == this.lowerbound) {
                return false;
            }
            this.segments.addFirst(new Segment(this.lowerbound, this.lowerbound));
            return true;
        }
        long l2 = l + 1L;
        long l3 = l - 1L;
        ListIterator<Segment> listIterator = this.segments.listIterator();
        while (listIterator.hasNext()) {
            Segment segment = (Segment)listIterator.next();
            if (segment.end < l3) continue;
            if (segment.start > l2) {
                listIterator.previous();
                listIterator.add(new Segment(l, l));
                return true;
            }
            if (segment.start == l2) {
                segment.start = l;
                return true;
            }
            if (segment.end != l3) break;
            segment.end = l;
            if (listIterator.hasNext()) {
                Segment segment2 = (Segment)listIterator.next();
                if (segment2.start == segment.end + 1L) {
                    segment.end = segment2.end;
                    listIterator.remove();
                }
            }
            return true;
        }
        return false;
    }

    public long getRemainingIdentifiers() {
        long l = 0L;
        for (Segment segment : this.segments) {
            l -= segment.start;
            l = l + segment.end + 1L;
        }
        return l;
    }

    private void verifyIdentifiersLeft() {
        if (this.segments.isEmpty()) {
            throw new IllegalStateException("No identifiers left");
        }
    }

    private static class Segment {
        public long start;
        public long end;

        public Segment(long l, long l2) {
            this.start = l;
            this.end = l2;
        }

        public String toString() {
            return "[" + this.start + "; " + this.end + "]";
        }
    }
}

