/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.util.cellwalk;

import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.usermodel.Sheet;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.cellwalk.CellHandler;
import ai2.org.apache.poi.ss.util.cellwalk.CellWalkContext;

public class CellWalk {
    private Sheet sheet;
    private CellRangeAddress range;
    private boolean traverseEmptyCells;

    public CellWalk(Sheet sheet, CellRangeAddress cellRangeAddress) {
        this.sheet = sheet;
        this.range = cellRangeAddress;
        this.traverseEmptyCells = false;
    }

    public boolean isTraverseEmptyCells() {
        return this.traverseEmptyCells;
    }

    public void setTraverseEmptyCells(boolean bl) {
        this.traverseEmptyCells = bl;
    }

    public void traverse(CellHandler cellHandler) {
        int n = this.range.getFirstRow();
        int n2 = this.range.getLastRow();
        int n3 = this.range.getFirstColumn();
        int n4 = this.range.getLastColumn();
        int n5 = n4 - n3 + 1;
        SimpleCellWalkContext simpleCellWalkContext = new SimpleCellWalkContext();
        Row row = null;
        Cell cell = null;
        simpleCellWalkContext.rowNumber = n;
        while (simpleCellWalkContext.rowNumber <= n2) {
            row = this.sheet.getRow(simpleCellWalkContext.rowNumber);
            if (row != null) {
                simpleCellWalkContext.colNumber = n3;
                while (simpleCellWalkContext.colNumber <= n4) {
                    cell = row.getCell(simpleCellWalkContext.colNumber);
                    if (cell != null && (!this.isEmpty(cell) || this.traverseEmptyCells)) {
                        simpleCellWalkContext.ordinalNumber = (simpleCellWalkContext.rowNumber - n) * n5 + (simpleCellWalkContext.colNumber - n3 + 1);
                        cellHandler.onCell(cell, simpleCellWalkContext);
                    }
                    ++simpleCellWalkContext.colNumber;
                }
            }
            ++simpleCellWalkContext.rowNumber;
        }
    }

    private boolean isEmpty(Cell cell) {
        return cell.getCellType() == 3;
    }

    private static class SimpleCellWalkContext
    implements CellWalkContext {
        public long ordinalNumber = 0L;
        public int rowNumber = 0;
        public int colNumber = 0;

        private SimpleCellWalkContext() {
        }

        public long getOrdinalNumber() {
            return this.ordinalNumber;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        public int getColumnNumber() {
            return this.colNumber;
        }
    }
}

