/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.util;

import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.usermodel.Sheet;
import ai2.org.apache.poi.ss.usermodel.Workbook;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.CellUtil;

public final class RegionUtil {
    private RegionUtil() {
    }

    public static void setBorderLeft(int n, CellRangeAddress cellRangeAddress, Sheet sheet, Workbook workbook) {
        int n2 = cellRangeAddress.getFirstRow();
        int n3 = cellRangeAddress.getLastRow();
        int n4 = cellRangeAddress.getFirstColumn();
        CellPropertySetter cellPropertySetter = new CellPropertySetter(workbook, "borderLeft", n);
        for (int i = n2; i <= n3; ++i) {
            cellPropertySetter.setProperty(CellUtil.getRow(i, sheet), n4);
        }
    }

    public static void setLeftBorderColor(int n, CellRangeAddress cellRangeAddress, Sheet sheet, Workbook workbook) {
        int n2 = cellRangeAddress.getFirstRow();
        int n3 = cellRangeAddress.getLastRow();
        int n4 = cellRangeAddress.getFirstColumn();
        CellPropertySetter cellPropertySetter = new CellPropertySetter(workbook, "leftBorderColor", n);
        for (int i = n2; i <= n3; ++i) {
            cellPropertySetter.setProperty(CellUtil.getRow(i, sheet), n4);
        }
    }

    public static void setBorderRight(int n, CellRangeAddress cellRangeAddress, Sheet sheet, Workbook workbook) {
        int n2 = cellRangeAddress.getFirstRow();
        int n3 = cellRangeAddress.getLastRow();
        int n4 = cellRangeAddress.getLastColumn();
        CellPropertySetter cellPropertySetter = new CellPropertySetter(workbook, "borderRight", n);
        for (int i = n2; i <= n3; ++i) {
            cellPropertySetter.setProperty(CellUtil.getRow(i, sheet), n4);
        }
    }

    public static void setRightBorderColor(int n, CellRangeAddress cellRangeAddress, Sheet sheet, Workbook workbook) {
        int n2 = cellRangeAddress.getFirstRow();
        int n3 = cellRangeAddress.getLastRow();
        int n4 = cellRangeAddress.getLastColumn();
        CellPropertySetter cellPropertySetter = new CellPropertySetter(workbook, "rightBorderColor", n);
        for (int i = n2; i <= n3; ++i) {
            cellPropertySetter.setProperty(CellUtil.getRow(i, sheet), n4);
        }
    }

    public static void setBorderBottom(int n, CellRangeAddress cellRangeAddress, Sheet sheet, Workbook workbook) {
        int n2 = cellRangeAddress.getFirstColumn();
        int n3 = cellRangeAddress.getLastColumn();
        int n4 = cellRangeAddress.getLastRow();
        CellPropertySetter cellPropertySetter = new CellPropertySetter(workbook, "borderBottom", n);
        Row row = CellUtil.getRow(n4, sheet);
        for (int i = n2; i <= n3; ++i) {
            cellPropertySetter.setProperty(row, i);
        }
    }

    public static void setBottomBorderColor(int n, CellRangeAddress cellRangeAddress, Sheet sheet, Workbook workbook) {
        int n2 = cellRangeAddress.getFirstColumn();
        int n3 = cellRangeAddress.getLastColumn();
        int n4 = cellRangeAddress.getLastRow();
        CellPropertySetter cellPropertySetter = new CellPropertySetter(workbook, "bottomBorderColor", n);
        Row row = CellUtil.getRow(n4, sheet);
        for (int i = n2; i <= n3; ++i) {
            cellPropertySetter.setProperty(row, i);
        }
    }

    public static void setBorderTop(int n, CellRangeAddress cellRangeAddress, Sheet sheet, Workbook workbook) {
        int n2 = cellRangeAddress.getFirstColumn();
        int n3 = cellRangeAddress.getLastColumn();
        int n4 = cellRangeAddress.getFirstRow();
        CellPropertySetter cellPropertySetter = new CellPropertySetter(workbook, "borderTop", n);
        Row row = CellUtil.getRow(n4, sheet);
        for (int i = n2; i <= n3; ++i) {
            cellPropertySetter.setProperty(row, i);
        }
    }

    public static void setTopBorderColor(int n, CellRangeAddress cellRangeAddress, Sheet sheet, Workbook workbook) {
        int n2 = cellRangeAddress.getFirstColumn();
        int n3 = cellRangeAddress.getLastColumn();
        int n4 = cellRangeAddress.getFirstRow();
        CellPropertySetter cellPropertySetter = new CellPropertySetter(workbook, "topBorderColor", n);
        Row row = CellUtil.getRow(n4, sheet);
        for (int i = n2; i <= n3; ++i) {
            cellPropertySetter.setProperty(row, i);
        }
    }

    private static final class CellPropertySetter {
        private final Workbook _workbook;
        private final String _propertyName;
        private final Short _propertyValue;

        public CellPropertySetter(Workbook workbook, String string, int n) {
            this._workbook = workbook;
            this._propertyName = string;
            this._propertyValue = (short)n;
        }

        public void setProperty(Row row, int n) {
            Cell cell = CellUtil.getCell(row, n);
            CellUtil.setCellStyleProperty(cell, this._workbook, this._propertyName, this._propertyValue);
        }
    }
}

