/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.util;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.util.CellReference;

public abstract class CellRangeAddressBase {
    private int _firstRow;
    private int _firstCol;
    private int _lastRow;
    private int _lastCol;

    protected CellRangeAddressBase(int n, int n2, int n3, int n4) {
        this._firstRow = n;
        this._lastRow = n2;
        this._firstCol = n3;
        this._lastCol = n4;
    }

    public void validate(SpreadsheetVersion spreadsheetVersion) {
        CellRangeAddressBase.validateRow(this._firstRow, spreadsheetVersion);
        CellRangeAddressBase.validateRow(this._lastRow, spreadsheetVersion);
        CellRangeAddressBase.validateColumn(this._firstCol, spreadsheetVersion);
        CellRangeAddressBase.validateColumn(this._lastCol, spreadsheetVersion);
    }

    private static void validateRow(int n, SpreadsheetVersion spreadsheetVersion) {
        int n2 = spreadsheetVersion.getLastRowIndex();
        if (n > n2) {
            throw new IllegalArgumentException("Maximum row number is " + n2);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Minumum row number is 0");
        }
    }

    private static void validateColumn(int n, SpreadsheetVersion spreadsheetVersion) {
        int n2 = spreadsheetVersion.getLastColumnIndex();
        if (n > n2) {
            throw new IllegalArgumentException("Maximum column number is " + n2);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Minimum column number is 0");
        }
    }

    public final boolean isFullColumnRange() {
        return this._firstRow == 0 && this._lastRow == SpreadsheetVersion.EXCEL97.getLastRowIndex() || this._firstRow == -1 && this._lastRow == -1;
    }

    public final boolean isFullRowRange() {
        return this._firstCol == 0 && this._lastCol == SpreadsheetVersion.EXCEL97.getLastColumnIndex() || this._firstCol == -1 && this._lastCol == -1;
    }

    public final int getFirstColumn() {
        return this._firstCol;
    }

    public final int getFirstRow() {
        return this._firstRow;
    }

    public final int getLastColumn() {
        return this._lastCol;
    }

    public final int getLastRow() {
        return this._lastRow;
    }

    public boolean isInRange(int n, int n2) {
        return this._firstRow <= n && n <= this._lastRow && this._firstCol <= n2 && n2 <= this._lastCol;
    }

    public final void setFirstColumn(int n) {
        this._firstCol = n;
    }

    public final void setFirstRow(int n) {
        this._firstRow = n;
    }

    public final void setLastColumn(int n) {
        this._lastCol = n;
    }

    public final void setLastRow(int n) {
        this._lastRow = n;
    }

    public int getNumberOfCells() {
        return (this._lastRow - this._firstRow + 1) * (this._lastCol - this._firstCol + 1);
    }

    public final String toString() {
        CellReference cellReference = new CellReference(this._firstRow, this._firstCol);
        CellReference cellReference2 = new CellReference(this._lastRow, this._lastCol);
        return this.getClass().getName() + " [" + cellReference.formatAsString() + ":" + cellReference2.formatAsString() + "]";
    }
}

