/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.usermodel;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.POIXMLDocument;
import ai2.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackageAccess;
import ai2.org.apache.poi.poifs.crypt.Decryptor;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.ss.usermodel.Workbook;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.GeneralSecurityException;

public class WorkbookFactory {
    public static Workbook create(POIFSFileSystem pOIFSFileSystem) throws IOException {
        return new HSSFWorkbook(pOIFSFileSystem);
    }

    public static Workbook create(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        try {
            return WorkbookFactory.create(nPOIFSFileSystem, null);
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IOException(invalidFormatException);
        }
    }

    private static Workbook create(NPOIFSFileSystem nPOIFSFileSystem, String string) throws IOException, InvalidFormatException {
        DirectoryNode directoryNode = nPOIFSFileSystem.getRoot();
        if (directoryNode.hasEntry("EncryptedPackage")) {
            EncryptionInfo encryptionInfo = new EncryptionInfo(nPOIFSFileSystem);
            Decryptor decryptor = Decryptor.getInstance(encryptionInfo);
            boolean bl = false;
            InputStream inputStream = null;
            try {
                if (string != null && decryptor.verifyPassword(string)) {
                    bl = true;
                }
                if (!bl && decryptor.verifyPassword("VelvetSweatshop")) {
                    bl = true;
                }
                if (bl) {
                    inputStream = decryptor.getDataStream(directoryNode);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException(generalSecurityException);
            }
            if (!bl) {
                if (string != null) {
                    throw new EncryptedDocumentException("Password incorrect");
                }
                throw new EncryptedDocumentException("The supplied spreadsheet is protected, but no password was supplied");
            }
            OPCPackage oPCPackage = OPCPackage.open(inputStream);
            return WorkbookFactory.create(oPCPackage);
        }
        if (string != null) {
            Biff8EncryptionKey.setCurrentUserPassword(string);
        }
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(directoryNode, true);
        Biff8EncryptionKey.setCurrentUserPassword(null);
        return hSSFWorkbook;
    }

    public static Workbook create(OPCPackage oPCPackage) throws IOException {
        return new XSSFWorkbook(oPCPackage);
    }

    public static Workbook create(InputStream inputStream) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(inputStream, null);
    }

    public static Workbook create(InputStream inputStream, String string) throws IOException, InvalidFormatException, EncryptedDocumentException {
        byte[] byArray;
        if (!inputStream.markSupported()) {
            inputStream = new PushbackInputStream(inputStream, 8);
        }
        if (NPOIFSFileSystem.hasPOIFSHeader(byArray = IOUtils.peekFirst8Bytes(inputStream))) {
            NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(inputStream);
            return WorkbookFactory.create(nPOIFSFileSystem, string);
        }
        if (POIXMLDocument.hasOOXMLHeader(inputStream)) {
            return new XSSFWorkbook(OPCPackage.open(inputStream));
        }
        throw new InvalidFormatException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static Workbook create(File file) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(file, null);
    }

    public static Workbook create(File file, String string) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(file, string, false);
    }

    public static Workbook create(File file, String string, boolean bl) throws IOException, InvalidFormatException, EncryptedDocumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        try {
            NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(file, bl);
            return WorkbookFactory.create(nPOIFSFileSystem, string);
        }
        catch (OfficeXmlFileException officeXmlFileException) {
            OPCPackage oPCPackage = OPCPackage.open(file, bl ? PackageAccess.READ : PackageAccess.READ_WRITE);
            try {
                return new XSSFWorkbook(oPCPackage);
            }
            catch (IOException iOException) {
                oPCPackage.revert();
                throw iOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                oPCPackage.revert();
                throw illegalArgumentException;
            }
        }
    }
}

