/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.usermodel;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FormulaError {
    NULL(0, "#NULL!"),
    DIV0(7, "#DIV/0!"),
    VALUE(15, "#VALUE!"),
    REF(23, "#REF!"),
    NAME(29, "#NAME?"),
    NUM(36, "#NUM!"),
    NA(42, "#N/A"),
    CIRCULAR_REF(-60, "~CIRCULAR~REF~"),
    FUNCTION_NOT_IMPLEMENTED(-30, "~FUNCTION~NOT~IMPLEMENTED~");

    private final byte type;
    private final int longType;
    private final String repr;
    private static Map<String, FormulaError> smap;
    private static Map<Byte, FormulaError> bmap;
    private static Map<Integer, FormulaError> imap;

    private FormulaError(int n2, String string2) {
        this.type = (byte)n2;
        this.longType = n2;
        this.repr = string2;
    }

    public byte getCode() {
        return this.type;
    }

    public int getLongCode() {
        return this.longType;
    }

    public String getString() {
        return this.repr;
    }

    public static final boolean isValidCode(int n) {
        for (FormulaError formulaError : FormulaError.values()) {
            if (formulaError.getCode() == n) {
                return true;
            }
            if (formulaError.getLongCode() != n) continue;
            return true;
        }
        return false;
    }

    public static FormulaError forInt(byte by) {
        FormulaError formulaError = bmap.get(by);
        if (formulaError == null) {
            throw new IllegalArgumentException("Unknown error type: " + by);
        }
        return formulaError;
    }

    public static FormulaError forInt(int n) {
        FormulaError formulaError = imap.get(n);
        if (formulaError == null) {
            formulaError = bmap.get((byte)n);
        }
        if (formulaError == null) {
            throw new IllegalArgumentException("Unknown error type: " + n);
        }
        return formulaError;
    }

    public static FormulaError forString(String string) {
        FormulaError formulaError = smap.get(string);
        if (formulaError == null) {
            throw new IllegalArgumentException("Unknown error code: " + string);
        }
        return formulaError;
    }

    static {
        smap = new HashMap<String, FormulaError>();
        bmap = new HashMap<Byte, FormulaError>();
        imap = new HashMap<Integer, FormulaError>();
        for (FormulaError formulaError : FormulaError.values()) {
            bmap.put(formulaError.getCode(), formulaError);
            imap.put(formulaError.getLongCode(), formulaError);
            smap.put(formulaError.getString(), formulaError);
        }
    }
}

