/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.usermodel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FontUnderline {
    SINGLE(1),
    DOUBLE(2),
    SINGLE_ACCOUNTING(3),
    DOUBLE_ACCOUNTING(4),
    NONE(5);

    private int value;
    private static FontUnderline[] _table;

    private FontUnderline(int n2) {
        this.value = n2;
    }

    public int getValue() {
        return this.value;
    }

    public byte getByteValue() {
        switch (this) {
            case DOUBLE: {
                return 2;
            }
            case DOUBLE_ACCOUNTING: {
                return 34;
            }
            case SINGLE_ACCOUNTING: {
                return 33;
            }
            case NONE: {
                return 0;
            }
            case SINGLE: {
                return 1;
            }
        }
        return 1;
    }

    public static FontUnderline valueOf(int n) {
        return _table[n];
    }

    public static FontUnderline valueOf(byte by) {
        FontUnderline fontUnderline;
        switch (by) {
            case 2: {
                fontUnderline = DOUBLE;
                break;
            }
            case 34: {
                fontUnderline = DOUBLE_ACCOUNTING;
                break;
            }
            case 33: {
                fontUnderline = SINGLE_ACCOUNTING;
                break;
            }
            case 1: {
                fontUnderline = SINGLE;
                break;
            }
            default: {
                fontUnderline = NONE;
            }
        }
        return fontUnderline;
    }

    static {
        _table = new FontUnderline[6];
        FontUnderline[] fontUnderlineArray = FontUnderline.values();
        int n = fontUnderlineArray.length;
        for (int i = 0; i < n; ++i) {
            FontUnderline fontUnderline;
            FontUnderline._table[fontUnderline.getValue()] = fontUnderline = fontUnderlineArray[i];
        }
    }
}

