/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.usermodel;

import ai2.org.apache.poi.hssf.util.HSSFColor;
import ai2.org.apache.poi.ss.usermodel.Color;
import java.util.Locale;

public abstract class ExtendedColor
implements Color {
    protected void setColor(java.awt.Color color) {
        this.setRGB(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
    }

    public abstract boolean isAuto();

    public abstract boolean isIndexed();

    public abstract boolean isRGB();

    public abstract boolean isThemed();

    public abstract short getIndex();

    public abstract int getTheme();

    public abstract byte[] getRGB();

    public abstract byte[] getARGB();

    protected abstract byte[] getStoredRBG();

    public abstract void setRGB(byte[] var1);

    protected byte[] getRGBOrARGB() {
        byte[] byArray = null;
        if (this.isIndexed() && this.getIndex() > 0) {
            short s = this.getIndex();
            HSSFColor hSSFColor = HSSFColor.getIndexHash().get(s);
            if (hSSFColor != null) {
                byArray = new byte[]{(byte)hSSFColor.getTriplet()[0], (byte)hSSFColor.getTriplet()[1], (byte)hSSFColor.getTriplet()[2]};
                return byArray;
            }
        }
        byArray = this.getStoredRBG();
        return byArray;
    }

    public byte[] getRGBWithTint() {
        byte[] byArray = this.getStoredRBG();
        if (byArray != null) {
            if (byArray.length == 4) {
                byte[] byArray2 = new byte[3];
                System.arraycopy(byArray, 1, byArray2, 0, 3);
                byArray = byArray2;
            }
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = ExtendedColor.applyTint(byArray[i] & 0xFF, this.getTint());
            }
        }
        return byArray;
    }

    public String getARGBHex() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getARGB();
        if (byArray == null) {
            return null;
        }
        for (byte by : byArray) {
            int n = by & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString().toUpperCase(Locale.ROOT);
    }

    public void setARGBHex(String string) {
        byte[] byArray;
        if (string.length() == 6 || string.length() == 8) {
            byArray = new byte[string.length() / 2];
            for (int i = 0; i < byArray.length; ++i) {
                String string2 = string.substring(i * 2, (i + 1) * 2);
                byArray[i] = (byte)Integer.parseInt(string2, 16);
            }
        } else {
            throw new IllegalArgumentException("Must be of the form 112233 or FFEEDDCC");
        }
        this.setRGB(byArray);
    }

    private static byte applyTint(int n, double d) {
        if (d > 0.0) {
            return (byte)((double)n * (1.0 - d) + (255.0 - 255.0 * (1.0 - d)));
        }
        if (d < 0.0) {
            return (byte)((double)n * (1.0 + d));
        }
        return (byte)n;
    }

    public abstract double getTint();

    public abstract void setTint(double var1);
}

