/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.formula.ptg.OperandPtg;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public abstract class RefPtgBase
extends OperandPtg {
    private int field_1_row;
    private int field_2_col;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField column = BitFieldFactory.getInstance(16383);

    protected RefPtgBase() {
    }

    protected RefPtgBase(CellReference cellReference) {
        this.setRow(cellReference.getRow());
        this.setColumn(cellReference.getCol());
        this.setColRelative(!cellReference.isColAbsolute());
        this.setRowRelative(!cellReference.isRowAbsolute());
    }

    protected final void readCoordinates(LittleEndianInput littleEndianInput) {
        this.field_1_row = littleEndianInput.readUShort();
        this.field_2_col = littleEndianInput.readUShort();
    }

    protected final void writeCoordinates(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_row);
        littleEndianOutput.writeShort(this.field_2_col);
    }

    public final void setRow(int n) {
        this.field_1_row = n;
    }

    public final int getRow() {
        return this.field_1_row;
    }

    public final boolean isRowRelative() {
        return rowRelative.isSet(this.field_2_col);
    }

    public final void setRowRelative(boolean bl) {
        this.field_2_col = rowRelative.setBoolean(this.field_2_col, bl);
    }

    public final boolean isColRelative() {
        return colRelative.isSet(this.field_2_col);
    }

    public final void setColRelative(boolean bl) {
        this.field_2_col = colRelative.setBoolean(this.field_2_col, bl);
    }

    public final void setColumn(int n) {
        this.field_2_col = column.setValue(this.field_2_col, n);
    }

    public final int getColumn() {
        return column.getValue(this.field_2_col);
    }

    protected final String formatReferenceAsString() {
        CellReference cellReference = new CellReference(this.getRow(), this.getColumn(), !this.isRowRelative(), !this.isColRelative());
        return cellReference.formatAsString();
    }

    public final byte getDefaultOperandClass() {
        return 0;
    }
}

