/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.formula.ExternSheetReferenceToken;
import ai2.org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import ai2.org.apache.poi.ss.formula.WorkbookDependentFormula;
import ai2.org.apache.poi.ss.formula.ptg.ExternSheetNameResolver;
import ai2.org.apache.poi.ss.formula.ptg.RefPtgBase;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class Ref3DPtg
extends RefPtgBase
implements WorkbookDependentFormula,
ExternSheetReferenceToken {
    public static final byte sid = 58;
    private static final int SIZE = 7;
    private int field_1_index_extern_sheet;

    public Ref3DPtg(LittleEndianInput littleEndianInput) {
        this.field_1_index_extern_sheet = littleEndianInput.readShort();
        this.readCoordinates(littleEndianInput);
    }

    public Ref3DPtg(String string, int n) {
        this(new CellReference(string), n);
    }

    public Ref3DPtg(CellReference cellReference, int n) {
        super(cellReference);
        this.setExternSheetIndex(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        stringBuffer.append("sheetIx=").append(this.getExternSheetIndex());
        stringBuffer.append(" ! ");
        stringBuffer.append(this.formatReferenceAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(58 + this.getPtgClass());
        littleEndianOutput.writeShort(this.getExternSheetIndex());
        this.writeCoordinates(littleEndianOutput);
    }

    public int getSize() {
        return 7;
    }

    public int getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    public void setExternSheetIndex(int n) {
        this.field_1_index_extern_sheet = n;
    }

    public String format2DRefAsString() {
        return this.formatReferenceAsString();
    }

    public String toFormulaString(FormulaRenderingWorkbook formulaRenderingWorkbook) {
        return ExternSheetNameResolver.prependSheetName(formulaRenderingWorkbook, this.field_1_index_extern_sheet, this.formatReferenceAsString());
    }

    public String toFormulaString() {
        throw new RuntimeException("3D references need a workbook to determine formula text");
    }
}

