/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.formula.ptg.OperandPtg;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class MemAreaPtg
extends OperandPtg {
    public static final short sid = 38;
    private static final int SIZE = 7;
    private final int field_1_reserved;
    private final int field_2_subex_len;

    public MemAreaPtg(int n) {
        this.field_1_reserved = 0;
        this.field_2_subex_len = n;
    }

    public MemAreaPtg(LittleEndianInput littleEndianInput) {
        this.field_1_reserved = littleEndianInput.readInt();
        this.field_2_subex_len = littleEndianInput.readShort();
    }

    public int getLenRefSubexpression() {
        return this.field_2_subex_len;
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(38 + this.getPtgClass());
        littleEndianOutput.writeInt(this.field_1_reserved);
        littleEndianOutput.writeShort(this.field_2_subex_len);
    }

    public int getSize() {
        return 7;
    }

    public String toFormulaString() {
        return "";
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [len=");
        stringBuffer.append(this.field_2_subex_len);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

