/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.formula.ptg.ScalarConstantPtg;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class IntPtg
extends ScalarConstantPtg {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 65535;
    public static final int SIZE = 3;
    public static final byte sid = 30;
    private final int field_1_value;

    public static boolean isInRange(int n) {
        return n >= 0 && n <= 65535;
    }

    public IntPtg(LittleEndianInput littleEndianInput) {
        this(littleEndianInput.readUShort());
    }

    public IntPtg(int n) {
        if (!IntPtg.isInRange(n)) {
            throw new IllegalArgumentException("value is out of range: " + n);
        }
        this.field_1_value = n;
    }

    public int getValue() {
        return this.field_1_value;
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(30 + this.getPtgClass());
        littleEndianOutput.writeShort(this.getValue());
    }

    public int getSize() {
        return 3;
    }

    public String toFormulaString() {
        return String.valueOf(this.getValue());
    }
}

