/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ss.formula.ptg;

import ai2.org.apache.poi.ss.formula.SheetNameFormatter;
import ai2.org.apache.poi.ss.formula.ptg.OperandPtg;
import ai2.org.apache.poi.ss.formula.ptg.Pxg;
import ai2.org.apache.poi.ss.usermodel.ErrorConstants;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class Deleted3DPxg
extends OperandPtg
implements Pxg {
    private int externalWorkbookNumber = -1;
    private String sheetName;

    public Deleted3DPxg(int n, String string) {
        this.externalWorkbookNumber = n;
        this.sheetName = string;
    }

    public Deleted3DPxg(String string) {
        this(-1, string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        if (this.externalWorkbookNumber >= 0) {
            stringBuffer.append(" [");
            stringBuffer.append("workbook=").append(this.getExternalWorkbookNumber());
            stringBuffer.append("] ");
        }
        stringBuffer.append("sheet=").append(this.getSheetName());
        stringBuffer.append(" ! ");
        stringBuffer.append(ErrorConstants.getText(23));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int getExternalWorkbookNumber() {
        return this.externalWorkbookNumber;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String string) {
        this.sheetName = string;
    }

    public String toFormulaString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.externalWorkbookNumber >= 0) {
            stringBuffer.append('[');
            stringBuffer.append(this.externalWorkbookNumber);
            stringBuffer.append(']');
        }
        if (this.sheetName != null) {
            SheetNameFormatter.appendFormat(stringBuffer, this.sheetName);
        }
        stringBuffer.append('!');
        stringBuffer.append(ErrorConstants.getText(23));
        return stringBuffer.toString();
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public int getSize() {
        return 1;
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        throw new IllegalStateException("XSSF-only Ptg, should not be serialised");
    }
}

